/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	__webpack_require__(1);
	Wizards.t = Wizards.I18N.createT('com.suncode.plugin-wizards-change-user');
	
	var Application = __webpack_require__(3),
	  Viewport = __webpack_require__(4),
	  PermissionController = __webpack_require__(15);
	
	/**
	 * Main application of Change User Administration
	 *
	 * @main
	 */
	Application.create({
	  name: 'User Change Configuration',
	  view: {
	    type: Viewport,
	    target: 'wizard-change-user-admin-container',
	  },
	  controllers: [PermissionController],
	});


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var cached = {};
	
	module.exports = Ext.define('Wizards.I18N', {
	  singleton: true,
	
	  /**
	   * Returns translated message for given key and translator name.
	   *
	   * @example
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * @method t
	   * @param {String} translator translator name
	   * @param {String} key message key
	   * @param {...Object} [args] additional message arguments (resolved as placeholders i.e. {0})
	   * @return Translated message or supplied key if there is no translation available
	   */
	  t: function (translator, key) {
	    var message = this.bundle(translator)[key];
	    if (!Ext.isEmpty(message)) {
	      var args = Ext.Array.toArray(arguments, 2);
	      return Ext.String.format.apply(this, [message].concat(args));
	    }
	    return key;
	  },
	
	  /**
	   * Creates shorthand function for translating message using single translator. For example instead of
	   *
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * you can use create shorthand function once
	   *
	   * 	PW.t = PW.I18N.createT('plusworkflow');
	   *
	   * and then use it like
	   *
	   * 	PW.t('user.desc', 'Jan', 'Kowalski' );
	   *
	   * @method createT
	   * @param {String} translator translator name
	   */
	  createT: function (translator) {
	    return Ext.bind(this.t, this, [translator], 0);
	  },
	
	  bundle: function (key) {
	    var bundle = cached[key];
	
	    // Jeżeli nie ma załadowanego bundle'a to SYNCHRONICZNIE pobieramy go z bazy danych
	    if (!Ext.isObject(bundle)) {
	      Ext.Ajax.request({
	        url: Suncode.getAbsolutePath('/api/translation/bundle/' + encodeURIComponent(key)),
	        method: 'GET',
	        async: false,
	        timeout: 5000,
	        success: function (response) {
	          bundle = Ext.decode(response.responseText);
	          cached[key] = bundle;
	        },
	      });
	    }
	    return bundle || {};
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {// Przygotowanie kontekstu do przechowywania danych na temat aplikacji
	var context = Suncode.context('changeuser');
	if (!context.applications) {
	  context.applications = {};
	}
	
	/**
	 * Aplikacja
	 */
	module.exports = Ext.define('Wizards.changeuser.admin.app.Application', {
	  constructor: function (config) {
	    var existingApp = context.applications[config.name];
	    if (existingApp) {
	      existingApp.destroy();
	    }
	
	    try {
	      this.prepareControllers(config.controllers);
	      this.prepareView(config.view);
	      this.init(config.launch);
	    } finally {
	      context.applications[config.name] = this;
	    }
	  },
	
	  prepareControllers: function (controllers) {
	    this.controllers = [];
	    Ext.each(
	      controllers,
	      function (controllerClass) {
	        var controller = controllerClass.create();
	        controller.id = controllerClass.$className;
	
	        controller.fireGlobalEvent = function () {
	          Ext.globalEvents.fireEvent.apply(Ext.globalEvents, arguments);
	        };
	        controller.listenGlobal = function (event) {
	          Ext.globalEvents.on.apply(Ext.globalEvents, arguments);
	        };
	
	        this.controllers.push(controller);
	      },
	      this
	    );
	  },
	
	  prepareView: function (view) {
	    this.view = view.type.create({
	      renderTarget: view.target,
	    });
	  },
	
	  init: function (launchFn) {
	    Ext.tip.QuickTipManager.init();
	    Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider());
	
	    Ext.each(
	      this.controllers,
	      function (controller) {
	        controller.init();
	      },
	      this
	    );
	
	    Ext.onReady(
	      function () {
	        // render view
	        this.view.render(this.view.renderTarget);
	
	        // call launch
	        if (Ext.isFunction(launchFn)) {
	          launchFn.call(this, this.view);
	        }
	
	        Ext.each(
	          this.controllers,
	          function (controller) {
	            controller.finishInit();
	          },
	          this
	        );
	      },
	      this,
	      {
	        single: true,
	      }
	    );
	  },
	
	  destroy: function () {
	    if (this.view) {
	      this.view.destroy();
	    }
	
	    if (this.controllers) {
	      Ext.each(
	        this.controllers,
	        function (controller) {
	          controller.eventbus.unlisten(controller.id);
	        },
	        this
	      );
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(5);
	
	module.exports = Ext.define('OCI.configuration.Viewport', {
	  extend: 'Ext.container.Container',
	  xtype: 'cange-user-admin-viewport',
	
	  height: 600,
	  border: false,
	  style: {
	    'text-align': 'left',
	  },
	  bodyStyle: {
	    background: 'none',
	  },
	
	  items: [
	    {
	      xtype: 'change-user-admin-permission-panel',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(6);
	__webpack_require__(11);
	
	module.exports = Ext.define('Wizards.changeuser.administration.permission.PermissionPanel', {
	  extend: 'Ext.panel.Panel',
	  xtype: 'change-user-admin-permission-panel',
	
	  layout: {
	    type: 'hbox',
	    align: 'stretch',
	  },
	  border: false,
	
	  items: [
	    {
	      xtype: 'change-user-admin-permission-new',
	      flex: 1,
	      style: 'margin-right: 5px;',
	    },
	    {
	      xtype: 'change-user-admin-permission-grid',
	      height: 600,
	      flex: 2,
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(7);
	
	var usersStore = __webpack_require__(8),
	  groupsStore = __webpack_require__(9),
	  processDefinitionsStore = __webpack_require__(10);
	
	module.exports = Ext.define('Wizards.changeuser.administration.permission.form.NewPermissionForm', {
	  extend: 'Ext.form.Panel',
	  xtype: 'change-user-admin-permission-new',
	
	  title: Wizards.t('administration.permissions.new.title'),
	
	  bodyPadding: 10,
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  items: [
	    {
	      xtype: 'radiogroup',
	      allowBlank: false,
	      itemId: 'resourceTypeGroup',
	      columns: 2,
	      items: [
	        {
	          xtype: 'change-user-radio',
	          boxLabel: Wizards.t('administration.permissions.new.field.user'),
	          name: 'resourceType',
	          iconCls: 'dvnt-icon-user',
	          inputValue: 'USER',
	          checked: true,
	        },
	        {
	          xtype: 'change-user-radio',
	          boxLabel: Wizards.t('administration.permissions.new.field.group'),
	          name: 'resourceType',
	          iconCls: 'dvnt-icon-users',
	          inputValue: 'GROUP',
	        },
	      ],
	    },
	    {
	      xtype: 'combo',
	      allowBlank: false,
	      name: 'resourceId',
	      itemId: 'userCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.user'),
	      store: usersStore,
	      valueField: 'objectId',
	      displayField: 'viewName',
	      pageSize: 20,
	      minChars: 0,
	      forceSelection: true,
	    },
	    {
	      xtype: 'combo',
	      allowBlank: false,
	      name: 'resourceId',
	      itemId: 'groupCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.group'),
	      store: groupsStore,
	      valueField: 'objectId',
	      displayField: 'name',
	      pageSize: 20,
	      disabled: true,
	      minChars: 0,
	      forceSelection: true,
	    },
	    {
	      xtype: 'combo',
	      allowBlank: true,
	      name: 'processDefId',
	      itemId: 'processDefCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.processdef'),
	      store: processDefinitionsStore,
	      valueField: 'processDefId',
	      displayField: 'processDefName',
	      minChars: 0,
	      pageSize: 20,
	      emptyText: '*',
	      forceSelection: true,
	    },
	  ],
	
	  bbar: [
	    {
	      xtype: 'button',
	      itemId: 'newPermissionBtn',
	      text: Wizards.t('administration.permissions.new.button.add'),
	      iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
	      iconAlign: 'left',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changeuser.administration.util.RadioField', {
	  extend: 'Ext.form.field.Radio',
	  xtype: 'change-user-radio',
	
	  iconSpanStyle: 'width:16px;height:16px;display:inline-block;margin-right:5px',
	
	  constructor: function (config) {
	    var iconCls = config.iconCls;
	
	    if (!Ext.isEmpty(iconCls)) {
	      this.beforeBoxLabelTextTpl = '<span style="' + this.iconSpanStyle + '" class="' + iconCls + '"></span>';
	    }
	    this.callParent(arguments);
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  pageSize: 20,
	  fields: [
	    'objectId',
	    'userName',
	    'fullName',
	    {
	      name: 'viewName',
	      convert: function (value, record) {
	        var userName = record.get('userName');
	        var fullName = record.get('fullName');
	
	        return Ext.isEmpty(fullName) ? userName : fullName + ' (' + userName + ')';
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-user').contextPath + '/api/users/query',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  pageSize: 20,
	  fields: ['name', 'objectId'],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-user').contextPath + '/api/groups/query',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  fields: ['processDefId', 'processDefName'],
	  pageSize: 20,
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-user').pluginContextPath + '/administration/processdefinitions',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(12),
	  Renderers = __webpack_require__(14);
	
	module.exports = Ext.define('Wizards.changeuser.administration.permission.PermissionGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'change-user-admin-permission-grid',
	
	  title: Wizards.t('administration.permissions.grid.title'),
	
	  store: store,
	  columns: [
	    {
	      text: Wizards.t('administration.permissions.grid.column.resourcename'),
	      dataIndex: 'resourceName',
	      flex: 1,
	    },
	    {
	      text: Wizards.t('administration.permissions.grid.column.processdefname'),
	      dataIndex: 'processDefName',
	      flex: 1,
	    },
	    {
	      dataIndex: 'resourceType',
	      width: 50,
	      renderer: function (value) {
	        var type = value.toLowerCase(),
	          cls = type === 'user' ? 'dvnt-icon-user' : 'dvnt-icon-users',
	          qtip =
	            type === 'user'
	              ? Wizards.t('administration.permissions.grid.column.resourcetype.user')
	              : Wizards.t('administration.permissions.grid.column.resourcetype.group');
	        return Renderers.icon(cls, qtip);
	      },
	    },
	    {
	      xtype: 'actioncolumn',
	      width: 50,
	      items: [
	        {
	          iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
	          tooltip: Wizards.t('administration.permissions.grid.action.tooltip'),
	          scope: this,
	          handler: function (view, rowIndex, colIndex, item, e, record) {
	            Ext.Msg.confirm(
	              Wizards.t('administration.permissions.grid.action.message.title'),
	              Wizards.t('administration.permissions.grid.action.message.text', record.get('resourceName')),
	              function (buttonId) {
	                if (buttonId === 'yes') {
	                  view.fireEvent('deleteClick', record);
	                }
	              }
	            );
	          },
	        },
	      ],
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(13);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changeuser.administration.permissions.Permission',
	  autoLoad: true,
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-user').pluginContextPath + '/permissions/all',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changeuser.administration.permissions.Permission', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    {
	      name: 'id',
	      type: 'int',
	    },
	    'resourceType',
	    'resourceName',
	    'processDefName',
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {Ext.define('Wizards.changeuser.administration.util.Renderers', {
	  singleton: true,
	
	  icon: function (iconCls, tooltip) {
	    return (
	      '<span ' +
	      'data-qtip="' +
	      tooltip +
	      '" ' +
	      'style="display: inline-block;width: 16px; height: 16px; padding:2px" ' +
	      'class ="' +
	      iconCls +
	      '"></span>'
	    );
	  },
	});
	
	module.exports = Wizards.changeuser.administration.util.Renderers;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changeuser.administration.permissions.PermissionsController', {
	  extend: 'Ext.app.Controller',
	
	  refs: [
	    {
	      ref: 'permissionsGrid',
	      selector: 'change-user-admin-permission-grid',
	    },
	    {
	      ref: 'newPermissionForm',
	      selector: 'change-user-admin-permission-new',
	    },
	  ],
	
	  init: function () {
	    this.control({
	      'change-user-admin-permission-grid gridview': {
	        deleteClick: this.onDeleteClick,
	      },
	      'change-user-admin-permission-new #newPermissionBtn': {
	        click: this.newPermission,
	      },
	      'change-user-admin-permission-new #resourceTypeGroup': {
	        change: this.onResourceTypeGroupChange,
	      },
	    });
	  },
	
	  onDeleteClick: function (record) {
	    Ext.Ajax.request({
	      url: Suncode.context('change-user').pluginContextPath + '/permissions/delete/' + record.get('id'),
	      scope: this,
	      success: function (response) {
	        this.manageResponse(
	          response,
	          function () {
	            this.getPermissionsGrid().getStore().load();
	          },
	          this
	        );
	      },
	      failure: function () {},
	    });
	  },
	
	  manageResponse: function (response, fn, scope) {
	    var me = this,
	      status = Ext.decode(response.responseText);
	
	    if (status.success) {
	      fn.call(scope ? scope : me);
	    } else {
	      Ext.Msg.alert(Wizards.t('basic.error'), status.message);
	    }
	  },
	
	  newPermission: function () {
	    var form = this.getNewPermissionForm().getForm();
	    this.savePermission(form, true);
	  },
	
	  savePermission: function (form, reset) {
	    if (form.isValid()) {
	      Ext.Ajax.request({
	        url: Suncode.context('change-user').pluginContextPath + '/permissions/save',
	        method: 'POST',
	        jsonData: form.getValues(),
	        scope: this,
	        success: function (response) {
	          this.manageResponse(
	            response,
	            function () {
	              this.getPermissionsGrid().getStore().load();
	              if (reset) {
	                form.reset();
	              }
	            },
	            this
	          );
	        },
	        failure: function () {
	          // TODO błąd serwera
	        },
	      });
	    }
	  },
	
	  onResourceTypeGroupChange: function (radioGroup, newValue) {
	    var form = this.getNewPermissionForm(),
	      userCombo = form.down('#userCombo'),
	      groupCombo = form.down('#groupCombo');
	
	    userCombo.setDisabled(newValue.resourceType != 'USER');
	    groupCombo.setDisabled(newValue.resourceType != 'GROUP');
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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