/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser.administration.permission;

import com.suncode.plugin.wizards.changeuser.administration.AccessResource;
import com.suncode.plugin.wizards.changeuser.administration.Permission;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class PermissionDto {
    private Long id;
    private Long resourceId;
    private String resourceName;
    private AccessResource.ResourceType resourceType;
    private String processDefName;

    public PermissionDto(Permission permission) {
        this.id = permission.getId();
        AccessResource resource = permission.getResource();
        this.resourceType = resource.getType();
        if (resource.getType() == AccessResource.ResourceType.USER) {
            User user = resource.getUser();
            if (user != null) {
                this.resourceId = user.getObjectId();
                this.resourceName = StringUtils.hasText((String)user.getFullName()) ? String.format("%s (%s)", user.getFullName(), user.getUserName()) : user.getUserName();
            } else {
                this.resourceId = null;
                this.resourceName = "null";
            }
        } else if (resource.getType() == AccessResource.ResourceType.GROUP) {
            UserGroup group = resource.getGroup();
            if (group != null) {
                this.resourceId = group.getObjectId();
                this.resourceName = group.getName();
            } else {
                this.resourceId = null;
                this.resourceName = "null";
            }
        }
        this.processDefName = permission.getProcessDefName();
    }

    public static List<PermissionDto> from(List<Permission> list) {
        ArrayList<PermissionDto> result = new ArrayList<PermissionDto>();
        for (Permission permission : list) {
            PermissionDto dto = new PermissionDto(permission);
            result.add(dto);
        }
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public AccessResource.ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getProcessDefName() {
        return this.processDefName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setResourceType(AccessResource.ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setProcessDefName(String processDefName) {
        this.processDefName = processDefName;
    }

    public PermissionDto() {
    }
}

