/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser.administration;

import com.suncode.plugin.wizards.changeuser.administration.AccessResource;
import com.suncode.plugin.wizards.util.Injectable;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.springframework.beans.factory.annotation.Autowired;

@Injectable
@Entity(name="wizards_permissions")
@Table
public class Permission {
    private static final String SEQ = "wizards_permissions_id";
    @Id
    @GeneratedValue(generator="wizards_permissions_id")
    @SequenceGenerator(name="wizards_permissions_id", sequenceName="wizards_permissions_id")
    private Long id;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="resource_id")), @AttributeOverride(name="type", column=@Column(name="resource_type"))})
    private AccessResource resource;
    private String processDefId;
    @Transient
    @Autowired
    private ProcessService processService;

    public String getProcessDefName() {
        if (this.processDefId == null) {
            return "*";
        }
        ProcessDefinition processDefinition = this.processService.getProcessDefinition(this.processDefId);
        if (processDefinition == null) {
            return "null";
        }
        String packageId = processDefinition.getPackageId();
        return PackageTranslationHelper.getProcessName((String)packageId, (String)this.processDefId);
    }

    public Long getId() {
        return this.id;
    }

    public AccessResource getResource() {
        return this.resource;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setResource(AccessResource resource) {
        this.resource = resource;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }
}

