/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changeuser.administration;

import com.suncode.plugin.wizards.util.Injectable;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Transient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Embeddable
@Injectable
public class AccessResource {
    @Column(nullable=false)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private ResourceType type;
    @Autowired
    @Transient
    private UserService userService;
    @Transient
    private User user;
    @Transient
    private UserGroup group;

    public AccessResource(User user) {
        Assert.notNull((Object)user, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.user = user;
        this.id = user.getObjectId();
        this.type = ResourceType.USER;
    }

    public AccessResource(UserGroup group) {
        Assert.notNull((Object)group, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.group = group;
        this.id = group.getObjectId();
        this.type = ResourceType.GROUP;
    }

    public ResourceType getType() {
        return this.type;
    }

    public User getUser() {
        if (this.type == ResourceType.USER && this.user == null) {
            Assert.state((this.userService != null ? 1 : 0) != 0, (String)"[Assertion failed] - this state invariant must be true");
            this.user = this.userService.getUser(this.id, new String[0]);
        }
        return this.user;
    }

    public UserGroup getGroup() {
        if (this.type == ResourceType.GROUP && this.group == null) {
            Assert.state((this.userService != null ? 1 : 0) != 0, (String)"[Assertion failed] - this state invariant must be true");
            this.group = this.userService.getGroup(this.id, new String[0]);
        }
        return this.group;
    }

    public AccessResource() {
    }

    public static enum ResourceType {
        USER,
        GROUP;

    }
}

