/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata.administration.assignment;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.changedata.administration.Response;
import com.suncode.plugin.wizards.changedata.administration.assignment.Assignment;
import com.suncode.plugin.wizards.changedata.administration.assignment.AssignmentService;
import com.suncode.plugin.wizards.changedata.administration.assignment.dto.AcceptanceButtonDto;
import com.suncode.plugin.wizards.changedata.administration.assignment.dto.ActivityDto;
import com.suncode.plugin.wizards.changedata.administration.assignment.dto.AssignmentDto;
import com.suncode.plugin.wizards.changedata.administration.assignment.dto.ProcessDto;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assignment"})
public class AssignmentController {
    private static final Logger log = LoggerFactory.getLogger(AssignmentController.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private ProcessService processService;
    @Autowired
    private AssignmentService assignmentService;
    private XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
    private final String defaultChangeDataButton = "pwfl_change_data_default_button";

    @ResponseBody
    @RequestMapping(value={"processes"})
    public List<ProcessDto> getAllProcesses() {
        List processes = this.processService.getAllProcessTypes(false);
        return processes.stream().map(processType -> new ProcessDto((ProcessType)processType)).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"activities"})
    public List<ActivityDto> getAllActivities(@RequestParam String processDefId) {
        WorkflowProcess process = this.getWorkflowProcess(processDefId);
        Activities activities = process.getActivities();
        ArrayList activitiesList = activities.toElements();
        return activitiesList.stream().map(activityItem -> new ActivityDto((Activity)activityItem)).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"acceptancebuttons"})
    public List<AcceptanceButtonDto> getAcceptanceButtons(@RequestParam String processDefId, @RequestParam String activityDefId) {
        ArrayList<AcceptanceButtonDto> result = new ArrayList<AcceptanceButtonDto>();
        WorkflowProcess process = this.getWorkflowProcess(processDefId);
        Activity activity = process.getActivity(activityDefId);
        List<ExtendedAttribute> buttons = this.getAcceptanceButtons(activity);
        AcceptanceButtonDto changeDataButtonDto = new AcceptanceButtonDto();
        changeDataButtonDto.setAcceptanceButtonId("pwfl_change_data_default_button");
        changeDataButtonDto.setAcceptanceButtonName(this.plugin.getMessage("changedate.assignment.button.changedata"));
        result.add(changeDataButtonDto);
        if (!buttons.isEmpty()) {
            buttons.forEach(button -> {
                AcceptanceButtonDto acceptanceButtonDto = new AcceptanceButtonDto();
                acceptanceButtonDto.setAcceptanceButtonId(this.getButtonAttr((ExtendedAttribute)button, "actionName"));
                acceptanceButtonDto.setAcceptanceButtonName(this.getButtonAttr((ExtendedAttribute)button, "buttonName"));
                result.add(acceptanceButtonDto);
            });
        } else {
            AcceptanceButtonDto acceptanceButtonDto = new AcceptanceButtonDto();
            acceptanceButtonDto.setAcceptanceButtonId("");
            acceptanceButtonDto.setAcceptanceButtonName(this.plugin.getMessage("changedata.assignment.button.default"));
            result.add(acceptanceButtonDto);
        }
        return result;
    }

    private List<ExtendedAttribute> getAcceptanceButtons(Activity activity) {
        ArrayList buttons = activity.getExtendedAttributes().getElementsForName("ACTION_ACCEPT_BUTTON");
        return buttons != null ? buttons : Collections.emptyList();
    }

    private WorkflowProcess getWorkflowProcess(String processDefId) {
        String packageId = this.xpdlPackageManager.getPackageIdByProcessDefinitionId(processDefId);
        Package pack = this.xpdlPackageManager.getPackage(packageId);
        WorkflowProcess process = pack.getWorkflowProcess(processDefId);
        return process;
    }

    @ResponseBody
    @RequestMapping(value={"assignments"})
    public List<AssignmentDto> getAssignments() {
        return this.assignmentService.getAll(new String[0]).stream().map(assignment -> this.toAssignmentDto((Assignment)assignment)).collect(Collectors.toList());
    }

    private AssignmentDto toAssignmentDto(Assignment assignment) {
        String processDefId = assignment.getProcessDefId();
        String activityDefId = assignment.getActivityDefId();
        Optional<ProcessType> processType = this.processService.getAllProcessTypes(false).stream().filter(type -> processDefId.equals(type.getProcessDefId())).findFirst();
        Activity activity = this.getWorkflowProcess(processDefId).getActivity(activityDefId);
        AssignmentDto assignmentDto = new AssignmentDto();
        assignmentDto.setId(assignment.getId());
        assignmentDto.setActivityDefId(activityDefId);
        assignmentDto.setProcessDefId(processDefId);
        assignmentDto.setProcessName(processType.get().getName());
        assignmentDto.setAcceptanceButtonId(assignment.getAcceptanceButtonId());
        if (activity != null) {
            assignmentDto.setActivityName(activity.getName());
            assignmentDto.setAcceptanceButtonName(this.acceptanceButtonName(activity, assignment));
            assignmentDto.setActive(true);
        } else {
            assignmentDto.setActivityName(activityDefId);
            assignmentDto.setAcceptanceButtonName(assignment.getAcceptanceButtonId());
            assignmentDto.setActive(false);
        }
        return assignmentDto;
    }

    private String acceptanceButtonName(Activity activity, Assignment assignment) {
        List<ExtendedAttribute> buttons = this.getAcceptanceButtons(activity);
        String buttonId = assignment.getAcceptanceButtonId();
        if (StringUtils.isNotBlank((CharSequence)buttonId) && buttonId.equals("pwfl_change_data_default_button")) {
            return this.plugin.getMessage("changedate.assignment.button.changedata");
        }
        if (!buttons.isEmpty() && !StringUtils.isEmpty((CharSequence)buttonId)) {
            for (ExtendedAttribute button : buttons) {
                if (!buttonId.equals(this.getButtonAttr(button, "actionName"))) continue;
                return this.getButtonAttr(button, "buttonName");
            }
        }
        return this.plugin.getMessage("changedata.assignment.button.default");
    }

    private String getButtonAttr(ExtendedAttribute button, String attr) {
        for (String item : button.getVValue().split("\r\n|[\n\r\u2028\u2029\u0085\f]")) {
            String[] splitted = item.split("=");
            String name = splitted[0];
            String value = splitted[1];
            if (!attr.equals(name)) continue;
            return value;
        }
        return "";
    }

    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public Response addAssignment(@RequestBody AssignmentDto assignmentDto) {
        Translator t = Translators.get((String)this.plugin.getKey());
        String processDefId = assignmentDto.getProcessDefId();
        String activityDefId = assignmentDto.getActivityDefId();
        String acceptanceButtonId = assignmentDto.getAcceptanceButtonId();
        if (!this.assignmentExist(processDefId, activityDefId)) {
            Assignment assignment = new Assignment();
            assignment.setProcessDefId(processDefId);
            assignment.setActivityDefId(activityDefId);
            assignment.setAcceptanceButtonId(acceptanceButtonId);
            try {
                this.assignmentService.save(assignment);
                return new Response(true, t.getMessage("changedata.assignment.adding.success"));
            }
            catch (Exception e) {
                log.error("Error during adding assignment", (Throwable)e);
                return new Response(false, t.getMessage("changedata.assignment.adding.error"));
            }
        }
        return new Response(false, t.getMessage("changedata.assignment.adding.warning"));
    }

    private boolean assignmentExist(String processDefId, String activityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Assignment.class);
        dc.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
        dc.add((Criterion)Restrictions.eq((String)"activityDefId", (Object)activityDefId));
        return this.assignmentService.findOne(dc) != null;
    }

    @ResponseBody
    @RequestMapping(value={"remove/{assignmentId}"})
    public Response removeAssignment(@PathVariable Long assignmentId) {
        Translator t = Translators.get((String)this.plugin.getKey());
        try {
            Assignment assignment = (Assignment)this.assignmentService.get(assignmentId);
            this.assignmentService.delete(assignment);
            return new Response(true, t.getMessage("changedata.assignment.deleting.success"));
        }
        catch (Exception e) {
            log.error("Error during deleting assignment", (Throwable)e);
            return new Response(false, t.getMessage("changedata.assignment.deleting.error"));
        }
    }
}

