/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.changedata.administration.assignment.Assignment;
import com.suncode.plugin.wizards.changedata.administration.assignment.AssignmentService;
import com.suncode.plugin.wizards.changedata.dto.ActivitiesData;
import com.suncode.plugin.wizards.changedata.dto.ActivityData;
import com.suncode.plugin.wizards.changedata.dto.PrevieDataProperties;
import com.suncode.plugin.wizards.changedata.dto.Result;
import com.suncode.pwfl.form.util.object.ActivityInfo;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.PackageAdministration;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/changedata"})
public class ChangeDataController {
    private static final Logger log = LoggerFactory.getLogger(ChangeDataController.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private ActivityService activityService;
    private XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();

    @ResponseBody
    @RequestMapping(value={"processDef/activities"}, method={RequestMethod.POST})
    public ActivitiesData getActivitiesForProcessDefinitions(@RequestParam List<String> processesDefId) {
        ActivitiesData data = new ActivitiesData();
        ArrayList<ActivityData> activityDataList = new ArrayList<ActivityData>();
        for (String processDefId : processesDefId) {
            String packageId = this.xpdlPackageManager.getPackageIdByProcessDefinitionId(processDefId);
            Package pack = this.xpdlPackageManager.getPackage(packageId);
            WorkflowProcess process = pack.getWorkflowProcess(processDefId);
            DetachedCriteria dc = DetachedCriteria.forClass(Assignment.class).add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
            List assignments = this.assignmentService.findByCriteria(dc);
            if (assignments != null && !assignments.isEmpty()) {
                for (Assignment assignment : assignments) {
                    Activity activityItem = process.getActivity(assignment.getActivityDefId());
                    if (activityItem == null) continue;
                    activityDataList.add(this.getActivityData(assignment, activityItem));
                }
                data.setResult(new Result(Result.ResultStatus.SUCCESS));
                continue;
            }
            data.setResult(new Result(Result.ResultStatus.FAILURE, this.plugin.getMessage("changedata.activities.error")));
        }
        data.setData(activityDataList);
        return data;
    }

    private ActivityData getActivityData(Assignment assignment, Activity activityItem) {
        ActivityData activityData = new ActivityData();
        activityData.setProcessId(assignment.getProcessDefId());
        activityData.setActivityId(activityItem.getId());
        activityData.setActivityName(activityItem.getName());
        return activityData;
    }

    @ResponseBody
    @RequestMapping(value={"getPreviewData"}, method={RequestMethod.POST})
    public PrevieDataProperties getPreviewData(@RequestBody PrevieDataProperties properties) {
        try {
            PackageAdministration packageAdministration = Shark.getInstance().getAdminInterface().getPackageAdministration();
            Package pack = this.xpdlPackageManager.getPackageByProcessDefinitionId(properties.getProcessDefId());
            properties.setPackageId(this.getPackageId(pack));
            properties.setPackageVersion(this.getPackageVersion(packageAdministration, pack));
            properties.setActivityName(this.getActivityName(properties));
            properties.setXpdl(this.getXpdlContent(properties, packageAdministration));
            properties.setFormTemplate(this.getFormTemplateContent(properties));
            properties.setResult(new Result(Result.ResultStatus.SUCCESS));
        }
        catch (IOException | BaseException e) {
            log.error("Error during", e);
            properties.setResult(new Result(Result.ResultStatus.FAILURE, this.plugin.getMessage("changedata.preview.error")));
        }
        return properties;
    }

    private String getPackageId(Package pack) {
        String packageId = pack.getId();
        return packageId;
    }

    private String getPackageVersion(PackageAdministration packageAdministration, Package pack) throws BaseException {
        String version = packageAdministration.getCurrentPackageVersion(pack.getId());
        return version;
    }

    private String getActivityName(PrevieDataProperties properties) {
        return this.activityService.getActivityName(properties.getProcessDefId(), properties.getActivityDefId());
    }

    private String getXpdlContent(PrevieDataProperties properties, PackageAdministration packageAdministration) throws BaseException {
        byte[] rawXPDL = packageAdministration.getPackageContent(properties.getPackageId());
        return new String(rawXPDL);
    }

    private String getFormTemplateContent(PrevieDataProperties properties) throws IOException {
        ActivityInfo activityInfo = properties.toActivityInfo();
        String path = this.buildFormTemplateFilePath(activityInfo);
        return FileUtils.readFileToString((File)new File(path));
    }

    private String buildFormTemplateFilePath(ActivityInfo activityInfo) {
        StringBuilder filePath = new StringBuilder();
        filePath.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        filePath.append(File.separator);
        filePath.append(this.buildPackageFolderName(activityInfo));
        filePath.append(File.separator);
        filePath.append(this.buildVersionFolderName(activityInfo));
        filePath.append(File.separator);
        filePath.append(this.buildProcessFolderName(activityInfo));
        filePath.append(File.separator);
        filePath.append(this.buildFormTemplateFileName(activityInfo));
        return filePath.toString();
    }

    private String buildPackageFolderName(ActivityInfo activityInfo) {
        return activityInfo.getPackageId();
    }

    private String buildVersionFolderName(ActivityInfo activityInfo) {
        return "v" + activityInfo.getPackageVersion();
    }

    private String buildProcessFolderName(ActivityInfo activityInfo) {
        return activityInfo.getProcessDefId();
    }

    private String buildFormTemplateFileName(ActivityInfo activityInfo) {
        return activityInfo.getActivityDefId() + ".xml";
    }
}

