/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	var SelectProcess = __webpack_require__(1);
	var SelectActivities = __webpack_require__(4);
	var ChangeData = __webpack_require__(10);
	var Summary = __webpack_require__(11);
	
	Wizards.create({
	  title: 'CHANGE DATA WIZARD',
	  steps: [SelectProcess, SelectActivities, ChangeData, Summary],
	  wizardData: {},
	});


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var selectProcessStore = __webpack_require__(3);
	
	module.exports = Ext.define('Wizards.components.selectprocess.SelectProcessStep', {
	  extend: 'Wizards.wizard.Step',
	  name: Wizards.t('selectprocess.step.name'),
	
	  initComponent: function () {
	    var selectProcessGrid = [
	      {
	        itemId: 'select-process-grid',
	        xtype: 'wizard-selectprocessgrid',
	        wizardProperty: 'units',
	        wizardTempProperty: 'selectedItems',
	        store: selectProcessStore,
	        checkProcessesAreOneType: function () {
	          var selectionModel = this.getSelectionModel(),
	            selected = selectionModel.getSelection(),
	            currentProcessDefId = '';
	
	          for (var i = 0; i < selected.length; i++) {
	            var itemProcessDefId = selected[i].raw.processDefinitionId;
	            if (i == 0) {
	              currentProcessDefId = itemProcessDefId;
	            } else {
	              if (currentProcessDefId != itemProcessDefId) {
	                return false;
	              }
	            }
	          }
	
	          return true;
	        },
	      },
	    ];
	
	    this.items = [
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'select-process-item',
	        fieldLabel: Wizards.t('selectprocess.step.grid.label'),
	        description: Wizards.t('selectprocess.step.grid.description'),
	        flex: 1,
	        items: selectProcessGrid,
	        errorMsg: Wizards.t('selectprocess.step.grid.errormsg'),
	        msgTarget: 'under',
	        margin: '0 0 10 0',
	      },
	    ];
	
	    this.callParent(arguments);
	  },
	
	  validate: function () {
	    var item = this.down('#select-process-item');
	    var grid = this.down('#select-process-grid');
	
	    var processesSelected = grid.validate();
	    if (!processesSelected) {
	      this.setInvalid(item, Wizards.t('selectprocess.step.grid.errormsg'));
	    }
	
	    var processesAreOneType = grid.checkProcessesAreOneType();
	    if (!processesAreOneType) {
	      this.setInvalid(item, Wizards.t('selectprocess.step.validation.message'));
	    }
	
	    var isValid = processesSelected && processesAreOneType;
	    if (isValid) {
	      this.unsetInvalid(item);
	    }
	
	    return isValid;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'selectprocessstore',
	  model: 'Wizards.components.selectprocess.SelectProcessGrid',
	  proxy: {
	    type: 'ajax',
	    url: Wizards.pluginContextPath + '/components/selectprocess',
	    extraParams: {
	      section: Wizards.section,
	      filter: 'all',
	      searchId: Wizards.searchContext.searchId,
	    },
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(5);
	
	module.exports = Ext.define('Wizards.changedata.SelectActivitiesStep', {
	  extend: 'Wizards.wizard.Step',
	  alias: 'widget.select-activities-step',
	  name: Wizards.t('selectactivities.step.name'),
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'selectTypes',
	        description: Wizards.t('selectactivities.step.procdef.description'),
	        padding: '0 0 0 30',
	        maxHeight: 200,
	        errorMsg: Wizards.t('selectactivities.step.procdef.errormsg'),
	        msgTarget: 'under',
	        items: [
	          {
	            id: 'wizard-processdefgrid',
	            xtype: 'wizard-processdefgrid',
	            wizardProperty: 'activitiesToChange',
	          },
	        ],
	      },
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'comment',
	        description: Wizards.t('selectactivities.step.comment.description'),
	        padding: '0 0 0 30',
	        maxHeight: 200,
	        items: [
	          {
	            xtype: 'wizard-comment-field',
	            value: Wizards.t('selectactivities.step.comment.defaultvalue'),
	          },
	        ],
	      },
	    ];
	    this.callParent();
	  },
	
	  activated: function () {
	    var processDefGrid = this.down('#wizard-processdefgrid');
	    var selectedProcesses = this.getData('selectedItems', true);
	
	    this.showWarnings();
	
	    processDefGrid.prepare({
	      data: selectedProcesses,
	    });
	
	    this.callParent(arguments);
	  },
	
	  showWarnings: function () {
	    var loadedRecords = this.getData('loadedRecords', true);
	    var visited = this.getData('visited', true) || false;
	    var selectionModelCount = this.getData('selectionModelCount', true);
	    var messages = [];
	
	    this._clearInvalid();
	    this.clearMessages();
	    if (!visited && selectionModelCount == 1) {
	      this.saveData(
	        {
	          visited: true,
	        },
	        true
	      );
	      messages.push({
	        text: Wizards.t('selectactivities.step.message.skippreviousstep'),
	        type: 'warning',
	      });
	    }
	    this.showMessages(messages);
	  },
	
	  _clearInvalid: function () {
	    Ext.each(
	      this.down('wizard-step-item'),
	      function (item) {
	        this.unsetInvalid(item);
	      },
	      this
	    );
	  },
	
	  validate: function () {
	    var result = true;
	    var item = this.down('#selectTypes');
	    var isValid = item.down().validate();
	    if (!isValid) {
	      this.setInvalid(item);
	    } else {
	      this.unsetInvalid(item);
	    }
	    result = result && isValid;
	
	    return result;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(6);
	var ColumnRenderer = __webpack_require__(7);
	var processDefStore = __webpack_require__(8);
	var activityStore = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changedata.model.Activity',
	  autoLoad: false,
	});
	
	//FIXME zapomina wybrane zadania po cofnięciu kroku
	module.exports = Ext.define('Wizards.changedata.ActivityForProcessDefGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-processdefgrid',
	  store: processDefStore,
	  selType: 'cellmodel',
	  plugins: [
	    {
	      ptype: 'cellediting',
	      pluginId: 'cellediting',
	      clicksToEdit: 1,
	    },
	  ],
	  mixins: {
	    columnRenderer: ColumnRenderer,
	  },
	
	  constructor: function () {
	    this.mixins.columnRenderer.constructor.call(this, activityStore, null, 'processDefId');
	    this.callParent(arguments);
	  },
	
	  initComponent: function () {
	    this.columns = [
	      {
	        header: Wizards.t('processdefgrid.column.activity.header'),
	        dataIndex: 'activity',
	        flex: 1,
	        editor: {
	          xtype: 'combobox',
	          store: activityStore,
	          editable: false,
	          queryMode: 'local',
	          valueField: 'activityId',
	          displayField: 'activityName',
	          forceSelection: true,
	          listeners: {
	            beforeselect: function (combo, record, index) {
	              return record.data.active;
	            },
	          },
	        },
	        scope: this,
	        renderer: this.activityColumnRenderer,
	      },
	      {
	        header: Wizards.t('processdefgrid.column.processdef.header'),
	        dataIndex: 'processDefName',
	        flex: 2,
	      },
	    ];
	    this.callParent();
	  },
	
	  prepare: function (params) {
	    var processDefs = [];
	    var tmp = {};
	    // unikalne typu procesu
	    Ext.each(params.data, function (item) {
	      tmp[item.raw.processDefinitionId] = item.data.processType;
	    });
	
	    var processesDefId = [];
	    for (var key in tmp) {
	      processesDefId.push(key);
	      processDefs.push({
	        processDefId: key,
	        processDefName: tmp[key],
	      });
	    }
	
	    this.store.loadData(processDefs);
	
	    Ext.Ajax.request({
	      url: Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-change-data/changedata/processDef/activities',
	      method: 'POST',
	      params: {
	        processesDefId: processesDefId,
	      },
	      callback: function (options, success, response) {
	        var responseBody = Ext.JSON.decode(response.responseText),
	          result = responseBody.result,
	          data = responseBody.data;
	
	        if (result.status == 'SUCCESS') {
	          activityStore.loadData(data);
	          this._forceSelectSingleActivity(data);
	          this._setComboFilter();
	        } else {
	          var step = this.up('select-activities-step'),
	            item = this.up('wizard-step-item');
	
	          step.setInvalid(item, result.message);
	        }
	      },
	      scope: this,
	    });
	  },
	  _forceSelectSingleActivity: function (data) {
	    Ext.suspendLayouts();
	    try {
	      Ext.each(
	        this.getStore().getRange(),
	        function (record) {
	          var processDefId = record.get('processDefId');
	          var result = Ext.Array.filter(data, function (item, index) {
	            return (item.processId = processDefId);
	          });
	
	          if (result.length == 1) {
	            record.set('activity', result[0].activityId);
	          }
	        },
	        this
	      );
	      this.getView().refresh();
	    } finally {
	      Ext.resumeLayouts(true);
	    }
	  },
	  _setComboFilter: function () {
	    this.on('beforeedit', function (editor, e) {
	      var filterValue = e.record.get('processDefId');
	      activityStore.clearFilter(true);
	      activityStore.filter(
	        Ext.create('Ext.util.Filter', {
	          property: 'processId',
	          value: filterValue,
	          root: 'data',
	          exactMatch: true,
	        })
	      );
	    });
	  },
	  readData: function () {
	    var result = [];
	    this.store.each(function (record) {
	      if (record.data.activity) {
	        result.push({
	          processDefId: record.data.processDefId,
	          activityDefId: record.data.activity,
	        });
	      }
	    });
	    return result;
	  },
	  validate: function () {
	    var records = this.getStore().getRange();
	    for (var i = 0; i < records.length; i++) {
	      if (records[i].data.activity == undefined) {
	        return false;
	      }
	    }
	    return true;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.model.Activity', {
	  extend: 'Ext.data.Model',
	  alias: 'Activity',
	
	  fields: [
	    { name: 'processId', type: 'string' },
	    { name: 'activityId', type: 'string' },
	    { name: 'activityName', type: 'string' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * Functions rendering columns in TaskToReopen
	 *
	 * @class Wizards.openprocess.tasktoreopen.ColumnRenderer
	 */
	module.exports = Ext.define('Wizards.openprocess.tasktoreopen.ColumnRenderer', {
	  /**
	   * Stores used in editor
	   */
	  editorStore: {},
	  sourceUsersStore: {},
	
	  /**
	   * Name of id property
	   */
	  idName: '',
	
	  constructor: function (store, sourceUsersStore, idName) {
	    this.editorStore = store;
	    this.sourceUsersStore = sourceUsersStore;
	    this.idName = idName;
	  },
	
	  activityColumnRenderer: function (value, meta, record) {
	    var result = '';
	    if (value) {
	      var foundRecord = this.editorStore.queryBy(function (storeRecord) {
	        if (storeRecord.get('processId') == record.get(this.idName) && storeRecord.get('activityId') == value) {
	          return true;
	        }
	        return false;
	      }, this);
	
	      result = this.getColumnIconElement('dvnt-icon-check-symbol') + foundRecord.get(0).get('activityName');
	    } else {
	      meta.style = 'color: #F1472F';
	      result = Wizards.t('columnrenderer.column.emptyname');
	    }
	    return result;
	  },
	
	  assignmentUsersColumnRenderer: function (value, meta, record) {
	    var result = '';
	    if (value) {
	      var foundRecord = this.sourceUsersStore.queryBy(function (storeRecord) {
	        if (storeRecord.get('userId') == value) {
	          return true;
	        }
	        return false;
	      }, this);
	
	      result = this.getColumnIconElement('dvnt-icon-check-symbol') + foundRecord.get(0).get('userName');
	    } else {
	      meta.style = 'color: #F1472F';
	      result = Wizards.t('columnrenderer.column.user.emptyname');
	    }
	    return result;
	  },
	
	  getColumnIconElement: function (cls) {
	    return '<span class="' + cls + '" style="float: right; height: 16px; width: 16px; display: block;"></span>';
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var ProcessDef = __webpack_require__(9);
	
	module.exports = Ext.create('Ext.data.ArrayStore', {
	  model: ProcessDef,
	  autoLoad: false,
	  sorters: [
	    {
	      property: 'processDefName',
	      direction: 'ASC',
	      transform: function (item) {
	        return item.toLowerCase();
	      },
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.model.ProcessDef', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    { name: 'processDefId', type: 'string' },
	    { name: 'processDefName', type: 'string' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.ChangeDataStep', {
	  extend: 'Wizards.wizard.Step',
	  name: Wizards.t('wizard.changedata.step.name'),
	
	  visited: false,
	  activitiesToChange: [],
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'container',
	        itemId: 'formPreviewContainer',
	        layout: 'fit',
	        flex: 1,
	      },
	    ];
	
	    this.callParent();
	  },
	
	  activated: function () {
	    if (this.visited && this.sameActivities()) {
	      return;
	    }
	
	    var mask = new Ext.LoadMask({ target: this });
	
	    this.visited = true;
	    this.activitiesToChange = this.getData('activitiesToChange');
	
	    Ext.Ajax.request({
	      url: this.createGetPreviewDataURL(),
	      jsonData: this.createGetPreviewDataParams(this.getData('activitiesToChange')),
	      callback: function (options, success, responseBody) {
	        var response = Ext.JSON.decode(responseBody.responseText);
	
	        if (success) {
	          var result = response.result;
	          if (result.status == 'SUCCESS') {
	            this.getPreview(response, mask);
	          } else {
	            this.addMessage({
	              text: result.message,
	              type: result.status,
	            });
	          }
	        } else {
	          this.addMessage({
	            text: Wizards.t('changedata.preview.error'),
	            type: result.status,
	          });
	        }
	      },
	      scope: this,
	    });
	
	    this.callParent(arguments);
	  },
	
	  sameActivities: function () {
	    var same = false;
	    Ext.each(
	      this.activitiesToChange,
	      function (prevActivity) {
	        Ext.each(
	          this.getData('activitiesToChange'),
	          function (currActivity) {
	            if (Ext.Object.equals(prevActivity, currActivity)) {
	              same = true;
	              return false;
	            }
	          },
	          this
	        );
	      },
	      this
	    );
	
	    return same;
	  },
	
	  createGetPreviewDataURL: function () {
	    return Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-change-data/changedata/getPreviewData';
	  },
	
	  createGetPreviewDataParams: function (activitiesToChange) {
	    if (Ext.isEmpty(activitiesToChange)) {
	      return {};
	    }
	
	    var data = activitiesToChange[0];
	    return {
	      processDefId: data.processDefId,
	      activityDefId: data.activityDefId,
	    };
	  },
	
	  getPreview: function (data, mask) {
	    var formPreviewContainer = this.queryById('formPreviewContainer');
	
	    formPreviewContainer.removeAll(true);
	    formPreviewContainer.add({
	      xtype: 'component',
	      id: 'previevFrame',
	      autoEl: {
	        tag: 'iframe',
	        name: 'previevFrame',
	        style: 'height: 100%; width: 100%; border: none',
	      },
	      initComponent: function () {
	        this.callParent();
	
	        var formPanel = new Ext.form.Panel({
	          hidden: true,
	          url: Suncode.context('change-data').formPreview,
	          items: [
	            {
	              xtype: 'textfield',
	              name: 'packageId',
	              value: data.packageId,
	            },
	            {
	              xtype: 'textfield',
	              name: 'processDefId',
	              value: data.processDefId,
	            },
	            {
	              xtype: 'textfield',
	              name: 'activityDefId',
	              value: data.activityDefId,
	            },
	            {
	              xtype: 'textfield',
	              name: 'activityName',
	              value: data.activityName,
	            },
	            {
	              xtype: 'textfield',
	              name: 'xpdl',
	              value: LZString.compressToBase64(data.xpdl),
	            },
	            {
	              xtype: 'textfield',
	              name: 'formTemplate',
	              value: LZString.compressToBase64(data.formTemplate),
	            },
	            {
	              xtype: 'checkbox',
	              name: 'devMode',
	              inputValue: 'false',
	              checked: true,
	            },
	            {
	              xtype: 'textfield',
	              name: 'contextMap',
	              value: '',
	            },
	            {
	              xtype: 'checkbox',
	              name: 'compressed',
	              inputValue: 'true',
	              checked: true,
	            },
	            {
	              xtype: 'checkbox',
	              name: 'showButtons',
	              inputValue: 'false',
	              checked: true,
	            },
	            {
	              xtype: 'textfield',
	              name: 'numberfieldEmptyValue',
	              value: '',
	            },
	          ],
	        });
	
	        formPanel.getForm().doAction('standardsubmit', {
	          target: 'previevFrame',
	          method: 'POST',
	          standardSubmit: true,
	          url: Suncode.context('change-data').formPreview,
	        });
	      },
	    });
	  },
	
	  validate: function () {
	    return true;
	  },
	
	  saveConfig: function () {
	    var frame = window.frames[0],
	      formService = frame.ServiceFactory.getFormService(),
	      data = { formValues: formService.getValues() };
	
	    this.saveData(data, true);
	    this.saveData(data);
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.SummaryStep', {
	  extend: 'Wizards.components.summary.SummaryStep',
	
	  name: Wizards.t('wizard.changedata.summary.step.name'),
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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