/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	__webpack_require__(1);
	Wizards.t = Wizards.I18N.createT('com.suncode.plugin-wizards-change-data');
	
	var Application = __webpack_require__(3),
	  Viewport = __webpack_require__(4),
	  PermissionController = __webpack_require__(28),
	  AssignmentController = __webpack_require__(29);
	
	/**
	 * Main application of Change Data Administration
	 *
	 * @main
	 */
	Application.create({
	  name: 'User Data Configuration',
	  view: {
	    type: Viewport,
	    target: 'wizard-change-data-admin-container',
	  },
	  controllers: [PermissionController, AssignmentController],
	});


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var cached = {};
	
	module.exports = Ext.define('Wizards.I18N', {
	  singleton: true,
	
	  /**
	   * Returns translated message for given key and translator name.
	   *
	   * @example
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * @method t
	   * @param {String} translator translator name
	   * @param {String} key message key
	   * @param {...Object} [args] additional message arguments (resolved as placeholders i.e. {0})
	   * @return Translated message or supplied key if there is no translation available
	   */
	  t: function (translator, key) {
	    var message = this.bundle(translator)[key];
	    if (!Ext.isEmpty(message)) {
	      var args = Ext.Array.toArray(arguments, 2);
	      return Ext.String.format.apply(this, [message].concat(args));
	    }
	    return key;
	  },
	
	  /**
	   * Creates shorthand function for translating message using single translator. For example instead of
	   *
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * you can use create shorthand function once
	   *
	   * 	PW.t = PW.I18N.createT('plusworkflow');
	   *
	   * and then use it like
	   *
	   * 	PW.t('user.desc', 'Jan', 'Kowalski' );
	   *
	   * @method createT
	   * @param {String} translator translator name
	   */
	  createT: function (translator) {
	    return Ext.bind(this.t, this, [translator], 0);
	  },
	
	  bundle: function (key) {
	    var bundle = cached[key];
	
	    // Jeżeli nie ma załadowanego bundle'a to SYNCHRONICZNIE pobieramy go z bazy danych
	    if (!Ext.isObject(bundle)) {
	      Ext.Ajax.request({
	        url: Suncode.getAbsolutePath('/api/translation/bundle/' + encodeURIComponent(key)),
	        method: 'GET',
	        async: false,
	        timeout: 5000,
	        success: function (response) {
	          bundle = Ext.decode(response.responseText);
	          cached[key] = bundle;
	        },
	      });
	    }
	    return bundle || {};
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {// Przygotowanie kontekstu do przechowywania danych na temat aplikacji
	var context = Suncode.context('changedata');
	if (!context.applications) {
	  context.applications = {};
	}
	
	/**
	 * Aplikacja
	 */
	module.exports = Ext.define('Wizards.changedata.admin.app.Application', {
	  constructor: function (config) {
	    var existingApp = context.applications[config.name];
	    if (existingApp) {
	      existingApp.destroy();
	    }
	    try {
	      this.prepareControllers(config.controllers);
	      this.prepareView(config.view);
	      this.init(config.launch);
	    } finally {
	      context.applications[config.name] = this;
	    }
	  },
	
	  prepareControllers: function (controllers) {
	    this.controllers = [];
	    Ext.each(
	      controllers,
	      function (controllerClass) {
	        var controller = controllerClass.create();
	        controller.id = controllerClass.$className;
	
	        controller.fireGlobalEvent = function () {
	          Ext.globalEvents.fireEvent.apply(Ext.globalEvents, arguments);
	        };
	        controller.listenGlobal = function (event) {
	          Ext.globalEvents.on.apply(Ext.globalEvents, arguments);
	        };
	
	        this.controllers.push(controller);
	      },
	      this
	    );
	  },
	
	  prepareView: function (view) {
	    this.view = view.type.create({
	      renderTarget: view.target,
	    });
	  },
	
	  init: function (launchFn) {
	    Ext.tip.QuickTipManager.init();
	    Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider());
	
	    Ext.each(
	      this.controllers,
	      function (controller) {
	        controller.init();
	      },
	      this
	    );
	
	    Ext.onReady(
	      function () {
	        // render view
	        this.view.render(this.view.renderTarget);
	
	        var grid = this.view.down('change-data-admin-assignment-grid');
	        var table = grid.down('gridview');
	        table.getStore().load(function (record, operation, success) {
	          //PLWZD-104
	          //Czekamy aż wszystkie dane przyjdą ze store'a i odświeżamy widok
	          table.refresh();
	          grid.doLayout();
	        });
	
	        // call launch
	        if (Ext.isFunction(launchFn)) {
	          launchFn.call(this, this.view);
	        }
	
	        Ext.each(
	          this.controllers,
	          function (controller) {
	            controller.finishInit();
	          },
	          this
	        );
	      },
	      this,
	      {
	        single: true,
	      }
	    );
	  },
	
	  destroy: function () {
	    if (this.view) {
	      this.view.destroy();
	    }
	
	    if (this.controllers) {
	      Ext.each(
	        this.controllers,
	        function (controller) {
	          controller.eventbus.unlisten(controller.id);
	        },
	        this
	      );
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(5);
	
	module.exports = Ext.define('Wizard.changedata.configuration.Viewport', {
	  extend: 'Ext.container.Container',
	  xtype: 'change-data-admin-viewport',
	
	  height: 700,
	  border: false,
	  style: {
	    'text-align': 'left',
	  },
	  bodyStyle: {
	    background: 'none',
	  },
	
	  items: [
	    {
	      xtype: 'change-data-admin-settings-panel',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(6);
	__webpack_require__(15);
	
	module.exports = Ext.define('Wizards.changedata.administration.SettingsPanel', {
	  extend: 'Ext.panel.Panel',
	  xtype: 'change-data-admin-settings-panel',
	
	  layout: {
	    type: 'hbox',
	    align: 'stretch',
	  },
	  border: false,
	  height: 700,
	
	  items: [
	    {
	      xtype: 'change-data-admin-permission-panel',
	      flex: 1,
	    },
	    {
	      xtype: 'change-data-admin-assignment-panel',
	      style: 'margin-left: 5px;',
	      flex: 3,
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(7);
	__webpack_require__(11);
	
	module.exports = Ext.define('Wizards.changedata.administration.permission.PermissionPanel', {
	  extend: 'Ext.panel.Panel',
	  xtype: 'change-data-admin-permission-panel',
	
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	  border: false,
	  split: true,
	
	  items: [
	    {
	      xtype: 'change-data-admin-permission-grid',
	      flex: 1,
	    },
	    {
	      xtype: 'change-data-admin-permission-new',
	      border: true,
	      height: 310,
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(8);
	
	var usersStore = __webpack_require__(9),
	  groupsStore = __webpack_require__(10);
	
	module.exports = Ext.define('Wizards.changedata.administration.permission.form.NewPermissionForm', {
	  extend: 'Ext.form.Panel',
	  xtype: 'change-data-admin-permission-new',
	
	  title: Wizards.t('administration.permissions.new.title'),
	
	  bodyPadding: 10,
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  items: [
	    {
	      xtype: 'radiogroup',
	      allowBlank: false,
	      itemId: 'resourceTypeGroup',
	      columns: 2,
	      items: [
	        {
	          xtype: 'change-data-radio',
	          boxLabel: Wizards.t('administration.permissions.new.field.user'),
	          name: 'resourceType',
	          iconCls: 'dvnt-icon-user',
	          inputValue: 'USER',
	          checked: true,
	        },
	        {
	          xtype: 'change-data-radio',
	          boxLabel: Wizards.t('administration.permissions.new.field.group'),
	          name: 'resourceType',
	          iconCls: 'dvnt-icon-users',
	          inputValue: 'GROUP',
	        },
	      ],
	    },
	    {
	      xtype: 'combo',
	      allowBlank: false,
	      name: 'resourceId',
	      itemId: 'userCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.user'),
	      store: usersStore,
	      valueField: 'objectId',
	      displayField: 'viewName',
	      pageSize: 20,
	      minChars: 0,
	      forceSelection: true,
	    },
	    {
	      xtype: 'combo',
	      allowBlank: false,
	      name: 'resourceId',
	      itemId: 'groupCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.group'),
	      store: groupsStore,
	      valueField: 'objectId',
	      displayField: 'name',
	      pageSize: 20,
	      disabled: true,
	      minChars: 0,
	      forceSelection: true,
	    },
	  ],
	
	  bbar: [
	    {
	      xtype: 'button',
	      itemId: 'newPermissionBtn',
	      text: Wizards.t('administration.permissions.new.button.add'),
	      iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
	      iconAlign: 'left',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.util.RadioField', {
	  extend: 'Ext.form.field.Radio',
	  xtype: 'change-data-radio',
	
	  iconSpanStyle: 'width:16px;height:16px;display:inline-block;margin-right:5px',
	
	  constructor: function (config) {
	    var iconCls = config.iconCls;
	
	    if (!Ext.isEmpty(iconCls)) {
	      this.beforeBoxLabelTextTpl = '<span style="' + this.iconSpanStyle + '" class="' + iconCls + '"></span>';
	    }
	    this.callParent(arguments);
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  pageSize: 20,
	  fields: [
	    'objectId',
	    'userName',
	    'fullName',
	    {
	      name: 'viewName',
	      convert: function (value, record) {
	        var userName = record.get('userName');
	        var fullName = record.get('fullName');
	
	        return Ext.isEmpty(fullName) ? userName : fullName + ' (' + userName + ')';
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-data').contextPath + '/api/users/query',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  pageSize: 20,
	  fields: ['name', 'objectId'],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-data').contextPath + '/api/groups/query',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(12),
	  Renderers = __webpack_require__(14);
	
	module.exports = Ext.define('Wizards.changedata.administration.permission.PermissionGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'change-data-admin-permission-grid',
	
	  title: Wizards.t('administration.permissions.grid.title'),
	
	  store: store,
	  columns: [
	    {
	      text: Wizards.t('administration.permissions.grid.column.resourcename'),
	      dataIndex: 'resourceName',
	      flex: 1,
	    },
	    {
	      dataIndex: 'resourceType',
	      width: 50,
	      renderer: function (value) {
	        var type = value.toLowerCase(),
	          cls = type === 'user' ? 'dvnt-icon-user' : 'dvnt-icon-users',
	          qtip =
	            type === 'user'
	              ? Wizards.t('administration.permissions.grid.column.resourcetype.user')
	              : Wizards.t('administration.permissions.grid.column.resourcetype.group');
	        return Renderers.icon(cls, qtip);
	      },
	    },
	    {
	      xtype: 'actioncolumn',
	      width: 50,
	      items: [
	        {
	          iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
	          tooltip: Wizards.t('administration.permissions.grid.action.tooltip'),
	          scope: this,
	          handler: function (view, rowIndex, colIndex, item, e, record) {
	            Ext.Msg.confirm(
	              Wizards.t('administration.permissions.grid.action.message.title'),
	              Wizards.t('administration.permissions.grid.action.message.text', record.get('resourceName')),
	              function (buttonId) {
	                if (buttonId == 'yes') {
	                  view.fireEvent('deleteClick', record);
	                }
	              }
	            );
	          },
	        },
	      ],
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(13);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changedata.administration.permissions.Permission',
	  autoLoad: true,
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-data').pluginContextPath + '/permissions/all',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.permissions.Permission', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    {
	      name: 'id',
	      type: 'int',
	    },
	    'resourceType',
	    'resourceName',
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {Ext.define('Wizards.changedata.administration.util.Renderers', {
	  singleton: true,
	
	  icon: function (iconCls, tooltip) {
	    return (
	      '<span ' +
	      'data-qtip="' +
	      tooltip +
	      '" ' +
	      'style="display: inline-block;width: 16px; height: 16px; padding:2px" ' +
	      'class ="' +
	      iconCls +
	      '"></span>'
	    );
	  },
	});
	
	module.exports = Wizards.changedata.administration.util.Renderers;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(16);
	__webpack_require__(19);
	__webpack_require__(22);
	__webpack_require__(25);
	
	module.exports = Ext.define('Wizards.changedata.administration.assignment.AssignmentPanel', {
	  extend: 'Ext.panel.Panel',
	  xtype: 'change-data-admin-assignment-panel',
	  title: Wizards.t('administration.assignment.panel.title'),
	
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  items: [
	    {
	      xtype: 'container',
	      layout: {
	        type: 'hbox',
	        align: 'middle',
	      },
	      margin: '10 0 10 10',
	      defaults: {
	        margin: '0 10 0 0',
	      },
	      items: [
	        {
	          xtype: 'change-data-admin-process-combo',
	          flex: 1,
	        },
	        {
	          xtype: 'change-data-admin-activity-combo',
	          flex: 1,
	        },
	        {
	          xtype: 'change-data-admin-acceptance-button-combo',
	          flex: 1,
	        },
	        {
	          xtype: 'button',
	          text: Wizards.t('administration.assignment.panel.button.add.text'),
	          iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
	          iconAlign: 'left',
	          handler: function () {
	            var grid = this.findParentByType('change-data-admin-assignment-panel').down('change-data-admin-assignment-grid'),
	              panel = this.findParentByType('change-data-admin-assignment-panel'),
	              processCombo = panel.down('#admin-process-combo'),
	              activityCombo = panel.down('#admin-activity-combo'),
	              acceptanceButtonCombo = panel.down('#admin-acceptance-button-combo');
	
	            if (processCombo.validate() && activityCombo.validate() && acceptanceButtonCombo.validate()) {
	              grid.fireEvent('addClick', processCombo.getValue(), activityCombo.getValue(), acceptanceButtonCombo.getValue());
	            }
	          },
	        },
	      ],
	    },
	    {
	      xtype: 'container',
	      layout: {
	        type: 'auto',
	        reserveScrollbar: true,
	      },
	      margin: 10,
	      items: [
	        {
	          xtype: 'change-data-admin-assignment-grid',
	        },
	      ],
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(17);
	
	module.exports = Ext.define('Wizards.changedata.administration.component.ProcessCombo', {
	  extend: 'Ext.form.field.ComboBox',
	  xtype: 'change-data-admin-process-combo',
	
	  itemId: 'admin-process-combo',
	  fieldLabel: Wizards.t('administration.assignment.panel.process.label'),
	  store: store,
	  displayField: 'processName',
	  valueField: 'processDefId',
	  allowBlank: false,
	  forceSelection: true,
	  queryMode: 'local',
	  anyMatch: true,
	  tpl: Ext.create(
	    'Ext.XTemplate',
	    '<ul class="x-list-plain"><tpl for=".">',
	    '<li role="option" class="x4-boundlist-item">{processName}</li>',
	    '</tpl></ul>'
	  ),
	
	  initComponent: function () {
	    var me = this;
	    me.callParent();
	
	    me.on('select', function (combo, value) {
	      var activityCombo = combo.findParentByType('change-data-admin-assignment-panel').down('#admin-activity-combo');
	      activityCombo.getStore().load({
	        params: {
	          processDefId: value,
	        },
	        callback: function () {
	          activityCombo.clearValue();
	        },
	      });
	    });
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(18);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changedata.administration.assignment.model.ProcessModel',
	  autoLoad: true,
	  sorters: [
	    {
	      property: 'processName',
	      direction: 'ASC',
	      transform: function (item) {
	        return item.toLowerCase();
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-data').pluginContextPath + '/assignment/processes',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.assignment.model.ProcessModel', {
	  extend: 'Ext.data.Model',
	
	  fields: ['processDefId', 'processName'],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(20);
	
	module.exports = Ext.define('Wizards.changedata.administration.component.ActivityCombo', {
	  extend: 'Ext.form.field.ComboBox',
	  xtype: 'change-data-admin-activity-combo',
	
	  itemId: 'admin-activity-combo',
	  fieldLabel: Wizards.t('administration.assignment.panel.activity.label'),
	  store: store,
	  displayField: 'activityName',
	  valueField: 'activityDefId',
	  allowBlank: false,
	  forceSelection: true,
	  queryMode: 'local',
	  anyMatch: true,
	  tpl: Ext.create(
	    'Ext.XTemplate',
	    '<ul class="x-list-plain"><tpl for=".">',
	    '<li role="option" class="x4-boundlist-item">{activityName}</li>',
	    '</tpl></ul>'
	  ),
	
	  initComponent: function () {
	    var me = this;
	    me.callParent();
	
	    me.on('select', function (combo, value) {
	      var panel = combo.findParentByType('change-data-admin-assignment-panel'),
	        processValue = panel.down('#admin-process-combo').getValue(),
	        accepatanceButtonCombo = panel.down('#admin-acceptance-button-combo');
	
	      accepatanceButtonCombo.getStore().load({
	        params: {
	          processDefId: processValue,
	          activityDefId: value,
	        },
	        callback: function () {
	          accepatanceButtonCombo.clearValue();
	        },
	      });
	    });
	
	    me.getStore().on('beforeload', function (store, operation) {
	      var processCombo = me.findParentByType('change-data-admin-assignment-panel').down('#admin-process-combo');
	      var value = processCombo.getValue();
	      if (!value) {
	        PW.ui.Message.error(Wizards.t('administration.assignment.panel.combo.activity.error'));
	        return false;
	      }
	      operation.params = {
	        processDefId: value,
	      };
	    });
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(21);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changedata.administration.assignment.model.ActivityModel',
	  autoLoad: false,
	  sorters: [
	    {
	      property: 'activityName',
	      direction: 'ASC',
	      transform: function (item) {
	        return item.toLowerCase();
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-data').pluginContextPath + '/assignment/activities',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.assignment.model.ActivityModel', {
	  extend: 'Ext.data.Model',
	
	  fields: ['activityDefId', 'activityName'],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(23);
	
	module.exports = Ext.define('Wizards.changedata.administration.component.AcceptanceButtonCombo', {
	  extend: 'Ext.form.field.ComboBox',
	  xtype: 'change-data-admin-acceptance-button-combo',
	
	  itemId: 'admin-acceptance-button-combo',
	  fieldLabel: Wizards.t('administration.assignment.panel.acceptancebutton.label'),
	  store: store,
	  displayField: 'acceptanceButtonName',
	  valueField: 'acceptanceButtonId',
	  allowBlank: false,
	  forceSelection: true,
	  queryMode: 'local',
	  anyMatch: true,
	  tpl: Ext.create(
	    'Ext.XTemplate',
	    '<ul class="x-list-plain"><tpl for=".">',
	    '<li role="option" class="x4-boundlist-item">{acceptanceButtonName}</li>',
	    '</tpl></ul>'
	  ),
	
	  initComponent: function () {
	    var me = this;
	    me.callParent();
	
	    me.getStore().on('beforeload', function (store, operation) {
	      var processCombo = me.findParentByType('change-data-admin-assignment-panel').down('#admin-process-combo');
	      var activityCombo = me.findParentByType('change-data-admin-assignment-panel').down('#admin-activity-combo');
	      var proccessValue = processCombo.getValue();
	      var activityValue = activityCombo.getValue();
	
	      if (!proccessValue || !activityValue) {
	        PW.ui.Message.error(Wizards.t('administration.assignment.panel.combo.acceptancebutton.error'));
	        return false;
	      }
	      operation.params = {
	        processDefId: proccessValue,
	        activityDefId: activityValue,
	      };
	    });
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(24);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changedata.administration.assignment.model.AcceptanceButtonModel',
	  autoLoad: false,
	  sorters: [
	    {
	      property: 'acceptanceButtonName',
	      direction: 'ASC',
	      transform: function (item) {
	        return item.toLowerCase();
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	
	    url: Suncode.context('change-data').pluginContextPath + '/assignment/acceptancebuttons',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.assignment.model.AcceptanceButtonModel', {
	  extend: 'Ext.data.Model',
	
	  fields: ['acceptanceButtonId', 'acceptanceButtonName'],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(26);
	
	module.exports = Ext.define('Wizards.changedata.administration.assignment.component.AssignmentGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'change-data-admin-assignment-grid',
	
	  store: store,
	
	  viewConfig: {
	    stripeRows: false,
	    getRowClass: function (record) {
	      return !record.get('active') ? 'wizard-grayed-out' : '';
	    },
	  },
	
	  initComponent: function () {
	    this.columns = [
	      {
	        text: Wizards.t('administration.assignment.panel.process.label'),
	        renderer: this.columnRenderer,
	        dataIndex: 'processName',
	        flex: 1,
	      },
	      {
	        text: Wizards.t('administration.assignment.panel.activity.label'),
	        renderer: this.columnRenderer,
	        dataIndex: 'activityName',
	        flex: 1,
	      },
	      {
	        text: Wizards.t('administration.assignment.panel.acceptancebutton.label'),
	        renderer: this.columnRenderer,
	        dataIndex: 'acceptanceButtonName',
	        flex: 1,
	      },
	      {
	        xtype: 'actioncolumn',
	        width: 50,
	        items: [
	          {
	            iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
	            tooltip: Wizards.t('administration.assignment.grid.action.tooltip'),
	            scope: this,
	            handler: function (grid, rowIndex, colIndex, item, e, record) {
	              Ext.Msg.confirm(
	                Wizards.t('administration.assignment.grid.action.message.title'),
	                Wizards.t('administration.assignment.grid.action.message.text', record.get('processName'), record.get('activityName')),
	                function (buttonId) {
	                  if (buttonId == 'yes') {
	                    grid.fireEvent('deleteClick', record.get('id'));
	                  }
	                }
	              );
	            },
	          },
	        ],
	      },
	    ];
	
	    this.callParent(arguments);
	  },
	
	  columnRenderer: function (value, metaData, record, rowIndex, colIndex) {
	    if (!record.get('active')) {
	      metaData.tdAttr = 'data-qtip="' + Wizards.t('administration.assignment.grid.inactive.row') + '"';
	    }
	    return value;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(27);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.changedata.administration.assignment.model.AssignmentModel',
	  autoLoad: true,
	  sorters: [
	    {
	      property: 'processName',
	      direction: 'ASC',
	      transform: function (item) {
	        return item.toLowerCase();
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('change-data').pluginContextPath + '/assignment/assignments',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.assignment.model.AssignmentModel', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    'id',
	    'processDefId',
	    'processName',
	    'activityDefId',
	    'activityName',
	    'acceptanceButtonId',
	    'acceptanceButtonName',
	    { name: 'active', type: 'boolean' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.permissions.PermissionsController', {
	  extend: 'Ext.app.Controller',
	
	  refs: [
	    {
	      ref: 'permissionsGrid',
	      selector: 'change-data-admin-permission-grid',
	    },
	    {
	      ref: 'newPermissionForm',
	      selector: 'change-data-admin-permission-new',
	    },
	  ],
	
	  init: function () {
	    this.control({
	      'change-data-admin-permission-grid gridview': {
	        deleteClick: this.onDeleteClick,
	      },
	      'change-data-admin-permission-new #newPermissionBtn': {
	        click: this.newPermission,
	      },
	      'change-data-admin-permission-new #resourceTypeGroup': {
	        change: this.onResourceTypeGroupChange,
	      },
	    });
	  },
	
	  onDeleteClick: function (record) {
	    Ext.Ajax.request({
	      url: Suncode.context('change-data').pluginContextPath + '/permissions/delete/' + record.get('id'),
	      scope: this,
	      success: function (response) {
	        this.manageResponse(
	          response,
	          function () {
	            this.getPermissionsGrid().getStore().load();
	          },
	          this
	        );
	      },
	      failure: function () {},
	    });
	  },
	
	  manageResponse: function (response, fn, scope) {
	    var me = this,
	      status = Ext.decode(response.responseText);
	
	    if (status.success) {
	      fn.call(scope ? scope : me);
	    } else {
	      Ext.Msg.alert(Wizards.t('basic.error'), status.message);
	    }
	  },
	
	  newPermission: function () {
	    var form = this.getNewPermissionForm().getForm();
	    this.savePermission(form, true);
	  },
	
	  savePermission: function (form, reset) {
	    if (form.isValid()) {
	      Ext.Ajax.request({
	        url: Suncode.context('change-data').pluginContextPath + '/permissions/save',
	        method: 'POST',
	        jsonData: form.getValues(),
	        scope: this,
	        success: function (response) {
	          this.manageResponse(
	            response,
	            function () {
	              this.getPermissionsGrid().getStore().load();
	              if (reset) {
	                form.reset();
	              }
	            },
	            this
	          );
	        },
	        failure: function () {
	          // TODO błąd serwera
	        },
	      });
	    }
	  },
	
	  onResourceTypeGroupChange: function (radioGroup, newValue) {
	    var form = this.getNewPermissionForm(),
	      userCombo = form.down('#userCombo'),
	      groupCombo = form.down('#groupCombo');
	
	    userCombo.setDisabled(newValue.resourceType != 'USER');
	    groupCombo.setDisabled(newValue.resourceType != 'GROUP');
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.changedata.administration.permissions.PermissionsController', {
	  extend: 'Ext.app.Controller',
	
	  refs: [
	    {
	      ref: 'assignmentGrid',
	      selector: 'change-data-admin-assignment-grid',
	    },
	  ],
	
	  init: function () {
	    this.control({
	      'change-data-admin-assignment-grid gridview': {
	        deleteClick: this.onDeleteClick,
	      },
	      'change-data-admin-assignment-grid': {
	        addClick: this.onAddClick,
	      },
	    });
	  },
	
	  onAddClick: function (processDefId, activityDefId, acceptanceButtonId) {
	    var me = this;
	    Ext.Ajax.request({
	      url: Suncode.context('change-data').pluginContextPath + '/assignment/add',
	      jsonData: {
	        processDefId: processDefId,
	        activityDefId: activityDefId,
	        acceptanceButtonId: acceptanceButtonId,
	      },
	      success: function (response) {
	        me.handleResponse(response);
	      },
	    });
	  },
	
	  onDeleteClick: function (assignmentId) {
	    var me = this;
	    Ext.Ajax.request({
	      url: Suncode.context('change-data').pluginContextPath + '/assignment/remove/' + assignmentId,
	      success: function (response) {
	        me.handleResponse(response);
	      },
	    });
	  },
	
	  handleResponse: function (response) {
	    var result = Ext.JSON.decode(response.responseText);
	    var me = this;
	    if (result.success) {
	      this.getAssignmentGrid()
	        .getStore()
	        .load(function (record, operation, success) {
	          me.getAssignmentGrid().doLayout();
	        });
	      PW.ui.Message.success(result.message);
	    } else {
	      PW.ui.Message.error(result.message);
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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