/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata.administration.permission;

import com.suncode.plugin.wizards.changedata.administration.AccessResource;
import com.suncode.plugin.wizards.changedata.administration.Permission;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PermissionDto {
    private static final Logger log = LoggerFactory.getLogger(PermissionDto.class);
    private Long id;
    private Long resourceId;
    private String resourceName;
    private AccessResource.ResourceType resourceType;

    public PermissionDto(Permission permission) {
        this.id = permission.getId();
        AccessResource resource = permission.getResource();
        this.resourceType = resource.getType();
        if (resource.getType() == AccessResource.ResourceType.USER) {
            User user = resource.getUser();
            if (user != null) {
                this.resourceId = user.getObjectId();
                this.resourceName = StringUtils.hasText((String)user.getFullName()) ? String.format("%s (%s)", user.getFullName(), user.getUserName()) : user.getUserName();
            }
        } else if (resource.getType() == AccessResource.ResourceType.GROUP && resource.getGroup() != null) {
            UserGroup group = resource.getGroup();
            this.resourceId = group.getObjectId();
            this.resourceName = group.getName();
        }
    }

    public static List<PermissionDto> from(List<Permission> list) {
        ArrayList<PermissionDto> result = new ArrayList<PermissionDto>();
        for (Permission permission : list) {
            PermissionDto dto = new PermissionDto(permission);
            if (dto.getResourceId() != null) {
                result.add(dto);
                continue;
            }
            log.warn("Pomijam uprawnienie ID {} - u\u017cytkownik/grupa o ID {} nie istnieje", (Object)permission.getId(), permission.getResource() != null ? permission.getResource().getId() : "unknown");
        }
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public AccessResource.ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setResourceType(AccessResource.ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public PermissionDto() {
    }
}

