/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata.administration.permission.internal;

import com.suncode.plugin.wizards.changedata.administration.AccessResource;
import com.suncode.plugin.wizards.changedata.administration.Permission;
import com.suncode.plugin.wizards.changedata.administration.permission.PermissionDto;
import com.suncode.plugin.wizards.changedata.administration.permission.PermissionRepository;
import com.suncode.plugin.wizards.changedata.administration.permission.PermissionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private UserService userService;
    @Autowired
    private PermissionRepository permissionRepository;

    @Override
    public List<Permission> getAll() {
        return this.permissionRepository.findByCriteria(DetachedCriteria.forClass(Permission.class));
    }

    @Override
    public Permission get(Long id) {
        return (Permission)this.permissionRepository.get(id);
    }

    @Override
    public void delete(Permission permission) {
        this.permissionRepository.delete(permission);
    }

    @Override
    public void save(PermissionDto permissionDto) {
        Long id = permissionDto.getId();
        Permission permission = id == null ? this.newPermission(permissionDto) : this.updatePermission(permissionDto, id);
        this.permissionRepository.save(permission);
    }

    private Permission updatePermission(PermissionDto permissionDto, Long id) {
        Permission permission = this.get(id);
        return permission;
    }

    private Permission newPermission(PermissionDto permissionDto) {
        AccessResource resource = this.getResource(permissionDto.getResourceId(), permissionDto.getResourceType());
        Permission permission = this.getPermissionByResource(resource);
        if (permission == null) {
            permission = new Permission();
            permission.setResource(resource);
        }
        return permission;
    }

    private Permission getPermissionByResource(AccessResource resource) {
        DetachedCriteria dc = DetachedCriteria.forClass(Permission.class);
        dc.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        return (Permission)this.permissionRepository.findOne(dc);
    }

    private AccessResource getResource(Long id, AccessResource.ResourceType type) {
        switch (type) {
            case USER: {
                return new AccessResource(this.userService.getUser(id, new String[0]));
            }
            case GROUP: {
                return new AccessResource(this.userService.getGroup(id, new String[0]));
            }
        }
        throw new IllegalStateException("Unknown type of resource: " + type);
    }

    @Override
    public boolean hasUserPermission(String currentUser) {
        User user = this.userService.getUser(currentUser, new String[]{"groups"});
        return this.hasUserPermission(user) || this.hasUserGroupsPermission(user.getGroups());
    }

    private boolean hasUserPermission(User user) {
        Permission result = (Permission)this.permissionRepository.findOneByProperty("resource.id", user.getObjectId(), new String[0]);
        return result != null;
    }

    private boolean hasUserGroupsPermission(Set<UserGroup> groups) {
        for (UserGroup group : groups) {
            Permission result = (Permission)this.permissionRepository.findOneByProperty("resource.id", group.getObjectId(), new String[0]);
            if (result == null) continue;
            return true;
        }
        return false;
    }
}

