/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata.administration.permission;

import com.suncode.plugin.wizards.changedata.administration.AccessResource;
import com.suncode.plugin.wizards.changedata.administration.Permission;
import com.suncode.pwfl.administration.user.User;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class PermissionDto {
    private Long id;
    private Long resourceId;
    private String resourceName;
    private AccessResource.ResourceType resourceType;

    public PermissionDto() {
    }

    public PermissionDto(Permission permission) {
        this.id = permission.getId();
        AccessResource resource = permission.getResource();
        this.resourceType = resource.getType();
        if (resource.getType() == AccessResource.ResourceType.USER) {
            User user = resource.getUser();
            this.resourceId = user.getObjectId();
            this.resourceName = StringUtils.hasText((String)user.getFullName()) ? String.format("%s (%s)", user.getFullName(), user.getUserName()) : user.getUserName();
        } else if (resource.getType() == AccessResource.ResourceType.GROUP) {
            this.resourceId = resource.getGroup().getObjectId();
            this.resourceName = resource.getGroup().getName();
        }
    }

    public static List<PermissionDto> from(List<Permission> list) {
        ArrayList<PermissionDto> result = new ArrayList<PermissionDto>();
        for (Permission permission : list) {
            PermissionDto dto = new PermissionDto(permission);
            result.add(dto);
        }
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public AccessResource.ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(AccessResource.ResourceType resourceType) {
        this.resourceType = resourceType;
    }
}

