/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.SectionCondition;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardImplementation;
import com.suncode.plugin.wizards.changedata.ChangeDataConfig;
import com.suncode.plugin.wizards.changedata.ChangeDataTask;
import com.suncode.plugin.wizards.changedata.ChangeDataTaskDefinition;
import com.suncode.plugin.wizards.changedata.administration.permission.PermissionService;
import com.suncode.plugin.wizards.execution.config.WizardMenu;
import com.suncode.plugin.wizards.execution.config.process.ProcessUnit;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class ChangeDataWizard
implements WizardImplementation<ChangeDataConfig, ChangeDataTask> {
    @Autowired
    private Plugin plugin;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private VariableFactory variableFactory;
    private static final Condition searchTypeCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.getSearchType() == SearchResultActionSection.SearchType.PROCESS || section.getSearchType() == SearchResultActionSection.SearchType.ACTIVITY;
        }
    };
    private static final Condition resultsCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.count() > 0;
        }
    };
    private final Condition hasRights = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return ChangeDataWizard.this.permissionService.hasUserPermission(ChangeDataWizard.this.getLoggedUserName());
        }
    };

    private String getLoggedUserName() {
        return (String)this.getSessionAttribute("username");
    }

    private Object getSessionAttribute(String name) {
        return this.getCurrentRequestAttributes().getAttribute(name, 1);
    }

    private RequestAttributes getCurrentRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            throw new IllegalStateException("Current thread is not bound to HttpRequest");
        }
        return attributes;
    }

    public Class<ChangeDataConfig> configClass() {
        return ChangeDataConfig.class;
    }

    public void createMenus(Wizard<ChangeDataConfig, ChangeDataTask> wizard, WizardMenu builder) {
        builder.section("system.search.result.menu").add("change-data", new LocalizedMessage(this.plugin, "changedata.menu.search.name", new Object[0]), new Condition[]{searchTypeCondition, resultsCondition, this.hasRights});
    }

    public List<ChangeDataTask> createTasks(ChangeDataConfig config) {
        ArrayList<ChangeDataTask> result = new ArrayList<ChangeDataTask>();
        Map<String, String> activitiesToChangeMap = config.getActivitiesToChangeMap();
        Map<String, Object> data = config.getFormValues();
        this.skipEmptyData(data);
        for (ProcessUnit unit : config.getUnits()) {
            String processId = unit.getId();
            Process process = this.processService.getProcess(processId, new String[]{"processDefinition"});
            String processDefId = process.getProcessDefinition().getProcessDefinitionId();
            String activityDefId = activitiesToChangeMap.get(processDefId);
            this.setValueByType(processId, activityDefId, data);
            result.add(new ChangeDataTask(ChangeDataTaskDefinition.builder().plugin(this.plugin).processId(processId).processDefId(processDefId).activityDefId(activityDefId).data(data).comment(config.getComment()).build()));
        }
        return result;
    }

    private void skipEmptyData(Map<String, Object> data) {
        data.entrySet().removeIf(entry -> {
            Object value = entry.getValue();
            if (value == null) {
                return true;
            }
            return StringUtils.isEmpty((CharSequence)String.valueOf(value));
        });
    }

    private boolean shouldSetEmpty(Object value) {
        return value != null && value instanceof String && ((String)value).equalsIgnoreCase("<empty>");
    }

    private void setValueByType(String processDefId, String activityDefId, Map<String, Object> data) {
        Map variablesMap = this.variableFactory.createVariables(processDefId, activityDefId, data, false);
        data.forEach((key, val) -> {
            Variable variable = (Variable)variablesMap.get(key);
            if (variable != null) {
                if (!variable.isArray() && this.shouldSetEmpty(variable.getValue())) {
                    variable.setValue((Object)"");
                }
                data.put((String)key, variable.getValueAsBasicType());
            }
        });
    }
}

