/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.changedata;

import com.plusmpm.util.SharkFunctions;
import com.suncode.plugin.wizards.changedata.ChangeDataException;
import com.suncode.plugin.wizards.changedata.ChangeDataTaskDefinition;
import com.suncode.plugin.wizards.changedata.administration.assignment.Assignment;
import com.suncode.plugin.wizards.changedata.administration.assignment.AssignmentService;
import com.suncode.plugin.wizards.changedata.util.SpringUtil;
import com.suncode.plugin.wizards.execution.state.SimpleTaskExecutionState;
import com.suncode.plugin.wizards.execution.state.TaskExecutionState;
import com.suncode.plugin.wizards.execution.task.TaskContext;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessState;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ChangeDataTask
implements WizardTask {
    private static final Logger log = LoggerFactory.getLogger(ChangeDataTask.class);
    private final ActivityService activityService = ServiceFactory.getActivityService();
    private final ProcessService processService = ServiceFactory.getProcessService();
    private final AssignmentService assignmentService = (AssignmentService)SpringUtil.getContext().getBean(AssignmentService.class);
    private final VariableFactory variableFactory = (VariableFactory)SpringUtil.getContext().getBean(VariableFactory.class);
    private final ChangeDataTaskDefinition definition;
    private Map<String, Object> context = new HashMap<String, Object>();
    private String startedActivityId;
    private final String defaultChangeDataButton = "pwfl_change_data_default_button";

    public ChangeDataTask(ChangeDataTaskDefinition definition) {
        this.definition = definition;
    }

    public TaskExecutionState.TaskExecutionStatus execute(SimpleTaskExecutionState state, TaskContext taskContext) {
        if (this.definition.isToSkip()) {
            state.setMessage(this.definition.getMessage());
            return TaskExecutionState.TaskExecutionStatus.SKIPPED;
        }
        return this.changeData(state, taskContext) && this.addComment(taskContext.getLoggedUsername()) ? TaskExecutionState.TaskExecutionStatus.EXECUTED : TaskExecutionState.TaskExecutionStatus.FAILED;
    }

    private boolean changeData(final SimpleTaskExecutionState state, final TaskContext taskContext) {
        this.context = this.processService.getProcessContext(this.definition.getProcessId());
        final Map<String, Object> changedContext = this.getChangedContext(this.context);
        final SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)mgr);
        return (Boolean)tt.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    Activity lastActivity;
                    Assignment assignment = ChangeDataTask.this.assignmentService.getAssignment(ChangeDataTask.this.definition.getProcessDefId(), ChangeDataTask.this.definition.getActivityDefId());
                    ActivityFinder activityFinder = FinderFactory.getActivityFinder();
                    List openActivities = activityFinder.findOpenedActivities(ChangeDataTask.this.definition.getProcessId());
                    if ("pwfl_change_data_default_button".equals(assignment.getAcceptanceButtonId()) && CollectionUtils.isNotEmpty((Collection)openActivities)) {
                        ChangeDataTask.this.changeContextOpenActivities(changedContext, openActivities);
                        ChangeDataTask.this.startedActivityId = (String)changedContext.get("ActivityId");
                        return true;
                    }
                    SharkTransaction st = mgr.getSharkTransaction();
                    ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                    String admin = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
                    String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
                    ea.connect(st, admin, password, "KlientTestowy", null);
                    WfProcess wfProcess = SharkFunctions.GetWfProcess((ExecutionAdministration)ea, (String)ChangeDataTask.this.definition.getProcessId());
                    ProcessState processState = ProcessState.getState((String)wfProcess.state(st));
                    boolean isOpen = ProcessState.isOpen((ProcessState)processState);
                    if (!isOpen) {
                        wfProcess.reopen(st);
                    }
                    if ((lastActivity = activityFinder.findLastActivity(ChangeDataTask.this.definition.getProcessId())) != null) {
                        WfActivity lastWfActivity = ea.getActivity(st, lastActivity.getProcessId(), lastActivity.getActivityId());
                        ChangeDataTask.this.startedActivityId = ea.startActivityFrom(st, ChangeDataTask.this.definition.getProcessId(), null, ChangeDataTask.this.definition.getActivityDefId(), taskContext.getLoggedUsername(), new WfActivity[]{lastWfActivity});
                    } else {
                        ChangeDataTask.this.startedActivityId = ea.startActivity(st, ChangeDataTask.this.definition.getProcessId(), null, ChangeDataTask.this.definition.getActivityDefId(), taskContext.getLoggedUsername());
                    }
                    if (ChangeDataTask.this.startedActivityId == null) {
                        throw new ChangeDataException("Activity " + ChangeDataTask.this.definition.getActivityDefId() + " is already started - can't start it twice. To create more than one activity of the same type, the activity definition must include the option allowing creation of parallel activities.");
                    }
                    if (assignment == null) {
                        state.setMessage(ChangeDataTask.this.definition.getPlugin().getMessage("changedata.execution.noassignmenterror", new Object[]{ChangeDataTask.this.definition.getProcessDefId(), ChangeDataTask.this.definition.getActivityDefId()}));
                        return false;
                    }
                    String actionName = assignment.getAcceptanceButtonId();
                    AcceptationDefinition acceptationDefinition = new AcceptationDefinition(ChangeDataTask.this.definition.getProcessId(), ChangeDataTask.this.startedActivityId, taskContext.getLoggedUsername(), actionName, changedContext);
                    acceptationDefinition.setIgnoreOwnerShip(Boolean.valueOf(true));
                    ChangeDataTask.this.activityService.acceptActivity(acceptationDefinition);
                    ChangeDataTask.this.changeContextOpenActivities(changedContext, openActivities);
                    return true;
                }
                catch (Exception e) {
                    log.error("Error occurred while opening activity {} in process {}", new Object[]{ChangeDataTask.this.definition.getActivityDefId(), ChangeDataTask.this.definition.getProcessId(), e});
                    return false;
                }
            }
        });
    }

    private Map<String, Object> getChangedContext(Map<String, Object> context) {
        Map variables = this.variableFactory.createVariables(this.definition.getProcessId(), context.get("ActivityId").toString(), context, true);
        Map<String, Object> changeData = this.definition.getData();
        HashMap<String, Object> changedContext = new HashMap<String, Object>(context);
        context.forEach((key, contextVariable) -> {
            if (changeData.containsKey(key) && variables.containsKey(key)) {
                Variable variable = (Variable)variables.get(key);
                Object changeVariable = changeData.get(key);
                contextVariable = variable != null && variable.isArray() ? this.changeArrayVariable(variable, changeVariable.toString(), contextVariable) : changeVariable;
            }
            changedContext.put((String)key, contextVariable);
        });
        return changedContext;
    }

    private Object changeArrayVariable(Variable variable, String updatedVariable, Object contextVariable) {
        CharSequence[] oldVariables = contextVariable.toString().split(";", -1);
        CharSequence[] changeDataVariables = updatedVariable.split(";", -1);
        if (changeDataVariables.length == 1 && this.shouldChangeArrayValue(updatedVariable, variable)) {
            contextVariable = String.join((CharSequence)";", Collections.nCopies(oldVariables.length, updatedVariable));
        } else if (changeDataVariables.length > 1 && changeDataVariables.length <= oldVariables.length) {
            for (int i = 0; i < oldVariables.length; ++i) {
                CharSequence changeDataVariable = changeDataVariables[i % changeDataVariables.length];
                if (!this.shouldChangeArrayValue((String)changeDataVariable, variable)) continue;
                oldVariables[i] = changeDataVariable;
            }
            contextVariable = String.join((CharSequence)";", oldVariables);
        } else if (changeDataVariables.length > oldVariables.length) {
            for (int i = 0; i < changeDataVariables.length; ++i) {
                String changeDataVariable = changeDataVariables[i];
                if (i >= oldVariables.length || this.shouldChangeArrayValue(changeDataVariable, variable)) continue;
                changeDataVariables[i] = oldVariables[i];
            }
            contextVariable = String.join((CharSequence)";", changeDataVariables);
        }
        return contextVariable.toString().replace("<empty>", "");
    }

    private boolean shouldChangeArrayValue(String changeValue, Variable variable) {
        if (StringUtils.isBlank((CharSequence)changeValue)) {
            return false;
        }
        if (variable.getType() == Types.INTEGER_ARRAY || variable.getType() == Types.FLOAT_ARRAY) {
            return Double.valueOf(changeValue) != 0.0;
        }
        return true;
    }

    private void changeContextOpenActivities(Map<String, Object> context, List<Activity> openActivities) {
        openActivities.forEach(openActivity -> this.activityService.setActivityContext(this.definition.getProcessId(), openActivity.getActivityId(), context));
    }

    private boolean addComment(String currentUsername) {
        if (StringUtils.isEmpty((CharSequence)this.definition.getComment())) {
            return true;
        }
        Comment newComment = new Comment();
        newComment.setProcessId(this.definition.getProcessId());
        newComment.setActivityId(this.startedActivityId);
        newComment.setUserId(currentUsername);
        newComment.setComment(this.definition.getComment());
        newComment.setTimestamp(Long.valueOf(new Date().getTime()));
        ServiceFactory.getCommentService().createComment(newComment, false);
        return true;
    }

    public String getTaskId() {
        return this.definition.getProcessId();
    }

    public Map<String, Object> getAuditTaskParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("changedata_processId", this.definition.getProcessId());
        params.putAll(this.changedContextVariables());
        return params;
    }

    private Map<String, Object> changedContextVariables() {
        LinkedHashMap<String, Object> changedVariables = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.definition.getData().entrySet()) {
            String key = entry.getKey();
            changedVariables.put(key, this.context.get(key) + " -> " + entry.getValue());
        }
        return changedVariables;
    }
}

