/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	__webpack_require__(1);
	var Application = __webpack_require__(3);
	var Viewport = __webpack_require__(4);
	var Wizard = __webpack_require__(5);
	
	Wizards.baseT = Wizards.I18N.createT('com.suncode.plugin-wizards-base');
	Wizards.t = Wizards.I18N.createT(Wizards.implPluginKey);
	
	/**
	 * Main application of Wizard
	 *
	 * @main
	 */
	var app = Application.create({
	  name: 'Wizards',
	  view: {
	    type: Viewport,
	    target: 'wizards-container',
	  },
	  launch: function (view) {
	    if (!this.wizard) {
	      //TODO komponent wyświetlający informacje
	      alert('NIE MA WIZARDA!!!');
	    }
	  },
	});
	/**
	 * Creates Wizard
	 *
	 * @method create
	 * @static
	 */
	Wizards.create = function (wizardConfig) {
	  app.wizard = Wizard.create(wizardConfig);
	  app.view.add(app.wizard);
	};


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var cached = {};
	
	module.exports = Ext.define('Wizards.I18N', {
	  singleton: true,
	
	  /**
	   * Returns translated message for given key and translator name.
	   *
	   * @example
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * @method t
	   * @param {String} translator translator name
	   * @param {String} key message key
	   * @param {...Object} [args] additional message arguments (resolved as placeholders i.e. {0})
	   * @return Translated message or supplied key if there is no translation available
	   */
	  t: function (translator, key) {
	    var message = this.bundle(translator)[key];
	    if (!Ext.isEmpty(message)) {
	      var args = Ext.Array.toArray(arguments, 2);
	      return Ext.String.format.apply(this, [message].concat(args));
	    }
	    return key;
	  },
	
	  /**
	   * Creates shorthand function for translating message using single translator. For example instead of
	   *
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * you can use create shorthand function once
	   *
	   * 	PW.t = PW.I18N.createT('plusworkflow');
	   *
	   * and then use it like
	   *
	   * 	PW.t('user.desc', 'Jan', 'Kowalski' );
	   *
	   * @method createT
	   * @param {String} translator translator name
	   */
	  createT: function (translator) {
	    return Ext.bind(this.t, this, [translator], 0);
	  },
	
	  bundle: function (key) {
	    var bundle = cached[key];
	
	    // Jeżeli nie ma załadowanego bundle'a to SYNCHRONICZNIE pobieramy go z bazy danych
	    if (!Ext.isObject(bundle)) {
	      Ext.Ajax.request({
	        url: Suncode.getAbsolutePath('/api/translation/bundle/' + encodeURIComponent(key)),
	        method: 'GET',
	        async: false,
	        timeout: 5000,
	        success: function (response) {
	          bundle = Ext.decode(response.responseText);
	          cached[key] = bundle;
	        },
	      });
	    }
	    return bundle || {};
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {// Przygotowanie kontekstu do przechowywania danych na temat aplikacji
	var context = Suncode.context('basewizard');
	if (!context.applications) {
	  context.applications = {};
	}
	
	/**
	 * Aplikacja
	 */
	module.exports = Ext.define('Wizards.app.Application', {
	  constructor: function (config) {
	    var existingApp = context.applications[config.name];
	    if (existingApp) {
	      existingApp.destroy();
	    }
	
	    try {
	      this.prepareControllers(config.controllers);
	      this.prepareView(config.view);
	      this.init(config.launch);
	    } finally {
	      context.applications[config.name] = this;
	    }
	  },
	
	  prepareControllers: function (controllers) {
	    this.controllers = [];
	    Ext.each(
	      controllers,
	      function (controllerClass) {
	        var controller = controllerClass.create();
	        controller.id = controllerClass.$className;
	
	        controller.fireGlobalEvent = function () {
	          Ext.globalEvents.fireEvent.apply(Ext.globalEvents, arguments);
	        };
	        controller.listenGlobal = function (event) {
	          Ext.globalEvents.on.apply(Ext.globalEvents, arguments);
	        };
	
	        this.controllers.push(controller);
	      },
	      this
	    );
	  },
	
	  prepareView: function (view) {
	    this.view = view.type.create({
	      renderTarget: view.target,
	    });
	  },
	
	  init: function (launchFn) {
	    Ext.tip.QuickTipManager.init();
	    Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider());
	
	    Ext.each(
	      this.controllers,
	      function (controller) {
	        controller.init();
	      },
	      this
	    );
	
	    Ext.onReady(
	      function () {
	        // render view
	        this.view.render(this.view.renderTarget);
	
	        // call launch
	        if (Ext.isFunction(launchFn)) {
	          launchFn.call(this, this.view);
	        }
	
	        Ext.each(
	          this.controllers,
	          function (controller) {
	            controller.finishInit();
	          },
	          this
	        );
	      },
	      this,
	      {
	        single: true,
	      }
	    );
	  },
	
	  destroy: function () {
	    if (this.view) {
	      this.view.destroy();
	    }
	
	    if (this.controllers) {
	      Ext.each(
	        this.controllers,
	        function (controller) {
	          controller.eventbus.unlisten(controller.id);
	        },
	        this
	      );
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * Bazowy Viewport
	 */
	module.exports = Ext.define('Wizards.app.Viewport', {
	  extend: 'Ext.container.Container',
	  style: {
	    'text-align': 'left',
	  },
	  layout: 'fit',
	
	  onRender: function () {
	    this.callParent(arguments);
	    this.height = Ext.Element.getViewportHeight() - 124;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(6);
	__webpack_require__(7);
	__webpack_require__(8);
	__webpack_require__(9);
	//TODO czy tutaj mam być zaciagane?
	__webpack_require__(11);
	__webpack_require__(12);
	__webpack_require__(15);
	__webpack_require__(18);
	__webpack_require__(21);
	__webpack_require__(22);
	
	/**
	 * Management component of wizard.
	 *
	 * @class Wizard.wizard.Wizard
	 */
	module.exports = Ext.define('Wizards.wizard.Wizard', {
	  extend: 'Ext.panel.Panel',
	  id: 'wizard',
	  layout: {
	    type: 'hbox',
	    align: 'stretch',
	  },
	  /**
	   * Index of active step
	   */
	  activeStep: 0,
	
	  constructor: function (config) {
	    this.addEvents(
	      /**
	       * Fires when the step is changed
	       *
	       * @event stepchange
	       */
	      'stepchange'
	    );
	
	    /**
	     * Config object:
	     * </br>
	     * @property steps Steps of Wizard
	     * @property wizardData Initial Wizard data
	     */
	    Ext.apply(this, {
	      steps: config.steps,
	      wizardData: config.wizardData || {},
	      wizardTempData: {},
	    });
	    this.callParent();
	  },
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'wizard-stepsview',
	        width: 250,
	        wizard: this,
	        style: 'border-right: 1px solid #cfcfcf',
	      },
	      {
	        xtype: 'wizard-container',
	        flex: 1,
	        wizard: this,
	      },
	    ];
	
	    this.callParent(arguments);
	
	    this.stepsView = this.down('wizard-stepsview');
	    this.wizardContainer = this.down('wizard-container');
	
	    var me = this;
	    this.steps = Ext.Array.map(this.steps, function (step, i) {
	      var newStep = Ext.create(step);
	      newStep.bindWizard(me);
	
	      return newStep;
	    });
	
	    me.wizardContainer.add(this.steps);
	
	    this.startStep(this.steps[this.activeStep]);
	  },
	
	  /**
	   * The transition to the next step of Wizard.
	   *
	   * @method nextStep
	   */
	  nextStep: function () {
	    if (!this.hasNextStep) {
	      return;
	    }
	    var activeStep = this.getActiveStep();
	    if (activeStep.validate()) {
	      activeStep.saveConfig();
	      var nextStep = this.steps[++this.activeStep];
	      this.changeStep(activeStep, nextStep);
	    }
	  },
	
	  /**
	   * Back to the previous step of Wizard.
	   *
	   * @method prevStep
	   */
	  prevStep: function () {
	    if (!this.hasPrevStep) {
	      return;
	    }
	    var activeStep = this.getActiveStep();
	    var prevStep = this.steps[--this.activeStep];
	    this.changeStep(activeStep, prevStep);
	  },
	
	  /**
	   * Checks if Wizard has next step
	   *
	   * @method hasNextStep
	   * @return {Boolean} True if Wizard has next step otherwise false
	   */
	  hasNextStep: function () {
	    return this.activeStep < this.steps.length - 1;
	  },
	
	  /**
	   * Checks if Wizard has previous step
	   *
	   * @method hasPrevStep
	   * @return {Boolean} True if Wizard has previous step otherwise false
	   */
	  hasPrevStep: function () {
	    return this.activeStep > 0;
	  },
	
	  /**
	   * The transition from step 'from' to step 'to'.
	   *
	   * @method changeStep
	   * @param {Object} from Source step
	   * @param {Object} to Target step
	   */
	  changeStep: function (from, to) {
	    this.endStep(from);
	    this.startStep(to);
	  },
	
	  /**
	   * Returns active step.
	   *
	   * @method getActiveStep
	   * @return {Object} Active step
	   */
	  getActiveStep: function () {
	    return this.steps[this.activeStep];
	  },
	
	  /**
	   * Returns all current steps of Wizard.
	   *
	   * @method getSteps
	   * @return {Array} Array of Wizard's steps
	   */
	  getSteps: function () {
	    return this.steps;
	  },
	
	  /**
	   * Saves Wizard data.
	   * </br>
	   * These data will be sent to the server.
	   *
	   * @method saveData
	   * @param {Object} data Data to be saved
	   * @param {Boolean} asTemp If true then data are saved in temp data otherwise in Wizard data
	   */
	  saveData: function (data, asTemp) {
	    asTemp = asTemp || false;
	    asTemp ? Ext.apply(this.wizardTempData, data) : Ext.apply(this.wizardData, data);
	  },
	
	  /**
	   * Returns single Wizard data.
	   *
	   * @method getData
	   * @param {String} property Property of data object to be returned
	   * @param {Boolean} asTemp If true then returned temp data otherwise Wizard data
	   * @return {Object} Single data
	   */
	  getData: function (property, fromTemp) {
	    fromTemp = fromTemp || false;
	    return fromTemp ? this.wizardTempData[property] : this.wizardData[property];
	  },
	
	  /**
	   * Returns Wizard data.
	   *
	   * @method getAllData
	   * @param {String} property Property of data object to be returned
	   * @param {Boolean} asTemp If true then returned all temp data otherwise all Wizard data
	   * @return {Object} All Wizard data
	   */
	  getAllData: function (fromTemp) {
	    fromTemp = fromTemp || false;
	    return fromTemp ? this.wizardTempData : this.wizardData;
	  },
	
	  /**
	   * Deletes Wizard data object by property.
	   *
	   * @method deleteDataByProperty
	   * @param {String} property Property of Wizard data object to be removed
	   * @param {Boolean} asTemp If true then deleted from temp data otherwise from Wizard data
	   */
	  deleteDataByProperty: function (property, fromTemp) {
	    fromTemp = fromTemp || false;
	    var dataSource = fromTemp ? 'wizardTempData' : 'wizardData';
	    if (this[dataSource][property]) {
	      delete this[dataSource][property];
	    }
	  },
	
	  /**
	   * Starts step of Wizard.
	   * @private
	   */
	  startStep: function (step) {
	    this.wizardContainer.getLayout().setActiveItem(step);
	    step.activate();
	    this.fireEvent('stepchange');
	  },
	
	  /**
	   * Ends step of Wizard.
	   * @private
	   */
	  endStep: function (step) {
	    step.deactivate();
	  },
	
	  /**
	   * Hides toolbar of WizardContainer
	   */
	  hideContainerToolbar: function () {
	    this.wizardContainer.hideToolbar();
	  },
	
	  /**
	   * Shows toolbar of WizardContainer
	   */
	  showConatainerToolbar: function () {
	    this.wizardContainer.showToolbar();
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * Step of Wizard.
	 *
	 * @class Wizards.wizard.Step
	 */
	module.exports = Ext.define('Wizards.wizard.Step', {
	  extend: 'Ext.container.Container',
	  xtype: 'wizard-step',
	
	  padding: 10,
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	    defaultMargins: '0 0 10 0',
	  },
	  border: false,
	
	  /**
	   * Shows if step is active.
	   */
	  active: false,
	
	  constructor: function () {
	    this.addEvents(
	      /**
	       * Fires when step is activated
	       *
	       * @event activated
	       */
	      'activated',
	      /**
	       * Fires when step is deactivated
	       *
	       * @event deactivated
	       */
	      'deactivated'
	    );
	    this.callParent(arguments);
	  },
	
	  initComponent: function () {
	    this.items.unshift(
	      {
	        xtype: 'container',
	        layout: {
	          type: 'hbox',
	          pack: 'end',
	        },
	        items: [
	          {
	            xtype: 'button',
	            iconCls: 'dvnt-icon-x-symbol dvnt-red-icon',
	            handler: function () {
	              let redirectUrl = sessionStorage.getItem('redirectUrl');
	              if (redirectUrl) {
	                window.location = redirectUrl;
	              } else {
	                window.location = Wizards.contextPath;
	              }
	            },
	          },
	        ],
	      },
	      {
	        xtype: 'container',
	        itemId: 'wizard-step-messages-box',
	      }
	    );
	
	    Ext.each(this.items, function (item) {
	      if (item.description) {
	        item.afterLabelTpl = item.description;
	      }
	      if (!item.labelAlign) {
	        item.labelAlign = 'top';
	      }
	    });
	    this.callParent(arguments);
	  },
	
	  /**
	   * Bind {{#crossLink "Wizards.wizard.Wizard"}}{{/crossLink}} to this {{#crossLink "Wizards.wizard.Step"}}{{/crossLink}}.
	   *
	   * @method bindWizard
	   * @param {Object} wizard
	   */
	  bindWizard: function (wizard) {
	    this.wizard = wizard;
	  },
	
	  /**
	   * Actives step.
	   *
	   * @method active
	   */
	  activate: function () {
	    this.active = true;
	    this.fireEvent('activated');
	    this.activated();
	  },
	
	  /**
	   * Calls after activation step.
	   *
	   * @method activated
	   */
	  activated: function () {},
	
	  /**
	   * Validates step.
	   *
	   * @method validate
	   */
	  validate: function () {
	    return true;
	  },
	
	  /**
	   * Saves config of Wizard.
	   *
	   * @method saveConfig
	   */
	  saveConfig: function () {
	    this.saveStepConfig(true);
	    this.saveStepConfig();
	  },
	
	  /**
	   * Deactivates step.
	   *
	   * @method deactivate
	   */
	  deactivate: function () {
	    this.active = false;
	    this.fireEvent('deactivated');
	    this.deactivated();
	  },
	
	  /**
	   * Calls after deactivation step.
	   *
	   * @method deactivated
	   */
	  deactivated: function () {},
	
	  /**
	   * Saves config of Wizard
	   *
	   * @method saveStepConfig
	   * @param {Boolean} asTemp If true then config is saved in temp config otherwise in Wizard config
	   */
	  saveStepConfig: function (asTemp) {
	    asTemp = asTemp || false;
	    var property = asTemp ? 'wizardTempProperty' : 'wizardProperty';
	    var components = this.query('component[' + property + ']');
	    Ext.each(
	      components,
	      function (component) {
	        var configCondition = asTemp ? 'getTempConfigCondition' : 'getConfigCondition';
	        if (Ext.isFunction(component[configCondition]) && !component[configCondition]()) {
	          this.deleteDataByProperty(component[property], asTemp);
	          return;
	        }
	        var obj = {};
	        var readFunction = asTemp ? 'readTempData' : 'readData';
	        if (Ext.isFunction(component[readFunction])) {
	          obj[component[property]] = component[readFunction]() || {};
	        } else if (Ext.isFunction(component.getValue)) {
	          obj[component[property]] = component.getValue();
	        }
	        this.saveData(obj, asTemp);
	      },
	      this
	    );
	  },
	  saveComponentData: function (component, readFunction, asTemp) {
	    var obj = {};
	    obj[component[property]] = component[readFunction]() || {};
	    this.saveData(obj, asTemp);
	  },
	
	  /**
	   * Shortcut to call "Wizards.wizard.Wizard:saveData".
	   *
	   * @method saveData
	   * @param {Boolean} asTemp
	   */
	  saveData: function (data, asTemp) {
	    asTemp = asTemp || false;
	    this.wizard.saveData(data, asTemp);
	  },
	
	  /**
	   * Shortcut to call "Wizards.wizard.Wizard:getData".
	   *
	   * @method getData
	   * @param {Boolean} asTemp
	   */
	  getData: function (property, fromTemp) {
	    fromTemp = fromTemp || false;
	    return this.wizard.getData(property, fromTemp);
	  },
	
	  /**
	   * Shortcut to call "Wizards.wizard.Wizard:getAllData".
	   *
	   * @method getAllData
	   * @param {Boolean} asTemp
	   */
	  getAllData: function (fromTemp) {
	    fromTemp = fromTemp || false;
	    return this.wizard.getAllData(fromTemp);
	  },
	
	  /**
	   * Shortcut to call "Wizards.wizard.Wizard:deleteDataByProperty".
	   *
	   * @method deleteDataByProperty
	   * @param {Boolean} asTemp
	   */
	  deleteDataByProperty: function (property, fromTemp) {
	    fromTemp = fromTemp || false;
	    return this.wizard.deleteDataByProperty(property, fromTemp);
	  },
	
	  // TODO Pewnie powinien to robić sam 'item', a nie 'step', ale dopoki
	  // brak wspólnej klasy dla elementów kroku to ta logika znajduje tutaj
	  setInvalid: function (item, errorMsg) {
	    errorMsg = errorMsg || item.errorMsg || Wizards.baseT('base.step.field.error.validation');
	    item.setActiveError(errorMsg);
	    item.doComponentLayout();
	  },
	
	  unsetInvalid: function (item) {
	    item.unsetActiveError();
	    item.doComponentLayout();
	  },
	
	  clearMessages: function () {
	    this.showMessages([]);
	  },
	
	  showMessages: function (messages) {
	    var messagesBox = this.down('#wizard-step-messages-box');
	    messagesBox.removeAll();
	    Ext.each(
	      messages,
	      function (message) {
	        this.addMessage(message, messagesBox);
	      },
	      this
	    );
	  },
	
	  addMessage: function (message, box) {
	    box = box || this.down('#wizard-step-messages-box');
	    box.add({
	      xtype: 'wizard-message-box',
	      text: message.text,
	      type: message.type,
	    });
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/*
	 * TODO doc
	 * Klasa używana dla komponentów, które nie wspierają dodawania etykiet.
	 * Dodaje etykiete i komponent
	 */
	module.exports = Ext.define('Wizards.wizard.StepItem', {
	  extend: 'Ext.form.FieldContainer',
	  xtype: 'wizard-step-item',
	
	  layout: 'fit',
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * View displays Wizard steps.
	 *
	 * @class Wizards.wizard.WizardContainer
	 */
	module.exports = Ext.define('Wizards.wizard.WizardContainer', {
	  extend: 'Ext.panel.Panel',
	  xtype: 'wizard-container',
	  layout: 'card',
	  defaults: {
	    autoScroll: true,
	  },
	  border: false,
	  //TODO stworzyc nowy komponent toolbar z tymi przyciskami
	  initComponent: function () {
	    this.bbar = {
	      items: [
	        {
	          xtype: 'button',
	          itemId: 'prev-step',
	          text: Wizards.baseT('base.button.back'),
	          iconCls: 'dvnt-icon-left-straight',
	          disabled: true,
	          handler: this.onPrevClick,
	          scope: this,
	        },
	        {
	          xtype: 'button',
	          itemId: 'next-step',
	          text: Wizards.baseT('base.button.next'),
	          iconCls: 'dvnt-icon-right-straight',
	          iconAlign: 'right',
	          handler: this.onNextClick,
	          scope: this,
	        },
	      ],
	    };
	    this.callParent(arguments);
	
	    this.wizard.on(
	      'stepchange',
	      function () {
	        this.refreshButtons();
	      },
	      this
	    );
	  },
	
	  /**
	   * Action on prev button click.
	   * @private
	   */
	  onPrevClick: function () {
	    this.wizard.prevStep();
	  },
	
	  /**
	   * Action on next button click.
	   * @private
	   */
	  onNextClick: function () {
	    this.wizard.nextStep();
	  },
	
	  /**
	   * Refreshes visibility of buttons.
	   * @private
	   */
	  refreshButtons: function () {
	    this.down('#prev-step').setDisabled(!this.wizard.hasPrevStep());
	    this.down('#next-step').setDisabled(!this.wizard.hasNextStep());
	  },
	
	  /**
	   * Hides toolbar
	   */
	  hideToolbar: function () {
	    this.down('toolbar').hide();
	  },
	
	  /**
	   * Shows toolbar
	   */
	  showToolbar: function () {
	    this.down('toolbar').show();
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var stepTpl = __webpack_require__(10);
	
	/**
	 * View displays status of Wizard's steps
	 *
	 * @class Wizards.wizard.StepsView
	 */
	module.exports = Ext.define('Wizards.wizard.StepsView', {
	  extend: 'Ext.Component',
	  xtype: 'wizard-stepsview',
	  tpl: stepTpl,
	  cls: 'wizard-step-view',
	
	  constructor: function () {
	    this.callParent(arguments);
	
	    this.wizard.on(
	      'stepchange',
	      function () {
	        this.updateSteps();
	      },
	      this
	    );
	  },
	
	  /**
	   * Update view of steps
	   *
	   * @method updateSteps
	   */
	  updateSteps: function () {
	    var steps = this.wizard.getSteps();
	    this.update(steps);
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * Template of StepsView
	 */
	module.exports = new Ext.XTemplate(
	  '<tpl for=".">',
	  '<div class="wizard-step-view-item ',
	  '<tpl if="xindex-1 < wizard.activeStep">',
	  'wizard-step-view-item-done',
	  '<tpl elseif="active">',
	  'wizard-step-view-item-active',
	  '</tpl>',
	  '">',
	  '{#}. {name}',
	  '</div>',
	  '</tpl>'
	);
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.components.SelectionGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-selectiongrid',
	  store: undefined,
	  columns: [],
	  selModel: {
	    selType: 'checkboxmodel',
	    checkOnly: true,
	  },
	
	  initComponent: function () {
	    this.callParent(arguments);
	
	    //this.initEvents();
	    //this.initStoreEvents();
	
	    this.on(
	      'render',
	      function () {
	        this.store.load();
	      },
	      this
	    );
	
	    this.store.on(
	      'metachange',
	      function (store, meta) {
	        this.reconfigure(store, meta.columns);
	        var step = this.up('wizard-step');
	        step.wizard.saveData(
	          {
	            columnsConfig: meta,
	          },
	          true
	        );
	        if (meta.messages) {
	          var step = this.up('wizard-step');
	          step.showMessages(meta.messages);
	        }
	      },
	      this
	    );
	
	    this.store.on(
	      'load',
	      function (store, records, successful) {
	        var step = this.up('wizard-step');
	        if (successful) {
	          var selectionModel = this.getSelectionModel();
	          var selectionModelCount = selectionModel.store.data.items.length;
	          step.saveData(
	            {
	              loadedRecords: records,
	              selectionModelCount: selectionModelCount,
	            },
	            true
	          );
	
	          if (selectionModelCount == 1) {
	            selectionModel.select(0);
	            step.wizard.nextStep();
	          }
	        }
	      },
	      this
	    );
	  },
	  readTempData: function () {
	    return this.getSelectionModel().getSelection();
	  },
	  readData: function () {
	    var selectedItems = this.getSelectionModel().getSelection();
	    var selectedIds = [];
	    Ext.each(selectedItems, function (selected) {
	      selectedIds.push({
	        id: selected.data.id,
	      });
	    });
	    return selectedIds;
	  },
	  validate: function () {
	    return this.getSelectionModel().getCount() > 0;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var selectProcessStore = __webpack_require__(13);
	
	module.exports = Ext.define('Wizards.components.selectprocess.SelectProcessGrid', {
	  extend: 'Wizards.components.SelectionGrid',
	  xtype: 'wizard-selectprocessgrid',
	  store: selectProcessStore,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(14);
	
	module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'selectprocessstore',
	  model: 'Wizards.components.selectprocess.SelectProcessGrid',
	  proxy: {
	    type: 'ajax',
	    url: Wizards.pluginContextPath + '/components/selectprocess',
	    extraParams: {
	      section: Wizards.section,
	      searchId: Wizards.searchContext.searchId,
	    },
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.components.selectprocess.SelectProcessModel', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    { name: 'id', type: 'string' },
	    { name: 'processDefinitionId', type: 'string' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var selectActivityStore = __webpack_require__(16);
	
	module.exports = Ext.define('Wizards.components.selectactivity.SelectActivityGrid', {
	  extend: 'Wizards.components.SelectionGrid',
	  xtype: 'wizard-selectactivitygrid',
	  store: selectActivityStore,
	
	  readData: function () {
	    var selectedItems = this.getSelectionModel().getSelection();
	    var selectedIds = [];
	    Ext.each(selectedItems, function (selected) {
	      selectedIds.push({
	        id: selected.data.id,
	      });
	    });
	    return selectedIds;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(17);
	
	module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'selectactivitystore',
	  model: 'Wizards.components.selectactivity.SelectActivityGrid',
	  proxy: {
	    type: 'ajax',
	    url: Wizards.pluginContextPath + '/components/selectactivity',
	    extraParams: {
	      section: Wizards.section,
	      searchId: Wizards.searchContext.searchId,
	    },
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.components.selectprocess.SelectActivityModel', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    { name: 'id', type: 'string' },
	    { name: 'activityDefinitionId', type: 'string' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var SummaryGrid = __webpack_require__(19);
	
	module.exports = Ext.define('Wizards.components.summary.SummaryStep', {
	  extend: 'Wizards.wizard.Step',
	  xtype: 'wizard-process-summary-step',
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'wizard-step-item',
	        description: Wizards.baseT('base.summary.step.description'),
	        flex: 1,
	        items: [
	          {
	            xtype: 'wizard-summary-grid',
	            itemId: 'wizard-summary-grid',
	          },
	        ],
	      },
	      {
	        xtype: 'container',
	        itemId: 'wizard-result-box',
	      },
	      {
	        xtype: 'container',
	        layout: {
	          type: 'hbox',
	          pack: 'center',
	          defaultMargins: '0 5 0 0',
	        },
	        items: [
	          {
	            xtype: 'button',
	            itemId: 'execute-button',
	            text: Wizards.baseT('base.summary.step.button.execute'),
	            scale: 'large',
	            iconCls: 'dvnt-icon-right',
	            iconAlign: 'right',
	            handler: this.onExecuteClick,
	            scope: this,
	          },
	        ],
	      },
	    ];
	    this.callParent(arguments);
	  },
	
	  activated: function () {
	    var summaryGrid = this.down('#wizard-summary-grid');
	    summaryGrid.prepare({
	      data: this.getData('selectedItems', true),
	      columnsConfig: this.getData('columnsConfig', true),
	    });
	  },
	  onExecuteClick: function () {
	    this.wizard.hideContainerToolbar();
	    this.down('#execute-button').disable();
	    var config = this.getAllData();
	    Ext.Ajax.request({
	      scope: this,
	      url: Wizards.pluginContextPath + '/wizard/' + Wizards.name + '/execute',
	      params: {
	        section: Wizards.section,
	        menuEntryKey: Wizards.menuEntryKey,
	        searchId: Wizards.searchContext.searchId,
	      },
	      jsonData: config,
	      success: function (response, options) {
	        this.checkExecutionStatus(response.responseText, 5);
	      },
	      failure: function (response, options) {
	        this.showMessages({
	          text: Wizards.baseT('base.summary.step.error.execution'),
	          type: 'failure',
	        });
	      },
	    });
	  },
	  checkExecutionStatus: function (key, attempts) {
	    Ext.Ajax.request({
	      scope: this,
	      url: Wizards.pluginContextPath + '/wizard/execution/status/' + key,
	      success: function (response, options) {
	        var status = Ext.JSON.decode(response.responseText);
	        this.clearMessages();
	        this.updateStatus(status.executionState);
	        if (!status.finished) {
	          var me = this;
	          setTimeout(function () {
	            me.checkExecutionStatus(key, attempts);
	          }, 1000);
	        } else {
	          this.finishExecution();
	        }
	      },
	      failure: function (response, options) {
	        if (attempts > 0) {
	          this.checkExecutionStatus(key, --attempts);
	          this.showMessages({
	            text: Wizards.baseT('base.summary.step.warning.checkstatus', attempts),
	            type: 'warning',
	          });
	        } else {
	          this.showMessages({
	            text: Wizards.baseT('base.summary.step.error.checkstatus'),
	            type: 'failure',
	          });
	        }
	      },
	      timeout: 10000,
	    });
	  },
	  updateStatus: function (status) {
	    var summaryGrid = this.down('#wizard-summary-grid');
	    var range = summaryGrid.getStore().getRange();
	    Ext.suspendLayouts();
	    Ext.each(
	      range,
	      function (item) {
	        var id = item.get('id');
	        item.set(summaryGrid.statusColumnDataIndex, status[id]);
	      },
	      this
	    );
	    Ext.resumeLayouts();
	  },
	  finishExecution: function () {
	    var messageBox = this.down('#wizard-result-box');
	    messageBox.add({
	      xtype: 'wizard-message-box',
	      text: Wizards.baseT('base.summary.step.finished'),
	      type: 'success',
	    });
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var summaryStore = __webpack_require__(20);
	
	module.exports = Ext.define('Wizards.components.summary.SummaryGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-summary-grid',
	  store: summaryStore,
	  columns: [],
	  viewConfig: {
	    enableTextSelection: true,
	  },
	  statusColumnDataIndex: 'status',
	
	  prepare: function (config) {
	    this.reconfigure(this.store, this.withStatusCell(config.columnsConfig.columns));
	    this.store.loadData(this.copy(config.data));
	  },
	  withStatusCell: function (columnsConfig) {
	    var result = Ext.Array.clone(columnsConfig);
	    this.setUniqueStatusColumnDataIndex(result);
	    var statusColumn = {
	      header: 'Status',
	      dataIndex: this.statusColumnDataIndex,
	      locked: true,
	      flex: 1,
	      scope: this,
	      renderer: function (status) {
	        return this.renderStatus(status);
	      },
	    };
	    result.unshift(statusColumn);
	    return result;
	  },
	  renderStatus: function (status) {
	    var result = '';
	    if (status) {
	      result = this.addColumnIcon(status.status);
	      result += Wizards.baseT(status.status);
	      if (status.message) {
	        result += ' (' + status.message + ')';
	      }
	    }
	    return result;
	  },
	  addColumnIcon: function (status) {
	    if (status == 'INPROGRESS') {
	      return '<span style="float:right"><img src="../../../pages/images/indicator_medium.gif" style="height: 16px"/></span></span>';
	    } else if (status == 'EXECUTED') {
	      return this.getColumnIconElement('dvnt-icon-check-circle dvnt-green-icon');
	    } else if (status == 'FAILED') {
	      return this.getColumnIconElement('dvnt-icon-exclamation-circle dvnt-red-icon');
	    } else if (status == 'SKIPPED') {
	      return this.getColumnIconElement('dvnt-icon-exclamation-triangle dvnt-orange-icon');
	    } else {
	      return '';
	    }
	  },
	  getColumnIconElement: function (cls) {
	    return '<span class="' + cls + '" style="float:right; height: 16px; width: 16px; display: block;"></span>';
	  },
	  copy: function (data) {
	    var result = [];
	
	    Ext.each(data, function (item) {
	      result.push(item.copy());
	    });
	
	    return result;
	  },
	
	  setUniqueStatusColumnDataIndex: function (columnsConfig) {
	    let index = 1;
	    let originalStatusColumnDataIndex = this.statusColumnDataIndex;
	
	    while (!this.checkIfStatusColumnDataIndexIsUnique(columnsConfig)) {
	      this.statusColumnDataIndex = originalStatusColumnDataIndex + index;
	      index++;
	    }
	  },
	
	  checkIfStatusColumnDataIndexIsUnique: function (columnsConfig) {
	    for (let i = 0; i < columnsConfig.length; i++) {
	      if (columnsConfig[i].dataIndex === this.statusColumnDataIndex) {
	        return false;
	      }
	    }
	    return true;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.ArrayStore', {
	  storeId: 'summarystore',
	  autoLoad: false,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {/**
	 * Component displays box with message.
	 * There are 3 type of message:
	 * <ol>
	 *  <li>success</li>
	 *  <li>failure</li>
	 *  <li>warning</li>
	 * </ol>
	 * To display warning message use:
	 * {
	 *  xtype: 'wizard-message-box',
	 *  text: 'Warning text',
	 *  type: 'warning'
	 * }
	 *
	 * @class Wizards.components.MessageBox
	 */
	module.exports = Ext.define('Wizards.components.MessageBox', {
	  extend: 'Ext.container.Container',
	  xtype: 'wizard-message-box',
	
	  autoEl: {
	    tag: 'div',
	    cls: 'wizard-message-box',
	  },
	
	  initComponent: function () {
	    this.on(
	      'afterrender',
	      function () {
	        this.showMessage();
	      },
	      this
	    );
	
	    this.callParent(arguments);
	  },
	
	  showMessage: function () {
	    this.setBoxType(this.type || 'warning');
	    this.setText(this.text);
	  },
	
	  setText: function (text) {
	    this.getEl().setHTML(text);
	  },
	
	  setBoxType: function (type) {
	    var element = this.getEl();
	    if (type.toLowerCase() == 'warning') {
	      element.addCls('wizard-warning');
	    } else if (type.toLowerCase() == 'failure') {
	      element.addCls('wizard-failure');
	    } else if (type.toLowerCase() == 'success') {
	      element.addCls('wizard-success');
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.components.CommentField', {
	  extend: 'Ext.form.field.TextArea',
	  xtype: 'wizard-comment-field',
	
	  itemId: 'comment',
	  wizardProperty: 'comment',
	  value: '',
	  grow: true,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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