/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.util;

import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.wizards.util.ActivityContextDto;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ActivityContextUtil {
    public static ActivityContextDto prepareActivityContext(SharkTransaction st, String processId, String activityId, Map<String, Object> activityContext) {
        try {
            ProcessService processService = (ProcessService)SpringContext.getBean(ProcessService.class);
            Map newProcessContext = processService.getProcessContext(processId);
            Map newActivityContext = processService.getProcessContext(processId);
            Set<String> editableVariables = ActivityContextUtil.getEditableVariables(st, processId, activityId);
            Set<String> formalParameters = ActivityContextUtil.getFormalParameters(st, processId);
            activityContext.entrySet().stream().filter(entry -> editableVariables.contains(entry.getKey()) && newProcessContext.containsKey(entry.getKey()) && newActivityContext.containsKey(entry.getKey())).forEach(entry -> {
                newProcessContext.put((String)entry.getKey(), entry.getValue());
                newActivityContext.put((String)entry.getKey(), entry.getValue());
            });
            activityContext.entrySet().stream().filter(entry -> formalParameters.contains(entry.getKey()) && newActivityContext.containsKey(entry.getKey())).forEach(entry -> newActivityContext.put((String)entry.getKey(), entry.getValue()));
            Set<String> validVariables = ActivityContextUtil.getValidVariablesId(st, processId);
            newProcessContext.keySet().retainAll(validVariables);
            newActivityContext.keySet().retainAll(validVariables);
            return new ActivityContextDto(newProcessContext, newActivityContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Nie uda\u0142o si\u0119 przygotowa\u0107 kontekstu zadania [" + activityId + "] z procesu [" + processId + "]", e);
        }
    }

    private static Set<String> getEditableVariables(SharkTransaction st, String processId, String activityId) throws BaseException {
        String[][] extAttributes;
        HashSet<String> editableVariables = new HashSet<String>();
        block9: for (String[] extAttr : extAttributes = Shark.getInstance().getAdminInterface().getAdminMisc().getActivitiesExtendedAttributeNameValuePairs(st, processId, activityId)) {
            switch (extAttr[0]) {
                case "VariableToProcess_UPDATE": 
                case "VariableToProcess_HIDDEN": {
                    editableVariables.add(extAttr[1]);
                    continue block9;
                }
                case "VARIABLE_SET": {
                    Set variablesInSet = Arrays.stream(extAttr[1].split("\n", -1)).filter(value -> !value.startsWith("DT_")).collect(Collectors.toSet());
                    editableVariables.addAll(variablesInSet);
                }
            }
        }
        return editableVariables;
    }

    private static Set<String> getFormalParameters(SharkTransaction st, String processId) throws BaseException, ConnectFailed, NotConnected {
        String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)st, (String)processId);
        WorkflowProcess workflowProcess = XpdlPackageManager.getInstance().getPackageByProcessId(st, processId).getWorkflowProcess(processDefId);
        ArrayList formalParameters = workflowProcess.getFormalParameters().toElements();
        return formalParameters.stream().filter(formalParam -> !formalParam.getMode().equals("IN")).map(XMLCollectionElement::getId).collect(Collectors.toSet());
    }

    private static Set<String> getValidVariablesId(SharkTransaction st, String processId) throws ConnectFailed, BaseException, NotConnected {
        String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)st, (String)processId);
        WorkflowProcess workflowProcess = XpdlPackageManager.getInstance().getPackageByProcessId(st, processId).getWorkflowProcess(processDefId);
        HashSet<String> variablesId = new HashSet<String>();
        ArrayList dataFields = workflowProcess.getDataFields().toElements();
        dataFields.stream().map(XMLCollectionElement::getId).forEach(variablesId::add);
        ArrayList formalParameters = workflowProcess.getFormalParameters().toElements();
        formalParameters.stream().map(XMLCollectionElement::getId).forEach(variablesId::add);
        return variablesId;
    }
}

