/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.support;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.plusmpm.util.Authorization;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRightCache {
    private static final Logger logger = LoggerFactory.getLogger(AdminRightCache.class);
    private static final LoadingCache<String, Integer> rightsCache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Integer>(){

        public Integer load(String username) throws Exception {
            return Authorization.checkRight((String)"System.Admin", (String)username, (boolean)false, (boolean)false);
        }
    });

    public static boolean hasAdminRight(String username) {
        try {
            return (Integer)rightsCache.get((Object)username) == 0;
        }
        catch (ExecutionException e) {
            logger.error("Can not read rights for user {}", (Object)username, (Object)e);
            return false;
        }
    }
}

