/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.modules;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardImplementation;
import com.suncode.plugin.wizards.WizardsRegistry;
import jakarta.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;

public class WizardRegisterModule
extends ModuleSupport<Void> {
    private String name;
    private String path;
    private LocalizedMessage label;
    private String implementation;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private WizardsRegistry wizardsRegistry;

    protected void initModule() throws PluginsException {
        this.name = this.getDefinition().getElement().getAttribute("name");
        this.path = this.getDefinition().getElement().getAttribute("script");
        this.label = ModuleHelper.getLocalizedMessage((String)"label", (Plugin)this.getPlugin(), (ModuleDefinition)this.getDefinition());
        this.implementation = this.getDefinition().getElement().getAttribute("implementation");
        this.path = this.servletContext.getContextPath() + "/plugin/" + this.getPlugin().getKey() + "/resources/" + this.path;
    }

    public void enable() throws PluginsException {
        try {
            Class<?> clazz = this.getPlugin().getClassLoader().loadClass(this.implementation);
            if (!WizardImplementation.class.isAssignableFrom(clazz)) {
                throw new PluginsException("Class " + this.implementation + " must implement " + WizardImplementation.class.getName() + " interface");
            }
            WizardImplementation impl = (WizardImplementation)this.getPlugin().getContext().getAutowireCapableBeanFactory().createBean(clazz);
            this.wizardsRegistry.register(new Wizard(this.getPlugin(), this.name, this.label, this.path, impl));
        }
        catch (ClassNotFoundException e) {
            throw new PluginsException("Can't load class: " + this.implementation, (Throwable)e);
        }
        catch (Exception e) {
            throw new PluginsException("Error while starting plugin: " + this.getPlugin().getName(), (Throwable)e);
        }
    }

    public void disable() throws PluginsException {
        this.wizardsRegistry.unregister(this.name);
    }
}

