/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.execution.state;

import com.suncode.plugin.wizards.execution.state.ExecutionState;
import org.springframework.util.Assert;

public class TaskExecutionState {
    private ExecutionState.ExecutionStatus status = ExecutionState.ExecutionStatus.WAITING;
    private String message;
    private int progress = 0;

    public void setStatus(ExecutionState.ExecutionStatus status) {
        this.status = status;
    }

    public ExecutionState.ExecutionStatus getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        Assert.state((progress >= 0 ? 1 : 0) != 0, (String)"[Assertion failed] - this state invariant must be true");
        Assert.state((progress <= 100 ? 1 : 0) != 0, (String)"[Assertion failed] - this state invariant must be true");
        this.progress = progress;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TaskExecutionStatus {
        EXECUTED{

            @Override
            public ExecutionState.ExecutionStatus asExecutionStatus() {
                return ExecutionState.ExecutionStatus.EXECUTED;
            }
        }
        ,
        FAILED{

            @Override
            public ExecutionState.ExecutionStatus asExecutionStatus() {
                return ExecutionState.ExecutionStatus.FAILED;
            }
        }
        ,
        SKIPPED{

            @Override
            public ExecutionState.ExecutionStatus asExecutionStatus() {
                return ExecutionState.ExecutionStatus.SKIPPED;
            }
        };


        public abstract ExecutionState.ExecutionStatus asExecutionStatus();
    }
}

