/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.execution.state;

import com.suncode.plugin.wizards.execution.state.TaskExecutionState;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExecutionState {
    private String key;
    private boolean finished = false;
    private ConcurrentMap<String, TaskExecutionState> executionState = new ConcurrentHashMap<String, TaskExecutionState>();

    public ExecutionState(String key, List<? extends WizardTask> tasks) {
        this.key = key;
        for (WizardTask wizardTask : tasks) {
            this.executionState.put(wizardTask.getTaskId(), new TaskExecutionState());
        }
    }

    public TaskExecutionState getExecutionState(Object itemId) {
        return (TaskExecutionState)this.executionState.get(itemId);
    }

    public ConcurrentMap<String, TaskExecutionState> getExecutionState() {
        return this.executionState;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void finished(boolean finished) {
        this.finished = finished;
    }

    public static enum ExecutionStatus {
        WAITING,
        INPROGRESS,
        EXECUTED,
        FAILED,
        SKIPPED;

    }
}

