/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.execution;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.execution.state.ExecutionState;
import com.suncode.plugin.wizards.execution.state.SimpleTaskExecutionState;
import com.suncode.plugin.wizards.execution.state.TaskExecutionState;
import com.suncode.plugin.wizards.execution.task.TaskContext;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class WizardExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WizardExecutor.class);
    @Autowired
    private Plugin plugin;

    @Async
    public void executeTasks(List<? extends WizardTask> tasks, ExecutionState executionState, TaskContext taskContext) {
        logger.debug("Starting execution of tasks");
        for (WizardTask wizardTask : tasks) {
            logger.debug("Executing task [{}]", (Object)wizardTask.getTaskId());
            Date started = new Date();
            TaskExecutionState state = executionState.getExecutionState(wizardTask.getTaskId());
            state.setStatus(ExecutionState.ExecutionStatus.INPROGRESS);
            try {
                TaskExecutionState.TaskExecutionStatus taskStatus = wizardTask.execute(new SimpleTaskExecutionState(state), taskContext);
                state.setStatus(taskStatus.asExecutionStatus());
                logger.debug("Executed task [{}] with status [{}]", (Object)wizardTask.getTaskId(), (Object)taskStatus);
            }
            catch (Exception e) {
                this.handleError(wizardTask, state, e);
            }
            catch (Error err) {
                this.handleError(wizardTask, state, err);
                throw err;
            }
            finally {
                this.audit(taskContext, wizardTask, started, state);
            }
        }
        executionState.finished(true);
        logger.debug("Finished execution of tasks");
    }

    private void audit(TaskContext taskContext, WizardTask task, Date started, TaskExecutionState state) {
        ManualAuditBuilder.getInstance().type(taskContext.getTaskName()).username(taskContext.getLoggedUsername()).success(!state.getStatus().equals((Object)ExecutionState.ExecutionStatus.FAILED)).started(started).params(task.getAuditTaskParams()).build().log();
    }

    private void handleError(WizardTask task, TaskExecutionState state, Throwable th) {
        logger.error("Error during task execution [{}]", (Object)task.getTaskId(), (Object)th);
        state.setStatus(ExecutionState.ExecutionStatus.FAILED);
        state.setMessage(this.plugin.getMessage("base.execution.error"));
    }
}

