/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.components.selectprocess;

import com.plusmpm.struts.action.ShowProcessHistoryAction;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.AdvanceSearchResult;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.plugin.wizards.components.selectprocess.Filter;
import com.suncode.plugin.wizards.components.support.Column;
import com.suncode.plugin.wizards.components.support.Data;
import com.suncode.plugin.wizards.components.support.DataItem;
import com.suncode.plugin.wizards.components.support.Field;
import com.suncode.plugin.wizards.components.support.GridData;
import com.suncode.plugin.wizards.components.support.MessageType;
import com.suncode.plugin.wizards.components.support.MetaData;
import com.suncode.plugin.wizards.components.support.StoreMetaData;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.ui.section.SectionHolder;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.search.ActivitySearchQuery;
import com.suncode.pwfl.workflow.search.ProcessSearchQuery;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/components/selectprocess"})
public class SelectProcessController {
    private static final Logger log = LoggerFactory.getLogger(SelectProcessController.class);
    private static final int MAX_PROCESSES_NUMBER = 1000;
    @Autowired
    private SectionHolder sectionHolder;
    @Autowired
    private Plugin plugin;
    @Autowired
    private SearchFormCache searchFormCache;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public StoreMetaData getSearchedProcesses(@RequestParam String section, @RequestParam(value="filter", defaultValue="closed") String filter, @RequestParam String searchId) {
        MetaData metaData = new MetaData();
        metaData.setIdProperty("id");
        metaData.setTotalProperty("total");
        metaData.setSuccessProperty("success");
        metaData.setRoot("data");
        StoreMetaData storeMetaData = new StoreMetaData();
        storeMetaData.setMetaData(metaData);
        try {
            Section sourceSection = this.sectionHolder.get(section, searchId);
            Assert.notNull((Object)sourceSection, (String)"Source section can not be null");
            this.sectionHolder.save(sourceSection, searchId);
            GridData result = null;
            if (sourceSection instanceof SearchResultActionSection) {
                ProcessSearchQuery query;
                SearchResultActionSection search = (SearchResultActionSection)sourceSection;
                Optional searchVariables = this.searchFormCache.getSearchVariablesFromCache(searchId);
                if (searchVariables.isPresent()) {
                    ActivitySearchQuery givenQuery = search.getSearchType() == SearchResultActionSection.SearchType.ACTIVITY ? search.getActivitySearchQuery() : search.getProcessSearchQuery();
                    String sortBy = givenQuery.getExternalSortProperty();
                    SortDirection sortDirection = givenQuery.getExternalSortDirection();
                    query = new ProcessSearchQuery(SessionUtils.getLoggedUserName(), (AdvanceVariableForm[])searchVariables.get(), sortBy, sortDirection);
                } else {
                    query = search.getSearchType() == SearchResultActionSection.SearchType.ACTIVITY ? new ProcessSearchQuery(SessionUtils.getLoggedUserName(), search.getActivitySearchQuery().getSearchVariables()) : search.getProcessSearchQuery();
                }
                boolean noResults = false;
                if (filter.equalsIgnoreCase(Filter.CLOSED.name())) {
                    if (this.hasEmptyCondition(query, ProcessSearchQuery.ProcessField.STATE)) {
                        query.where(ProcessSearchQuery.ProcessField.STATE, "closed.completed;closed.aborted");
                        metaData.addMessage(this.plugin.getMessage("selectprocess.controller.querylimit.closed"), MessageType.WARNING);
                    } else if (this.hasValidClosedState(query)) {
                        query.where(ProcessSearchQuery.ProcessField.STATE, this.getValidClosedStates(query));
                        metaData.addMessage(this.plugin.getMessage("selectprocess.controller.querylimit.closed"), MessageType.WARNING);
                    } else {
                        noResults = true;
                    }
                }
                query.select(new ProcessSearchQuery.ProcessField[]{ProcessSearchQuery.ProcessField.NAME, ProcessSearchQuery.ProcessField.TYPE, ProcessSearchQuery.ProcessField.STATE});
                List results = noResults ? null : query.queryFirst(1000, search.getViewId());
                List list = results = results == null ? new ArrayList() : results;
                if (search.count() > 1000) {
                    metaData.addMessage(this.plugin.getMessage("selectprocess.controller.querylimit.count", new Object[]{1000}), MessageType.WARNING);
                }
                result = this.convert(query, results);
            } else if (sourceSection instanceof ShowProcessHistoryAction.ProcessHistoryActionSection) {
                ShowProcessHistoryAction.ProcessHistoryActionSection history = (ShowProcessHistoryAction.ProcessHistoryActionSection)sourceSection;
                result = this.convert(history);
            }
            metaData.setFields(result.getFields());
            metaData.setColumns(result.getColumns());
            storeMetaData.setData(this.getData(result.getData()));
            storeMetaData.setSuccess(true);
        }
        catch (Exception e) {
            log.error("Exception while getting processes for section: {}", (Object)section, (Object)e);
            metaData.addMessage(this.plugin.getMessage("selectprocess.controller.getingprocesses.error"), MessageType.FAILURE);
            storeMetaData.setSuccess(false);
        }
        return storeMetaData;
    }

    public boolean hasEmptyCondition(ProcessSearchQuery query, ProcessSearchQuery.ProcessField field) {
        return query.hasCondition(field, "");
    }

    public boolean hasValidClosedState(ProcessSearchQuery query) {
        return query.containsCondition(ProcessSearchQuery.ProcessField.STATE, "closed.completed") || query.containsCondition(ProcessSearchQuery.ProcessField.STATE, "closed.aborted");
    }

    private String getValidClosedStates(ProcessSearchQuery query) {
        String states = Arrays.stream(query.getSearchVariables()).filter(variable -> variable.getName().equals(ProcessSearchQuery.ProcessField.STATE.getMapping())).map(variable -> variable.getValue()).findFirst().get();
        return Arrays.stream(states.split(";")).filter(state -> state.equals("closed.completed") || state.equals("closed.aborted")).collect(Collectors.joining(";"));
    }

    private GridData convert(ShowProcessHistoryAction.ProcessHistoryActionSection history) {
        GridData result = new GridData();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<Data> data = new ArrayList<Data>();
        fields.add(this.getField(ProcessSearchQuery.ProcessField.TYPE.getMapping()));
        columns.add(this.getColumn(ProcessSearchQuery.ProcessField.TYPE.getMapping(), this.plugin.getMessage("selectprocess.controller.column.procdef.header")));
        fields.add(this.getField(ProcessSearchQuery.ProcessField.NAME.getMapping()));
        columns.add(this.getColumn(ProcessSearchQuery.ProcessField.NAME.getMapping(), this.plugin.getMessage("selectprocess.controller.column.proc.header")));
        Data resultData = new Data();
        ArrayList<DataItem> items = new ArrayList<DataItem>();
        items.add(new DataItem("id", history.getProcessId()));
        items.add(new DataItem("processDefinitionId", history.getProcessType()));
        items.add(new DataItem(ProcessSearchQuery.ProcessField.TYPE.getMapping(), history.getProcessType()));
        items.add(new DataItem(ProcessSearchQuery.ProcessField.NAME.getMapping(), history.getProcessName()));
        resultData.setDataItems(items);
        data.add(resultData);
        result.setFields(fields);
        result.setColumns(columns);
        result.setData(data);
        return result;
    }

    private Field getField(String fieldName) {
        Field field = new Field();
        field.setName(fieldName);
        field.setType("string");
        return field;
    }

    private Column getColumn(String dataIndex, String header) {
        Column column = new Column();
        column.setHeader(header);
        column.setDataIndex(dataIndex);
        column.setSortable(true);
        return column;
    }

    private GridData convert(ProcessSearchQuery query, List<AdvanceSearchResult> results) {
        GridData result = new GridData();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<Data> data = new ArrayList<Data>();
        for (AdvanceVariableForm searchVariable : query.getSearchVariables()) {
            if (searchVariable == null || searchVariable.getActive() == null) continue;
            Field field = new Field();
            field.setName(searchVariable.getName());
            field.setType("string");
            fields.add(field);
            Column column = new Column();
            column.setHeader(searchVariable.getViewname());
            column.setDataIndex(searchVariable.getName());
            column.setSortable(true);
            columns.add(column);
        }
        for (AdvanceSearchResult searchResult : results) {
            Data resultData = new Data();
            ArrayList<DataItem> items = new ArrayList<DataItem>();
            items.add(new DataItem("id", searchResult.getProcessId()));
            items.add(new DataItem("processDefinitionId", searchResult.getProcessDefinitionId()));
            for (AdvanceSearchResult.AdvanceVariable variable : searchResult.getAlVariables()) {
                String name = variable.getName();
                String value = variable.getDisplayValue();
                DataItem dataItem = new DataItem(name, value);
                items.add(dataItem);
            }
            resultData.setDataItems(items);
            data.add(resultData);
        }
        result.setFields(fields);
        result.setColumns(columns);
        result.setData(data);
        return result;
    }

    private List<Map<String, String>> getData(List<Data> dataList) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Data data : dataList) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (DataItem item : data.getDataItems()) {
                dataMap.put(item.getName(), item.getValue());
            }
            result.add(dataMap);
        }
        return result;
    }
}

