/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Multimap;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardsRegistry;
import com.suncode.plugin.wizards.exception.UnauthorizedWizardAccessException;
import com.suncode.plugin.wizards.execution.WizardExecutionRegistry;
import com.suncode.plugin.wizards.execution.WizardExecutor;
import com.suncode.plugin.wizards.execution.config.WizardConfig;
import com.suncode.plugin.wizards.execution.config.WizardMenu;
import com.suncode.plugin.wizards.execution.state.ExecutionState;
import com.suncode.plugin.wizards.execution.task.TaskContext;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import com.suncode.pwfl.web.ui.section.SectionHolder;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WizardController {
    private static final String KEY_PREFIX = "com.suncode.plugin-wizards-base:menu";
    @Autowired
    private SectionHolder sectionHolder;
    @Autowired
    private WizardsRegistry wizardsRegistry;
    @Autowired
    private WizardExecutor wizardExecutor;
    @Autowired
    private WizardExecutionRegistry wizardExecutionRegistry;

    @RequestMapping(value={"/wizards/{name}"})
    public String runWizard(@PathVariable String name, @RequestParam String section, @RequestParam String menuEntryKey, @RequestParam String searchId, Model model) {
        Wizard<?, ?> wizard = this.wizardsRegistry.getWizard(name);
        Assert.state((wizard != null ? 1 : 0) != 0, (String)("Wizard does not exist name: " + name));
        this.assertWizardAccess(wizard, section, menuEntryKey, searchId);
        model.addAttribute("script", (Object)wizard.getPath());
        model.addAttribute("name", (Object)name);
        model.addAttribute("section", (Object)section);
        model.addAttribute("menuEntryKey", (Object)menuEntryKey);
        model.addAttribute("pluginKey", (Object)wizard.getPlugin().getKey());
        model.addAttribute("searchType", (Object)this.getSearchType(searchId, section));
        return "wizard";
    }

    @ResponseBody
    @RequestMapping(value={"/wizard/{name}/execute"})
    public String callWizardExecution(@PathVariable String name, @RequestParam String section, @RequestParam String menuEntryKey, @RequestParam String searchId, @RequestBody String data) throws JsonParseException, JsonMappingException, IOException {
        Wizard<?, ?> wizard = this.wizardsRegistry.getWizard(name);
        Assert.state((wizard != null ? 1 : 0) != 0, (String)("Wizard does not exist name: " + name));
        this.assertWizardAccess(wizard, section, menuEntryKey, searchId);
        List<?> tasks = wizard.createTasks(data);
        ExecutionState executeState = this.wizardExecutionRegistry.register(tasks);
        TaskContext taskContext = new TaskContext(name, LocaleContextHolder.getLocale(), SessionUtils.getLoggedUserName());
        this.wizardExecutor.executeTasks(tasks, executeState, taskContext);
        this.sectionHolder.get(section, searchId);
        return executeState.getKey();
    }

    @ResponseBody
    @RequestMapping(value={"/wizard/execution/status/{key}"})
    public ExecutionState getExecutionStatus(@PathVariable String key) {
        return this.wizardExecutionRegistry.get(key);
    }

    private String getSearchType(String searchId, String section) {
        Section sourceSection = this.sectionHolder.get(section, searchId);
        if (sourceSection != null) {
            this.sectionHolder.save(sourceSection, searchId);
        }
        if (sourceSection instanceof SearchResultActionSection) {
            SearchResultActionSection searchResultActionSection = (SearchResultActionSection)sourceSection;
            return searchResultActionSection.getSearchType().name();
        }
        return "";
    }

    private <C extends WizardConfig<?, ?>, T extends WizardTask> void assertWizardAccess(Wizard<C, T> wizard, String requestedSectionKey, String menuEntryKey, String searchId) {
        WizardMenu menu = new WizardMenu(wizard.getPlugin(), wizard, "com.suncode.plugin-wizards-base:menu-" + wizard.getName());
        wizard.getImplementation().createMenus(wizard, menu);
        Multimap<String, MenuEntry> menuEntries = menu.build();
        MenuEntry menuEntry = menuEntries.entries().stream().filter(entry -> ((String)entry.getKey()).equals(requestedSectionKey)).filter(entry -> ((MenuEntry)entry.getValue()).getKey().equals(menuEntryKey)).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new UnauthorizedWizardAccessException(String.format("Requested section \"%s\" with entry key \"%s\" does not exists", requestedSectionKey, menuEntryKey)));
        Section section = this.sectionHolder.get(requestedSectionKey, searchId);
        Assert.notNull((Object)section, (String)"Source section can not be null");
        this.sectionHolder.save(section, searchId);
        if (!menuEntry.meetsCondition(section)) {
            throw new UnauthorizedWizardAccessException(String.format("Conditions for requested section \"%s\" with entry key \"%s\" are not met", requestedSectionKey, menuEntryKey));
        }
    }

    @ExceptionHandler(value={UnauthorizedWizardAccessException.class})
    public ResponseEntity<?> handleUnauthorizedAccess(UnauthorizedWizardAccessException e) {
        return new ResponseEntity((Object)new Response(e.getMessage()), (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    public static class Response {
        private String message;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Response(String message) {
            this.message = message;
        }
    }
}

