/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.wizards.WizardImplementation;
import com.suncode.plugin.wizards.execution.config.WizardConfig;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class Wizard<C extends WizardConfig<?, ?>, T extends WizardTask> {
    private static final String WIZARD_NAME_PATTERN = "[a-zA-Z0-9]+";
    private final Plugin plugin;
    private final String name;
    private final LocalizedMessage label;
    private final String path;
    private final WizardImplementation<C, T> implementation;

    public Wizard(Plugin plugin, String name, LocalizedMessage label, String path, WizardImplementation<C, T> implementation) {
        Assert.state((boolean)Pattern.matches(WIZARD_NAME_PATTERN, name), (String)"Wizard's name must match to pattern: [a-zA-Z0-9]+");
        this.plugin = plugin;
        this.name = name;
        this.label = label;
        this.path = path;
        this.implementation = implementation;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getName() {
        return this.name;
    }

    public LocalizedMessage getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    public WizardImplementation<C, T> getImplementation() {
        return this.implementation;
    }

    public List<T> createTasks(String data) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        WizardImplementation<WizardConfig, T> wizardImpl = this.getImplementation();
        WizardConfig config = (WizardConfig)mapper.readValue(data, wizardImpl.configClass());
        return wizardImpl.createTasks(config);
    }
}

