/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.execution.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.plugin.framework.web.support.ScopedWebLink;
import com.suncode.plugin.framework.web.support.WebLink;
import com.suncode.plugin.wizards.Wizard;
import java.util.List;
import org.springframework.util.Assert;

public class WizardMenu {
    private final Plugin plugin;
    private final String keyPrefix;
    private final Wizard<?, ?> wizard;
    private String currentSection;
    private Multimap<String, MenuEntry> entries = ArrayListMultimap.create();

    public WizardMenu(Plugin plugin, Wizard<?, ?> wizard, String keyPrefix) {
        this.plugin = plugin;
        this.wizard = wizard;
        this.keyPrefix = keyPrefix;
    }

    public WizardMenu section(String section) {
        this.currentSection = section;
        return this;
    }

    public WizardMenu add(String key, LocalizedMessage label, Condition ... condition) {
        Assert.state((this.currentSection != null ? 1 : 0) != 0, (String)"No current section specified. Call section() first!");
        String fullMenuEntryKey = this.keyPrefix + "-" + key;
        ScopedWebLink link = new ScopedWebLink(this.plugin, "/wizards/" + this.wizard.getName() + "?section=" + this.currentSection + "&menuEntryKey=" + fullMenuEntryKey);
        MenuEntry entry = new MenuEntry(fullMenuEntryKey, (WebLink)link, label, 10, (List)Lists.newArrayList((Object[])condition));
        this.entries.put((Object)this.currentSection, (Object)entry);
        return this;
    }

    public Multimap<String, MenuEntry> build() {
        return this.entries;
    }
}

