/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.execution;

import com.suncode.plugin.wizards.execution.state.ExecutionState;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class WizardExecutionRegistry {
    private final long interval = 60000L;
    private long lastReadTime = System.currentTimeMillis();
    private ConcurrentMap<String, ExecutionState> registry = new ConcurrentHashMap<String, ExecutionState>();

    public ExecutionState register(List<? extends WizardTask> tasks) {
        String key = UUID.randomUUID().toString();
        ExecutionState executionState = new ExecutionState(key, tasks);
        this.registry.put(key, executionState);
        return executionState;
    }

    public ExecutionState get(String key) {
        ExecutionState state = (ExecutionState)this.registry.get(key);
        this.registryCleanUp();
        return state;
    }

    private void registryCleanUp() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastReadTime > 60000L) {
            this.lastReadTime = currentTime;
            Iterator iter = this.registry.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!((ExecutionState)entry.getValue()).isFinished()) continue;
                iter.remove();
            }
        }
    }
}

