/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.components.selectactivity;

import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.AdvanceSearchResult;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.plugin.wizards.components.support.Column;
import com.suncode.plugin.wizards.components.support.Data;
import com.suncode.plugin.wizards.components.support.DataItem;
import com.suncode.plugin.wizards.components.support.Field;
import com.suncode.plugin.wizards.components.support.GridData;
import com.suncode.plugin.wizards.components.support.MessageType;
import com.suncode.plugin.wizards.components.support.MetaData;
import com.suncode.plugin.wizards.components.support.StoreMetaData;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.ui.section.SectionHolder;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.search.ActivitySearchQuery;
import com.suncode.pwfl.workflow.search.ProcessSearchQuery;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/components/selectactivity"})
public class SelectActivityController {
    private static final Logger log = LoggerFactory.getLogger(SelectActivityController.class);
    private static final int MAX_ACTIVITIES_NUMBER = 100;
    @Autowired
    private SectionHolder sectionHolder;
    @Autowired
    private Plugin plugin;
    @Autowired
    private SearchFormCache searchFormCache;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public StoreMetaData getSearchedActivities(@RequestParam String section, @RequestParam String searchId) {
        MetaData metaData = new MetaData();
        metaData.setIdProperty("id");
        metaData.setTotalProperty("total");
        metaData.setSuccessProperty("success");
        metaData.setRoot("data");
        StoreMetaData storeMetaData = new StoreMetaData();
        storeMetaData.setMetaData(metaData);
        try {
            List results;
            ActivitySearchQuery query;
            Section sourceSection = this.sectionHolder.get(section, searchId);
            Assert.notNull((Object)sourceSection, (String)"Source section can not be null");
            this.sectionHolder.save(sourceSection, searchId);
            GridData result = null;
            if (sourceSection instanceof SearchResultActionSection) {
                SearchResultActionSection search = (SearchResultActionSection)sourceSection;
                Optional searchVariables = this.searchFormCache.getSearchVariablesFromCache(searchId);
                query = searchVariables.map(searchCriteria -> {
                    String sortBy = search.getActivitySearchQuery().getExternalSortProperty();
                    SortDirection sortDirection = search.getActivitySearchQuery().getExternalSortDirection();
                    return new ActivitySearchQuery(SessionUtils.getLoggedUserName(), searchCriteria, sortBy, sortDirection);
                }).orElseGet(() -> ((SearchResultActionSection)search).getActivitySearchQuery());
                query.select(new ProcessSearchQuery.ProcessField[]{ProcessSearchQuery.ProcessField.NAME, ProcessSearchQuery.ProcessField.TYPE});
                query.select(new ActivitySearchQuery.ActivityField[]{ActivitySearchQuery.ActivityField.NAME, ActivitySearchQuery.ActivityField.USER, ActivitySearchQuery.ActivityField.STATE});
                if (!(query.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open.running") || query.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open.not_running.not_started") || query.hasCondition(ActivitySearchQuery.ActivityField.STATE, "open.not_running.suspended"))) {
                    query.where(ActivitySearchQuery.ActivityField.STATE, "open%");
                }
                List list = results = (results = query.queryFirst(100, search.getViewId())) == null ? new ArrayList() : results;
                if (search.count() > 100) {
                    metaData.addMessage(this.plugin.getMessage("selectactivity.controller.querylimit.count", new Object[]{100}), MessageType.WARNING);
                }
            } else {
                throw new IllegalArgumentException("Unknown section: " + section);
            }
            result = this.convert((ProcessSearchQuery)query, results);
            metaData.setFields(result.getFields());
            metaData.setColumns(result.getColumns());
            storeMetaData.setData(this.getData(result.getData()));
            storeMetaData.setSuccess(true);
        }
        catch (Exception e) {
            log.error("Exception while getting activities for section: {}", (Object)section, (Object)e);
            metaData.addMessage(this.plugin.getMessage("selectprocess.controller.getingprocesses.error"), MessageType.FAILURE);
            storeMetaData.setSuccess(false);
        }
        return storeMetaData;
    }

    private GridData convert(ProcessSearchQuery query, List<AdvanceSearchResult> results) {
        GridData result = new GridData();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<Data> data = new ArrayList<Data>();
        HashMap<String, Boolean> multipleActivity = new HashMap<String, Boolean>();
        for (AdvanceVariableForm searchVariable : query.getSearchVariables()) {
            if (searchVariable == null || searchVariable.getActive() == null) continue;
            Field field = new Field();
            field.setName(searchVariable.getName());
            field.setType("string");
            fields.add(field);
            Column column = new Column();
            column.setHeader(searchVariable.getViewname());
            column.setDataIndex(searchVariable.getName());
            column.setSortable(true);
            columns.add(column);
        }
        for (AdvanceSearchResult searchResult : results) {
            String activityId = searchResult.getActivityId();
            if (multipleActivity.containsKey(activityId)) {
                multipleActivity.put(activityId, true);
                continue;
            }
            multipleActivity.put(activityId, false);
        }
        for (AdvanceSearchResult searchResult : results) {
            Data resultData = new Data();
            ArrayList<DataItem> items = new ArrayList<DataItem>();
            items.add(new DataItem("id", searchResult.getActivityId()));
            items.add(new DataItem("activityDefinitionId", searchResult.getActivityDefinitionId()));
            for (AdvanceSearchResult.AdvanceVariable variable : searchResult.getAlVariables()) {
                String name = variable.getName();
                String value = variable.getDisplayValue();
                if (name.equals("taskUser") && ((Boolean)multipleActivity.get(searchResult.getActivityId())).booleanValue()) {
                    items.add(new DataItem(name, ""));
                    continue;
                }
                items.add(new DataItem(name, value));
            }
            resultData.setDataItems(items);
            data.add(resultData);
        }
        result.setFields(fields);
        result.setColumns(columns);
        result.setData(data);
        return result;
    }

    private List<Map<String, String>> getData(List<Data> dataList) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Data data : dataList) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (DataItem item : data.getDataItems()) {
                dataMap.put(item.getName(), item.getValue());
            }
            result.add(dataMap);
        }
        return result;
    }
}

