/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards;

import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.wizards.Wizard;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class WizardsRegistry {
    @Autowired
    private WebFragmentsManager webFragmentsManager;
    private final ConcurrentMap<String, Wizard<?, ?>> wizards = new ConcurrentHashMap();

    public void register(Wizard<?, ?> wizard) {
        Assert.notNull(wizard, (String)"[Assertion failed] - this argument is required; it must not be null");
        Wizard<?, ?> item = this.wizards.putIfAbsent(wizard.getName(), wizard);
        Assert.isNull(item, (String)("Wizard with name " + wizard.getName() + " has already been registered."));
        this.refreshUI();
    }

    public void unregister(String name) {
        this.wizards.remove(name);
        this.refreshUI();
    }

    public Map<String, Wizard<?, ?>> getWizards() {
        return Collections.unmodifiableMap(this.wizards);
    }

    public Wizard<?, ?> getWizard(String name) {
        return (Wizard)this.wizards.get(name);
    }

    private void refreshUI() {
        this.webFragmentsManager.refreshInterface();
    }
}

