/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.MenuBuilder;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.plugin.framework.web.support.MenuEntryGroup;
import com.suncode.plugin.framework.web.support.MenuItem;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardsRegistry;
import com.suncode.plugin.wizards.execution.config.WizardConfig;
import com.suncode.plugin.wizards.execution.config.WizardMenu;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class WizardMenuBuilder
implements MenuBuilder {
    @Autowired
    private Plugin plugin;
    @Autowired
    private WizardsRegistry wizardsRegistry;

    public void menu(String keyPrefix, MenuBuilder.Builder builder) {
        Map<String, Wizard<?, ?>> wizards = this.wizardsRegistry.getWizards();
        HashMap groups = Maps.newHashMap();
        for (Wizard<?, ?> wizard : wizards.values()) {
            WizardMenu menu = this.createMenu(keyPrefix, wizard);
            this.wrapWithGroups(menu, groups);
        }
        for (String section : groups.keySet()) {
            MenuEntryGroup group = (MenuEntryGroup)groups.get(section);
            builder.section(section).addItem((MenuItem)group);
        }
    }

    private <C extends WizardConfig<?, ?>, T extends WizardTask> WizardMenu createMenu(String keyPrefix, Wizard<C, T> wizard) {
        WizardMenu menu = new WizardMenu(this.plugin, wizard, keyPrefix + "-" + wizard.getName());
        wizard.getImplementation().createMenus(wizard, menu);
        return menu;
    }

    private void wrapWithGroups(WizardMenu menu, Map<String, MenuEntryGroup> groups) {
        Multimap<String, MenuEntry> menuEntries = menu.build();
        for (String section : menuEntries.keys()) {
            MenuEntryGroup group = groups.get(section);
            if (group == null) {
                group = new MenuEntryGroup(new LocalizedMessage(this.plugin, "base.menu.name", new Object[0]), 10);
                groups.put(section, group);
            }
            group.addEntries(menuEntries.get((Object)section));
        }
    }
}

