/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.administration.permission;

import com.suncode.plugin.wizards.attachdocuments.administration.AccessResource;
import com.suncode.plugin.wizards.attachdocuments.administration.Permission;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.PermissionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class PermissionDto {
    private Long id;
    private Long resourceId;
    private String resourceName;
    private AccessResource.ResourceType resourceType;
    private String processDefName;

    public PermissionDto(Permission permission, PermissionService permissionService) {
        this.id = permission.getId();
        AccessResource resource = permission.getResource();
        this.resourceType = resource.getType();
        if (resource.getType() == AccessResource.ResourceType.USER) {
            Optional<User> optionalUser = permissionService.getUserFromResource(resource);
            if (optionalUser.isPresent()) {
                User user = optionalUser.get();
                this.resourceId = user.getObjectId();
                this.resourceName = StringUtils.hasText((String)user.getFullName()) ? String.format("%s (%s)", user.getFullName(), user.getUserName()) : user.getUserName();
            } else {
                this.resourceId = null;
                this.resourceName = "null";
            }
        } else if (resource.getType() == AccessResource.ResourceType.GROUP) {
            Optional<UserGroup> optionalUserGroup = permissionService.getGroupFromResource(resource);
            if (optionalUserGroup.isPresent()) {
                UserGroup userGroup = optionalUserGroup.get();
                this.resourceId = userGroup.getObjectId();
                this.resourceName = userGroup.getName();
            } else {
                this.resourceId = null;
                this.resourceName = "null";
            }
        }
        this.processDefName = this.getProcessDefName(permission);
    }

    public static List<PermissionDto> from(List<Permission> list, PermissionService permissionService) {
        ArrayList<PermissionDto> result = new ArrayList<PermissionDto>();
        for (Permission permission : list) {
            PermissionDto dto = new PermissionDto(permission, permissionService);
            result.add(dto);
        }
        return result;
    }

    public String getProcessDefName(Permission permission) {
        if (permission.getProcessDefId() == null) {
            return "*";
        }
        ProcessService processService = (ProcessService)SpringContext.getBean(ProcessService.class);
        ProcessDefinition processDefinition = processService.getProcessDefinition(permission.getProcessDefId());
        if (processDefinition == null) {
            return "null";
        }
        String packageId = processDefinition.getPackageId();
        return PackageTranslationHelper.getProcessName((String)packageId, (String)permission.getProcessDefId());
    }

    public Long getId() {
        return this.id;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public AccessResource.ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getProcessDefName() {
        return this.processDefName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setResourceType(AccessResource.ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setProcessDefName(String processDefName) {
        this.processDefName = processDefName;
    }

    public PermissionDto() {
    }
}

