/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.wizards.attachdocuments.DocumentToAttach;
import com.suncode.plugin.wizards.execution.config.process.ProcessUnit;
import com.suncode.plugin.wizards.execution.state.SimpleTaskExecutionState;
import com.suncode.plugin.wizards.execution.state.TaskExecutionState;
import com.suncode.plugin.wizards.execution.task.TaskContext;
import com.suncode.plugin.wizards.execution.task.WizardTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AttachDocumentsTask
implements WizardTask {
    private final SearchResultActionSection.SearchType searchType;
    private final List<DocumentToAttach> documentsToAttach;
    private final boolean isFirst;
    private final ProcessUnit processUnit;
    private String comment;
    private final DocumentService documentService = ServiceFactory.getDocumentService();
    private final FileService fileService = ServiceFactory.getFileService();
    private final ProcessFinder processFinder = FinderFactory.getProcessFinder();
    private final ActivityFinder activityFinder = FinderFactory.getActivityFinder();
    private final DocumentClassActionService documentClassActionService = ServiceFactory.getDocumentClassActionService();
    private final DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
    private final CommentService commentService = (CommentService)SpringContext.getBean(CommentService.class);

    public AttachDocumentsTask(SearchResultActionSection.SearchType searchType, List<DocumentToAttach> documentsToAttach, boolean isFirst, ProcessUnit processUnit, String comment) {
        this.searchType = searchType;
        this.documentsToAttach = documentsToAttach;
        this.isFirst = isFirst;
        this.processUnit = processUnit;
        this.comment = comment;
    }

    public String getTaskId() {
        return this.processUnit.getId();
    }

    public TaskExecutionState.TaskExecutionStatus execute(SimpleTaskExecutionState status, TaskContext taskContext) throws Exception {
        String processId;
        String userName = taskContext.getLoggedUsername();
        String activityId = "";
        if (this.searchType == SearchResultActionSection.SearchType.PROCESS) {
            processId = this.processUnit.getId();
        } else {
            activityId = this.processUnit.getId();
            processId = this.processFinder.findProcessIdByActivityId(activityId);
        }
        for (DocumentToAttach documentToAttach : this.documentsToAttach) {
            WfDocument wfDocument = this.documentFinder.findByFileId(Long.valueOf(documentToAttach.getFileId()), Long.valueOf(documentToAttach.getDocumentClassId()));
            if (documentToAttach.isCopyForEach() && !this.isFirst) {
                wfDocument = this.copyDocument(wfDocument, userName);
                this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
            this.documentService.attachDocumentToProcess(wfDocument, userName, processId, activityId, true);
            this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.ADD_DOCUMENT_TO_PROCESS);
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            Comment comment = new Comment();
            comment.setProcessId(processId);
            comment.setActivityId(StringUtils.isNotBlank((CharSequence)activityId) ? activityId : this.activityFinder.findLastActivity(processId).getActivityId());
            comment.setComment(this.comment);
            comment.setTimestamp(Long.valueOf(new Date().getTime()));
            comment.setUserId(userName);
            this.commentService.createComment(comment);
        }
        return TaskExecutionState.TaskExecutionStatus.EXECUTED;
    }

    private WfDocument copyDocument(WfDocument wfDocument, String userName) throws IOException {
        WfFile wfFile = wfDocument.getFile();
        try (InputStream fileInputStream = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));){
            DocumentDefinition documentDefinition = new DocumentDefinition();
            documentDefinition.setAttachToClosedActivities(true);
            documentDefinition.setDocumentClassId(wfDocument.getDocumentClassId());
            documentDefinition.setUserName(userName);
            documentDefinition.setInputStream(fileInputStream);
            documentDefinition.setFileName(wfFile.getFileName());
            documentDefinition.setDescription(wfFile.getDescription());
            HashMap<Long, Object> indexes = new HashMap<Long, Object>();
            for (IndexInfo index : wfDocument.getIndexes()) {
                indexes.put(index.getId(), index.getValue());
            }
            documentDefinition.setIndexes(indexes);
            WfDocument wfDocument2 = this.documentService.addDocument(documentDefinition);
            return wfDocument2;
        }
    }

    public Map<String, Object> getAuditTaskParams() {
        HashMap<String, Object> auditTaskParams = new HashMap<String, Object>();
        if (this.searchType == SearchResultActionSection.SearchType.PROCESS) {
            auditTaskParams.put("attachDocuments_processId", this.getTaskId());
        } else {
            auditTaskParams.put("attachDocuments_activityId", this.getTaskId());
        }
        auditTaskParams.put("attachDocuments_isFirst", this.isFirst);
        return auditTaskParams;
    }
}

