/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.administration.permission.internal;

import com.suncode.plugin.wizards.attachdocuments.administration.AccessResource;
import com.suncode.plugin.wizards.attachdocuments.administration.Permission;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.NewPermissionDto;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.PermissionDao;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.PermissionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.workflow.search.ProcessSearchQuery;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PermissionServiceImpl
implements PermissionService {
    private static final String PROCESS_FIELD_PROCESS_DEF_ID = "procDefId";
    @Autowired
    private UserService userService;
    @Autowired
    private PermissionDao permissionDao;

    @Override
    public List<Permission> getAll() {
        return this.permissionDao.findByCriteria(DetachedCriteria.forClass(Permission.class));
    }

    @Override
    public Permission get(Long id) {
        return (Permission)this.permissionDao.get(id);
    }

    @Override
    public void delete(Permission permission) {
        this.permissionDao.delete(permission);
    }

    @Override
    public void changePermissions(NewPermissionDto permissionDto) {
        String processDefId;
        AccessResource resource = this.getResource(permissionDto.getResourceId(), permissionDto.getResourceType());
        Optional<Permission> targetPermissionOpt = this.findPermission(resource, processDefId = permissionDto.getProcessDefId());
        if (targetPermissionOpt.isPresent()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)processDefId)) {
            Optional<Permission> globalPermissionOpt = this.findPermission(resource, null);
            if (globalPermissionOpt.isPresent()) {
                Permission globalPermission = globalPermissionOpt.get();
                globalPermission.setProcessDefId(processDefId);
                this.permissionDao.save(globalPermission);
            } else {
                Permission newPermission = new Permission();
                newPermission.setResource(resource);
                newPermission.setProcessDefId(permissionDto.getProcessDefId());
                this.permissionDao.save(newPermission);
            }
        } else {
            List<Permission> permissions = this.getPermissions(resource);
            for (Permission permission : permissions) {
                this.permissionDao.delete(permission);
            }
            Permission newPermission = new Permission();
            newPermission.setResource(resource);
            this.permissionDao.save(newPermission);
        }
    }

    @Override
    public boolean hasUserPermission(String currentUser, SearchResultActionSection section) {
        User user = this.userService.getUser(currentUser, new String[]{"groups"});
        Set userGroups = user.getGroups();
        LinkedList resources = userGroups.stream().map(AccessResource::new).collect(Collectors.toCollection(LinkedList::new));
        resources.addFirst(new AccessResource(user));
        long compatibleGlobalPermissionsCount = this.permissionDao.findCompatibleGlobalPermissionsCount(resources);
        if (compatibleGlobalPermissionsCount > 0L) {
            return true;
        }
        List<String> selectedProcessDefIds = this.getSelectedProcessDefIds(section);
        if (selectedProcessDefIds.isEmpty()) {
            return false;
        }
        List<Permission> compatiblePermissions = this.permissionDao.findCompatiblePermissions(resources, selectedProcessDefIds);
        return selectedProcessDefIds.stream().allMatch(processDefId -> compatiblePermissions.stream().anyMatch(permission -> processDefId.equals(permission.getProcessDefId())));
    }

    private List<String> getSelectedProcessDefIds(SearchResultActionSection section) {
        Optional<String> selectedProcessDefIdOpt = this.getSelectedProcessDefId(section);
        if (selectedProcessDefIdOpt.isPresent()) {
            LinkedList<String> selectedProcessDefIds = new LinkedList<String>();
            selectedProcessDefIds.add(selectedProcessDefIdOpt.get());
            return selectedProcessDefIds;
        }
        return this.getSelectedProcessTypes(section);
    }

    private Optional<String> getSelectedProcessDefId(SearchResultActionSection section) {
        String selectedProcessDefId = this.getVariableValue(section, PROCESS_FIELD_PROCESS_DEF_ID);
        if (StringUtils.isNotBlank((CharSequence)selectedProcessDefId)) {
            return Optional.of(selectedProcessDefId);
        }
        return Optional.empty();
    }

    private List<String> getSelectedProcessTypes(SearchResultActionSection section) {
        String selectedProcessTypesValue = this.getVariableValue(section, ProcessSearchQuery.ProcessField.TYPE.getMapping());
        if (StringUtils.isBlank((CharSequence)selectedProcessTypesValue)) {
            return new LinkedList<String>();
        }
        String[] selectedProcessTypes = selectedProcessTypesValue.split(";");
        return new LinkedList<String>(Arrays.asList(selectedProcessTypes));
    }

    private List<Permission> getPermissions(AccessResource resource) {
        DetachedCriteria dc = DetachedCriteria.forClass(Permission.class);
        dc.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        return this.permissionDao.findByCriteria(dc);
    }

    private Optional<Permission> findPermission(AccessResource resource, String processDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Permission.class);
        dc.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        if (StringUtils.isNotBlank((CharSequence)processDefId)) {
            dc.add((Criterion)Restrictions.eq((String)"processDefId", (Object)processDefId));
        } else {
            dc.add(Restrictions.isNull((String)"processDefId"));
        }
        return Optional.ofNullable((Permission)this.permissionDao.findOne(dc));
    }

    private AccessResource getResource(Long id, AccessResource.ResourceType type) {
        switch (type) {
            case USER: {
                return new AccessResource(this.userService.getUser(id, new String[0]));
            }
            case GROUP: {
                return new AccessResource(this.userService.getGroup(id, new String[0]));
            }
        }
        throw new IllegalStateException("Unknown type of resource: " + String.valueOf((Object)type));
    }

    private String getVariableValue(SearchResultActionSection section, String mapping) {
        Object searchQuery = section.getSearchType() == SearchResultActionSection.SearchType.ACTIVITY ? section.getActivitySearchQuery() : section.getProcessSearchQuery();
        return Arrays.stream(searchQuery.getSearchVariables()).filter(advanceVariableForm -> advanceVariableForm.getName().equals(mapping)).findFirst().orElseThrow(RuntimeException::new).getValue();
    }

    @Override
    public Optional<User> getUserFromResource(AccessResource accessResource) {
        if (accessResource.getType() == AccessResource.ResourceType.USER) {
            return Optional.ofNullable(this.userService.getUser(accessResource.getId(), new String[0]));
        }
        return Optional.empty();
    }

    @Override
    public Optional<UserGroup> getGroupFromResource(AccessResource accessResource) {
        if (accessResource.getType() == AccessResource.ResourceType.GROUP) {
            return Optional.ofNullable(this.userService.getGroup(accessResource.getId(), new String[0]));
        }
        return Optional.empty();
    }
}

