/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.administration;

import com.suncode.plugin.wizards.util.Injectable;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import org.springframework.util.Assert;

@Embeddable
@Injectable
public class AccessResource {
    @Column(nullable=false)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private ResourceType type;

    public AccessResource(User user) {
        Assert.notNull((Object)user, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.id = user.getObjectId();
        this.type = ResourceType.USER;
    }

    public AccessResource(UserGroup group) {
        Assert.notNull((Object)group, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.id = group.getObjectId();
        this.type = ResourceType.GROUP;
    }

    public Long getId() {
        return this.id;
    }

    public ResourceType getType() {
        return this.type;
    }

    public AccessResource() {
    }

    public static enum ResourceType {
        USER,
        GROUP;

    }
}

