/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	var SelectionStep = __webpack_require__(1);
	var ConfigurationStep = __webpack_require__(4);
	var SummaryStep = __webpack_require__(23);
	
	Wizards.create({
	  title: 'ATTACH DOCUMENTS WIZARD',
	  steps: [SelectionStep, ConfigurationStep, SummaryStep],
	  wizardData: {},
	});


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var selectProcessStore = __webpack_require__(3);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.selection.SelectionStep', {
	  extend: 'Wizards.wizard.Step',
	  name: Wizards.t('selection.processes.step.name'),
	
	  initComponent: function () {
	    let selectGrid = {
	      id: 'selection-grid',
	      wizardProperty: 'units',
	      wizardTempProperty: 'selectedItems',
	    };
	
	    if (Wizards.searchContext.type === 'ACTIVITY') {
	      selectGrid.xtype = 'wizard-selectactivitygrid';
	      this.name = Wizards.t('selection.activities.step.name');
	    } else if (Wizards.searchContext.type === 'PROCESS') {
	      selectGrid.xtype = 'wizard-selectprocessgrid';
	      selectGrid.store = selectProcessStore;
	    } else {
	      this.on('afterrender', function () {
	        this.showMessages({
	          text: Wizards.t('selection.search.type.error'),
	          type: 'failure',
	        });
	      });
	    }
	
	    this.items = [
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'selection-item',
	        flex: 1,
	        errorMsg: Wizards.t('selection.step.grid.errormsg'),
	        items: selectGrid,
	        msgTarget: 'under',
	        margin: '0 0 10 0',
	        description: Wizards.t('selection.step.grid.description'),
	      },
	    ];
	
	    this.callParent(arguments);
	  },
	
	  validate: function () {
	    var item = this.down('#selection-item');
	    var grid = this.down('#selection-grid');
	    var isValid = grid.validate();
	    if (!isValid) {
	      this.setInvalid(item);
	    } else {
	      this.unsetInvalid(item);
	    }
	    return isValid;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'selectprocessstore',
	  model: 'Wizards.components.selectprocess.SelectProcessGrid',
	  proxy: {
	    type: 'ajax',
	    url: Wizards.pluginContextPath + '/components/selectprocess',
	    extraParams: {
	      section: Wizards.section,
	      filter: 'all',
	      searchId: Wizards.searchContext.searchId,
	    },
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var documentClassStore = __webpack_require__(5);
	var fileStore = __webpack_require__(7);
	var indexStore = __webpack_require__(9);
	var documentStore = __webpack_require__(11);
	__webpack_require__(13);
	__webpack_require__(14);
	__webpack_require__(18);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.configuration.ConfigurationStep', {
	  extend: 'Wizards.wizard.Step',
	  name: Wizards.t('configuration.step.name'),
	  xtype: 'wizard-configurationstep',
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	  activated: function () {
	    this.loadMask = new Ext.LoadMask({ target: this });
	    this.loadMask.show();
	
	    this.clearMessages();
	    let selectionGrid = Ext.getCmp('selection-grid');
	    let selectedItems = selectionGrid.getSelectionModel().getSelection();
	
	    let selectedItemsWithUniqueProcessType = selectedItems
	      .map(rec => rec.data)
	      .filter(this.isUnique)
	      .map(data => data.id);
	
	    if (Wizards.searchContext.type === 'ACTIVITY') {
	      documentClassStore.proxy.url = Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-attach-documents/documentClass/activities';
	      documentClassStore.proxy.setExtraParam('activitiesIds', selectedItemsWithUniqueProcessType);
	    } else {
	      documentClassStore.proxy.url = Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-attach-documents/documentClass/processes';
	      documentClassStore.proxy.setExtraParam('processesIds', selectedItemsWithUniqueProcessType);
	    }
	
	    documentClassStore.load(this.storeCallback.bind(this));
	  },
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'wizard-configurationcontainer',
	      },
	      {
	        xtype: 'wizard-step-item',
	        itemId: 'comment',
	        description: Wizards.t('configuration.comment.description'),
	        padding: '20 12 0 12',
	        maxHeight: 200,
	        items: [
	          {
	            xtype: 'wizard-comment-field',
	            value: `${Wizards.t('configuration.comment.initialValue')}: {fileNames}`,
	          },
	        ],
	      }
	    ];
	    this.callParent(arguments);
	  },
	
	  isUnique: function (value, index, self) {
	    for (let i = index + 1; i < self.length; i++) {
	      if (self[i].processType === value.processType) {
	        return false;
	      }
	    }
	
	    return true;
	  },
	
	  storeCallback: function (records, operation, success) {
	    if (!success) {
	      this.showMessages([
	        {
	          text: Wizards.t('configuration.step.error'),
	          type: 'failure',
	        },
	      ]);
	    } else if (records.length === 0) {
	      this.showMessages([
	        {
	          text: Wizards.t('configuration.step.nodocumentclass'),
	          type: 'warning',
	        },
	      ]);
	    }
	
	    this.loadMask.hide();
	  },
	
	  addDocuments() {
	    let documentClass = this.down('#documentClass');
	    let description = this.down('#description');
	    let copyForEach = this.down('#copyForEach');
	    let saveAsNew = this.down('#saveAsNew');
	
	    if (!this.validateFiles() | !documentClass.validate()) {
	      return;
	    }
	
	    let indexes = indexStore.getRange().map(record => record.data);
	
	    fileStore.each(function (record, id) {
	      documentStore.add({
	        fileName: record.data.fileName,
	        documentClass: documentClass.getRawValue(),
	        documentClassId: documentClass.value,
	        description: description.value,
	        saveAsNew: saveAsNew.value,
	        copyForEach: copyForEach.value,
	        file: record.data.file,
	        indexes: indexes,
	      });
	    });
	
	    documentClass.reset();
	    description.reset();
	    saveAsNew.reset();
	    copyForEach.reset();
	    fileStore.removeAll();
	  },
	
	  validateFiles: function () {
	    let valid = fileStore.getCount() > 0;
	    if (!valid) {
	      let fileGrid = this.down('wizard-configurationcontainer').down('wizard-filegrid');
	      fileGrid.showError();
	    }
	    return valid;
	  },
	
	  validate: function () {
	    var isValid = documentStore.getCount() > 0;
	
	    if (!isValid) {
	      let documentGrid = this.down('wizard-configurationcontainer').down('wizard-documentgrid');
	      documentGrid.showError();
	    }
	    return isValid;
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(6);
	
	module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'documentclassstore',
	  model: 'Wizards.attachdocuments.components.configuration.DocumentClassModel',
	  proxy: {
	    type: 'ajax',
	    actionMethods: {
	      read: 'POST'
	    },
	    reader: {
	      type: 'json',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.DocumentClassModel', {
	  extend: 'Ext.data.Model',
	
	  fields: [{ name: 'name', type: 'string' }, { name: 'description', type: 'string' }, { name: 'id', type: 'int' }, { name: 'indexes' }],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var fileModel = __webpack_require__(8);
	
	module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'filestore',
	  model: fileModel,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.file.File', {
	  extend: 'Ext.data.Model',
	
	  fields: [{ name: 'fileName', type: 'string' }, { name: 'file' }],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(10);
	
	module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'indexstore',
	  model: 'Wizards.attachdocuments.components.configuration.index.IndexModel',
	  sorters: [
	    {
	      property: 'orderId',
	      direction: 'ASC',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.index.IndexModel', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    { name: 'name', type: 'string' },
	    { name: 'description', type: 'string' },
	    { name: 'id', type: 'int' },
	    { name: 'orderId', type: 'int' },
	    { name: 'indexType', type: 'string' },
	    { name: 'values', type: 'string' },
	    { name: 'value', defaultValue: null },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(12);
	
	module.exports = Ext.create('Ext.data.Store', {
	  storeId: 'documentstore',
	  model: 'Wizards.attachdocuments.components.configuration.document.DocumentModel',
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.document.DocumentModel', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    { name: 'documentClassId', type: 'int' },
	    { name: 'documentClass', type: 'string' },
	    { name: 'description', type: 'string' },
	    { name: 'saveAsNew', type: 'bool' },
	    { name: 'copyForEach', type: 'bool' },
	    { name: 'fileName', type: 'string' },
	    { name: 'file' },
	    { name: 'indexes' },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {const documentClassStore = __webpack_require__(5);
	var indexStore = __webpack_require__(9);
	
	__webpack_require__(13);
	__webpack_require__(14);
	__webpack_require__(18);
	__webpack_require__(22);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.configuration.ConfigurationContainer', {
	  extend: 'Ext.container.Container',
	  border: false,
	  padding: '0 12',
	  margin: '15 0 0 0',
	  xtype: 'wizard-configurationcontainer',
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  initComponent: function () {
	    let me = this;
	
	    this.items = [
	      {
	        xtype: 'combobox',
	        store: documentClassStore,
	        emptyText: Wizards.t('configuration.step.combobox.fieldlabel'),
	        typeAhead: true,
	        minChars: 1,
	        queryMode: 'local',
	        bodyPadding: 20,
	        allowBlank: false,
	        blankText: Wizards.t('configuration.step.combobox.blank.text'),
	        fieldLabel: Wizards.t('configuration.step.combobox.fieldlabel'),
	        valueField: 'id',
	        displayField: 'name',
	        forceSelection: true,
	        labelWidth: 300,
	        itemId: 'documentClass',
	        listeners: {
	          select: function (combo, record, eOpts) {
	            let indexes = record[0].data.indexes;
	
	            indexStore.removeAll();
	            indexStore.add(indexes);
	            me.up().down('wizard-indexpanel').reconfigure();
	          },
	          change: function (combo, newValue, oldValue, eOpts) {
	            if (newValue == null) {
	              indexStore.removeAll();
	              me.up().down('wizard-indexpanel').reset();
	            }
	          },
	        },
	      },
	      {
	        xtype: 'textfield',
	        labelWidth: 300,
	        fieldLabel: Wizards.t('configuration.step.description.fieldlabel'),
	        itemId: 'description',
	      },
	      {
	        xtype: 'checkboxfield',
	        labelWidth: 300,
	        fieldLabel: Wizards.t('configuration.step.new.fieldlabel'),
	        itemId: 'saveAsNew',
	      },
	      {
	        xtype: 'checkboxfield',
	        labelWidth: 300,
	        fieldLabel: Wizards.t('configuration.step.copy.fieldlabel'),
	        itemId: 'copyForEach',
	      },
	      {
	        xtype: 'wizard-indexpanel',
	      },
	      {
	        xtype: 'wizard-filegrid',
	      },
	      {
	        xtype: 'toolbar',
	        cls: 'addDocumentToolbar',
	        layout: {
	          pack: 'center',
	        },
	        items: [
	          {
	            text: Wizards.t('configuration.step.addDocumentButton.text'),
	            scale: 'large',
	            listeners: {
	              click: function () {
	                me.up().addDocuments();
	              },
	            },
	          },
	        ],
	      },
	      {
	        xtype: 'wizard-documentgrid',
	      },
	    ];
	    this.callParent(arguments);
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var fileStore = __webpack_require__(7);
	var toolbar = __webpack_require__(15);
	
	__webpack_require__(16);
	__webpack_require__(17);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.configuration.file.FileGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-filegrid',
	  maxHeight: 630,
	  store: fileStore,
	  selType: 'cellmodel',
	  minHeight: 300,
	  dockedItems: [toolbar],
	  style: 'transition: border-color 100ms;',
	  title: Wizards.t('configuration.file.grid.title'),
	  columns: [
	    {
	      xtype: 'lpcolumn',
	      width: 54,
	    },
	    {
	      text: Wizards.t('configuration.file.grid.fileName'),
	      dataIndex: 'fileName',
	      flex: 100,
	    },
	    {
	      text: Wizards.t('configuration.file.grid.fileSize'),
	      dataIndex: 'file',
	      renderer: function (value, record) {
	        let fileSize = value.size;
	        let unit = 0;
	
	        while (fileSize / 1000 > 1) {
	          fileSize = fileSize / 1000;
	          unit += 1;
	        }
	
	        fileSize = Math.round(fileSize);
	
	        switch (unit) {
	          case 0:
	            return fileSize + ' B';
	          case 1:
	            return fileSize + ' KB';
	          case 2:
	            return fileSize + ' MB';
	          case 3:
	            return fileSize + ' GB';
	          case 4:
	            return fileSize + ' TB';
	        }
	      },
	    },
	    {
	      xtype: 'deleteactioncolumn',
	      width: 36,
	    },
	  ],
	  listeners: {
	    drop: {
	      element: 'el',
	      fn: function (ev) {
	        if (ev.target.tagName === 'INPUT') {
	          return;
	        }
	
	        ev.preventDefault();
	
	        let files;
	
	        if (ev.browserEvent.target.files) {
	          files = ev.browserEvent.target.files;
	        } else if (ev.browserEvent.dataTransfer) {
	          files = ev.browserEvent.dataTransfer.files;
	        } else {
	          files = ev.browserEvent.originalEvent.dataTransfer.files;
	        }
	
	        for (let i = 0; i < files.length; i++) {
	          let file = files.item(i);
	
	          fileStore.add({
	            fileName: file.name,
	            file: file,
	          });
	        }
	      },
	    },
	    dragstart: {
	      element: 'el',
	      fn: function (ev) {
	        ev.browserEvent.dataTransfer.dropEffect = 'move';
	        ev.preventDefault();
	      },
	    },
	    dragover: {
	      element: 'el',
	      fn: function (ev) {
	        ev.browserEvent.dataTransfer.dropEffect = 'move';
	        ev.preventDefault();
	      },
	    },
	  },
	
	  initComponent: function (config) {
	    document.addEventListener('dragover', this.highlightedBorderColor.bind(this));
	    document.addEventListener('dragleave', this.normalBorderColor.bind(this));
	    document.addEventListener('drop', this.normalBorderColor.bind(this));
	
	    fileStore.on('datachanged', this.normalBorderColor.bind(this));
	    this.callParent(arguments);
	  },
	
	  normalBorderColor: function () {
	    this.el.removeCls('error-border');
	    this.el.removeCls('highlighted-border');
	  },
	
	  showError: function () {
	    this.el.addCls('error-border');
	    this.el.removeCls('highlighted-border');
	  },
	
	  highlightedBorderColor: function () {
	    this.el.addCls('highlighted-border');
	    this.el.removeCls('error-border');
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var fileStore = __webpack_require__(7);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.configuration.file.FileToolbar', {
	  extend: 'Ext.toolbar.Toolbar',
	  xtype: 'wizard-filetoolbar',
	  dock: 'bottom',
	  cls: 'fileToolbar',
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  initComponent: function () {
	    this.items = [
	      {
	        xtype: 'filebutton',
	        name: 'fileButton',
	        cls: 'fileGridButton',
	        text: Wizards.t('configuration.file.toolbar.fileButton.text'),
	        listeners: {
	          afterrender: function (comp, options) {
	            comp.fileInputEl.set({
	              multiple: '',
	            });
	          },
	
	          change: function (component, event) {
	            let files;
	
	            if (event.target.files) {
	              files = event.target.files;
	            } else if (event.dataTransfer) {
	              files = event.dataTransfer.files;
	            } else {
	              files = event.originalEvent.dataTransfer.files;
	            }
	
	            for (let i = 0; i < files.length; i++) {
	              let file = files.item(i);
	
	              fileStore.add({
	                fileName: file.name,
	                file: file,
	              });
	            }
	          },
	        },
	      },
	    ];
	
	    this.callParent();
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.columns.LpColumn', {
	  extend: 'Ext.grid.column.Column',
	  xtype: 'lpcolumn',
	  text: Wizards.t('configuration.document.grid.column.lp'),
	  renderer: function (value, record) {
	    return record.rowIndex + 1;
	  },
	  align: 'right',
	  width: 54,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.columns.DeleteActionColumn', {
	  extend: 'Ext.grid.column.Action',
	  xtype: 'deleteactioncolumn',
	  items: [
	    {
	      iconCls: 'dvnt-icon-x-symbol dvnt-red-icon',
	      tooltip: Wizards.t('configuration.columns.delete.tooltip'),
	      handler: function (grid, rowIndex, colIndex) {
	        grid.getStore().removeAt(rowIndex);
	        grid.refresh();
	      },
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var indexStore = __webpack_require__(9);
	__webpack_require__(19);
	__webpack_require__(20);
	__webpack_require__(21);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.configuration.index.IndexPanel', {
	  extend: 'Ext.panel.Panel',
	  bodyPadding: 20,
	  frameHeader: true,
	  xtype: 'wizard-indexpanel',
	  title: Wizards.t('configuration.index.panel.title'),
	  margin: '20 0',
	  collapsible: true,
	  collapsed: true,
	  border: true,
	  style: {
	    borderWidth: '1px',
	    borderStyle: 'solid',
	  },
	  bodyStyle: {
	    borderStyle: 'none',
	  },
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  initComponent: function (config) {
	    this.items = [
	      {
	        xtype: 'nodocumentcomponent',
	      },
	    ];
	
	    this.callParent(arguments);
	  },
	
	  reset() {
	    this.removeAll();
	    this.add({
	      xtype: 'nodocumentcomponent',
	    });
	  },
	
	  reconfigure: function () {
	    this.removeAll();
	    let fields = [];
	
	    if (indexStore.getCount() === 0) {
	      this.add({
	        xtype: 'noindexcomponent',
	      });
	    }
	
	    for (let i = 0; i < indexStore.getCount(); i++) {
	      let indexRecord = indexStore.getAt(i);
	      fields.push(this.getField(indexRecord));
	    }
	
	    this.add(fields);
	    this.doLayout();
	  },
	
	  getField: function (indexRecord) {
	    switch (indexRecord.data.indexType) {
	      case 'LONG':
	        return this.getLongField(indexRecord);
	      case 'DOUBLE':
	        return this.getDoubleField(indexRecord);
	      case 'DATE':
	        return this.getDateField(indexRecord);
	      case 'DATETIME':
	        return this.getDateTimeField(indexRecord);
	      case 'BOOLEAN':
	        return this.getBoolField(indexRecord);
	      case 'LIST':
	        return this.getListField(indexRecord);
	      case 'STRING':
	      default:
	        return this.getStringField(indexRecord);
	    }
	  },
	
	  getLongField: function (indexRecord) {
	    let field = this.getBasicField(indexRecord);
	    field.xtype = 'numberfield';
	    field.allowDecimals = false;
	    return field;
	  },
	
	  getStringField: function (indexRecord) {
	    let field = this.getBasicField(indexRecord);
	    field.xtype = 'textfield';
	    return field;
	  },
	
	  getDoubleField: function (indexRecord) {
	    let field = this.getBasicField(indexRecord);
	    field.xtype = 'numberfield';
	    field.allowDecimals = true;
	    return field;
	  },
	
	  getDateField: function (indexRecord) {
	    let field = this.getBasicField(indexRecord);
	    field.xtype = 'datefield';
	    return field;
	  },
	
	  getDateTimeField: function (indexRecord) {
	    let field = this.getBasicField(indexRecord);
	    field.xtype = 'datetimefield';
	    field.format = 'Y-m-d H:i:s';
	
	    return field;
	  },
	
	  getBoolField: function (indexRecord) {
	    let field = this.getBasicField(indexRecord);
	
	    field.xtype = 'checkboxfield';
	    return field;
	  },
	
	  getListField: function (indexRecord) {
	    let valueArray = indexRecord.data.values.split(/\r?\n/);
	    let listData = [];
	
	    for (let i = 0; i < valueArray.length; i++) {
	      listData.push({
	        value: valueArray[i],
	      });
	    }
	
	    let states = Ext.create('Ext.data.Store', {
	      fields: ['value'],
	      data: listData,
	    });
	
	    let field = this.getBasicField(indexRecord);
	    field.xtype = 'combobox';
	    field.store = states;
	    field.queryMode = 'local';
	    field.displayField = 'value';
	    field.valueField = 'value';
	    return field;
	  },
	
	  getBasicField: function (indexRecord) {
	    return {
	      fieldLabel: indexRecord.data.name,
	      labelWidth: 200,
	      allowBlank: true,
	      listeners: {
	        change: function (field, newVal, oldVal) {
	          if (field.xtype === 'datefield') {
	            newVal = Ext.Date.format(newVal, 'Y-m-d');
	          }
	
	          indexRecord.set('value', newVal);
	        },
	      },
	    };
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.index.NoIndexesComponent', {
	  extend: 'Ext.Component',
	  xtype: 'noindexcomponent',
	  style: 'text-align: center;',
	  html: Wizards.t('configuration.index.component.noindexes.text'),
	  padding: 20,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.index.NoDocumentClassComponent', {
	  extend: 'Ext.Component',
	  xtype: 'nodocumentcomponent',
	  style: 'text-align: center;',
	  html: Wizards.t('configuration.index.component.nodocument.text'),
	  padding: 20,
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.components.configuration.index.DateTimeField', {
	  extend: 'Ext.form.field.Date',
	  xtype: 'datetimefield',
	  triggerCls: 'dvnt-icon-time',
	
	  initComponent: function () {
	    this.callParent();
	    this.on({
	      afterrender: this.addCalendarAction,
	      scope: this,
	    });
	  },
	
	  onTriggerClick: function (event) {
	    if (!this.readOnly && !this.disabled) {
	      this.inputEl.focus();
	    }
	  },
	
	  addCalendarAction: function (field) {
	    Calendar.setup({
	      inputField: field.getInputId(),
	      button: field.getEl().down('.x4-trigger-cell').id,
	      alignToEl: field.getInputId(),
	      ifFormat: '%Y-%m-%d %H:%M:%S',
	      singleClick: true,
	      showsTime: true,
	      timeFormat: '24',
	      onSelect: function onSelect(cal) {
	        let formattedDate = Ext.Date.format(cal.date, 'Y-m-d H:i:s');
	
	        if (!field.variableDisabled) {
	          field.setValue(formattedDate);
	        }
	
	        if (cal.params.singleClick && cal.dateClicked) {
	          cal.callCloseHandler();
	        }
	
	        field.fireEvent('select', field, formattedDate);
	        field.fireEvent('change', field, formattedDate);
	      },
	      onClose: function (cal) {
	        cal.hide();
	        field.focus();
	      },
	    });
	
	    field
	      .getEl()
	      .down('div.x4-form-trigger')
	      .on(
	        'click',
	        function (event) {
	          this.preventShowingCalendarIfDisabled(field, event);
	        },
	        this
	      );
	  },
	  preventShowingCalendarIfDisabled: function (field, event) {
	    if (field.readOnly || field.disabled) {
	      event.stopPropagation();
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var documentStore = __webpack_require__(11);
	__webpack_require__(16);
	__webpack_require__(17);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.configuration.document.DocumentGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'wizard-documentgrid',
	  store: documentStore,
	  selType: 'cellmodel',
	  margin: '20 0 0 0',
	  minHeight: 300,
	  maxHeight: 550,
	  title: Wizards.t('configuration.document.grid.title'),
	  columns: [
	    {
	      xtype: 'lpcolumn',
	      width: 54,
	    },
	    {
	      text: Wizards.t('configuration.document.grid.column.fileName'),
	      dataIndex: 'fileName',
	      flex: 30,
	    },
	    {
	      text: Wizards.t('configuration.document.grid.column.documentClass'),
	      dataIndex: 'documentClass',
	      flex: 15,
	    },
	    {
	      text: Wizards.t('configuration.document.grid.column.description'),
	      dataIndex: 'description',
	      flex: 40,
	    },
	    {
	      text: Wizards.t('configuration.document.grid.column.saveAsNew'),
	      dataIndex: 'saveAsNew',
	      flex: 10,
	      align: 'center',
	      renderer: function (value) {
	        var imgClass = value ? 'dvnt-icon-check-symbol dvnt-green-icon' : 'dvnt-icon-x-symbol dvnt-red-icon';
	        return '<p class="' + imgClass + '" style="height:16px;text-align:center"></p>';
	      },
	    },
	    {
	      text: Wizards.t('configuration.document.grid.column.copyForEach'),
	      dataIndex: 'copyForEach',
	      align: 'center',
	      flex: 10,
	      renderer: function (value) {
	        var imgClass = value ? 'dvnt-icon-check-symbol dvnt-green-icon' : 'dvnt-icon-x-symbol dvnt-red-icon';
	        return '<p class="' + imgClass + '" style="height:16px;text-align:center"></p>';
	      },
	    },
	    {
	      xtype: 'deleteactioncolumn',
	      width: 36,
	    },
	  ],
	
	  initComponent: function (config) {
	    documentStore.on('datachanged', this.hideError.bind(this));
	    this.callParent(arguments);
	  },
	
	  showError: function () {
	    this.el.addCls('error-border');
	  },
	
	  hideError() {
	    this.el.removeCls('error-border');
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var documentStore = __webpack_require__(11);
	
	module.exports = Ext.define('Wizards.attachdocuments.components.summary.SummaryStep', {
	  extend: 'Wizards.components.summary.SummaryStep',
	  name: Wizards.t('summary.step.name'),
	
	  onExecuteClick: function () {
	    var me = this;
	
	    this.loadMask = new Ext.LoadMask({
	      target: this,
	    });
	    this.loadMask.show();
	    this.wizard.hideContainerToolbar();
	    this.down('#execute-button').disable();
	
	    let url = Wizards.contextPath + '/plugin/com.suncode.plugin-wizards-attach-documents/file';
	    let documents = documentStore.getRange();
	    let formData = new FormData();
	    let filesData = [];
	
	    for (let i = 0; i < documents.length; i++) {
	      let indexList = documents[i].data.indexes;
	
	      formData.append('files', documents[i].data.file);
	
	      indexList = indexList.map(index => ({
	        id: index.id,
	        value: index.indexType === 'DOUBLE' && index.value ? index.value.toFixed(2) : index.value,
	      }));
	
	      let fileData = {
	        documentClassId: documents[i].data.documentClassId,
	        saveAsNewVersion: documents[i].data.saveAsNew,
	        copyForEach: documents[i].data.copyForEach,
	        description: documents[i].data.description,
	        indexes: indexList,
	      };
	
	      filesData.push(fileData);
	    }
	
	    formData.append('fileDataArrayString', JSON.stringify(filesData));
	
	    const xhr = new XMLHttpRequest();
	    xhr.onreadystatechange = function () {
	      if (xhr.readyState === 4) {
	        if (xhr.status === 200) {
	          me.executeTask(JSON.parse(xhr.responseText));
	        } else {
	          me.showMessages({
	            text: Wizards.t('summary.step.file.upload.request.error'),
	            type: 'failure',
	          });
	          me.wizard.showConatainerToolbar();
	          me.down('#execute-button').enable();
	        }
	        me.loadMask.hide();
	      }
	    };
	
	    xhr.open('POST', url);
	    xhr.send(formData);
	  },
	
	  executeTask: function (documents) {
	    var config = this.getAllData();
	    config.documentsToAttach = documents;
	    config.searchType = Wizards.searchContext.type;
	
	    const rawComment = this.up()
	        .down('wizard-configurationstep')
	        .down('#comment')
	        .down('wizard-comment-field')
	        .getValue()
	
	    const fileNames = documentStore.getRange().map(doc => doc.data.fileName).join(", ")
	    config.comment = rawComment.replaceAll('{fileNames}', fileNames);
	
	    Ext.Ajax.request({
	      scope: this,
	      url: Wizards.pluginContextPath + '/wizard/' + Wizards.name + '/execute',
	      params: {
	        section: Wizards.section,
	        menuEntryKey: Wizards.menuEntryKey,
	        searchId: Wizards.searchContext.searchId,
	      },
	      jsonData: config,
	      success: function (response, options) {
	        this.checkExecutionStatus(response.responseText, 5);
	      },
	      failure: function (response, options) {
	        this.showMessages({
	          text: Wizards.baseT('base.summary.step.error.execution'),
	          type: 'failure',
	        });
	      },
	    });
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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