/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	__webpack_require__(1);
	Wizards.t = Wizards.I18N.createT('com.suncode.plugin-wizards-attach-documents');
	
	var Application = __webpack_require__(3),
	  Viewport = __webpack_require__(4),
	  PermissionController = __webpack_require__(15);
	
	/**
	 * Main application of Attach Documents Administration
	 *
	 * @main
	 */
	Application.create({
	  name: 'Attach Documents Configuration',
	  view: {
	    type: Viewport,
	    target: 'wizard-attach-documents-admin-container',
	  },
	  controllers: [PermissionController],
	});


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var cached = {};
	
	module.exports = Ext.define('Wizards.I18N', {
	  singleton: true,
	
	  /**
	   * Returns translated message for given key and translator name.
	   *
	   * @example
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * @method t
	   * @param {String} translator translator name
	   * @param {String} key message key
	   * @param {...Object} [args] additional message arguments (resolved as placeholders i.e. {0})
	   * @return Translated message or supplied key if there is no translation available
	   */
	  t: function (translator, key) {
	    var message = this.bundle(translator)[key];
	    if (!Ext.isEmpty(message)) {
	      var args = Ext.Array.toArray(arguments, 2);
	      return Ext.String.format.apply(this, [message].concat(args));
	    }
	    return key;
	  },
	
	  /**
	   * Creates shorthand function for translating message using single translator. For example instead of
	   *
	   * 	PW.I18N.t('plusworkflow', 'user.desc', 'Some', 'Name')
	   *
	   * you can use create shorthand function once
	   *
	   * 	PW.t = PW.I18N.createT('plusworkflow');
	   *
	   * and then use it like
	   *
	   * 	PW.t('user.desc', 'Jan', 'Kowalski' );
	   *
	   * @method createT
	   * @param {String} translator translator name
	   */
	  createT: function (translator) {
	    return Ext.bind(this.t, this, [translator], 0);
	  },
	
	  bundle: function (key) {
	    var bundle = cached[key];
	
	    // Jeżeli nie ma załadowanego bundle'a to SYNCHRONICZNIE pobieramy go z bazy danych
	    if (!Ext.isObject(bundle)) {
	      Ext.Ajax.request({
	        url: Suncode.getAbsolutePath('/api/translation/bundle/' + encodeURIComponent(key)),
	        method: 'GET',
	        async: false,
	        timeout: 5000,
	        success: function (response) {
	          bundle = Ext.decode(response.responseText);
	          cached[key] = bundle;
	        },
	      });
	    }
	    return bundle || {};
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

	module.exports = Ext4;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {// Przygotowanie kontekstu do przechowywania danych na temat aplikacji
	var context = Suncode.context('attach-documents');
	if (!context.applications) {
	  context.applications = {};
	}
	
	/**
	 * Aplikacja
	 */
	module.exports = Ext.define('Wizards.attachdocuments.admin.app.Application', {
	  constructor: function (config) {
	    var existingApp = context.applications[config.name];
	    if (existingApp) {
	      existingApp.destroy();
	    }
	
	    try {
	      this.prepareControllers(config.controllers);
	      this.prepareView(config.view);
	      this.init(config.launch);
	    } finally {
	      context.applications[config.name] = this;
	    }
	  },
	
	  prepareControllers: function (controllers) {
	    this.controllers = [];
	    Ext.each(
	      controllers,
	      function (controllerClass) {
	        var controller = controllerClass.create();
	        controller.id = controllerClass.$className;
	
	        controller.fireGlobalEvent = function () {
	          Ext.globalEvents.fireEvent.apply(Ext.globalEvents, arguments);
	        };
	        controller.listenGlobal = function (event) {
	          Ext.globalEvents.on.apply(Ext.globalEvents, arguments);
	        };
	
	        this.controllers.push(controller);
	      },
	      this
	    );
	  },
	
	  prepareView: function (view) {
	    this.view = view.type.create({
	      renderTarget: view.target,
	    });
	  },
	
	  init: function (launchFn) {
	    Ext.tip.QuickTipManager.init();
	    Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider());
	
	    Ext.each(
	      this.controllers,
	      function (controller) {
	        controller.init();
	      },
	      this
	    );
	
	    Ext.onReady(
	      function () {
	        // render view
	        this.view.render(this.view.renderTarget);
	
	        // call launch
	        if (Ext.isFunction(launchFn)) {
	          launchFn.call(this, this.view);
	        }
	
	        Ext.each(
	          this.controllers,
	          function (controller) {
	            controller.finishInit();
	          },
	          this
	        );
	      },
	      this,
	      {
	        single: true,
	      }
	    );
	  },
	
	  destroy: function () {
	    if (this.view) {
	      this.view.destroy();
	    }
	
	    if (this.controllers) {
	      Ext.each(
	        this.controllers,
	        function (controller) {
	          controller.eventbus.unlisten(controller.id);
	        },
	        this
	      );
	    }
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(5);
	
	module.exports = Ext.define('OCI.configuration.Viewport', {
	  extend: 'Ext.container.Container',
	  xtype: 'attach-documents-admin-viewport',
	
	  height: 600,
	  border: false,
	  style: {
	    'text-align': 'left',
	  },
	  bodyStyle: {
	    background: 'none',
	  },
	
	  items: [
	    {
	      xtype: 'attach-documents-admin-permission-panel',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(6);
	__webpack_require__(11);
	
	module.exports = Ext.define('Wizards.attachdocuments.administration.permission.PermissionPanel', {
	  extend: 'Ext.panel.Panel',
	  xtype: 'attach-documents-admin-permission-panel',
	
	  layout: {
	    type: 'hbox',
	    align: 'stretch',
	  },
	  border: false,
	
	  items: [
	    {
	      xtype: 'attach-documents-admin-permission-new',
	      flex: 1,
	      style: 'margin-right: 5px;',
	    },
	    {
	      xtype: 'attach-documents-admin-permission-grid',
	      height: 600,
	      flex: 2,
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(7);
	
	var usersStore = __webpack_require__(8),
	  groupsStore = __webpack_require__(9),
	  processDefinitionsStore = __webpack_require__(10);
	
	module.exports = Ext.define('Wizards.attachdocuments.administration.permission.form.NewPermissionForm', {
	  extend: 'Ext.form.Panel',
	  xtype: 'attach-documents-admin-permission-new',
	
	  title: Wizards.t('administration.permissions.new.title'),
	
	  bodyPadding: 10,
	  layout: {
	    type: 'vbox',
	    align: 'stretch',
	  },
	
	  items: [
	    {
	      xtype: 'radiogroup',
	      allowBlank: false,
	      itemId: 'resourceTypeGroup',
	      columns: 2,
	      items: [
	        {
	          xtype: 'attach-documents-radio',
	          boxLabel: Wizards.t('administration.permissions.new.field.user'),
	          name: 'resourceType',
	          iconCls: 'dvnt-icon-user',
	          inputValue: 'USER',
	          checked: true,
	        },
	        {
	          xtype: 'attach-documents-radio',
	          boxLabel: Wizards.t('administration.permissions.new.field.group'),
	          name: 'resourceType',
	          iconCls: 'dvnt-icon-users',
	          inputValue: 'GROUP',
	        },
	      ],
	    },
	    {
	      xtype: 'combo',
	      allowBlank: false,
	      name: 'resourceId',
	      itemId: 'userCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.user'),
	      store: usersStore,
	      valueField: 'objectId',
	      displayField: 'viewName',
	      pageSize: 20,
	      minChars: 0,
	      forceSelection: true,
	    },
	    {
	      xtype: 'combo',
	      allowBlank: false,
	      name: 'resourceId',
	      itemId: 'groupCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.group'),
	      store: groupsStore,
	      valueField: 'objectId',
	      displayField: 'name',
	      pageSize: 20,
	      disabled: true,
	      minChars: 0,
	      forceSelection: true,
	    },
	    {
	      xtype: 'combo',
	      allowBlank: true,
	      name: 'processDefId',
	      itemId: 'processDefCombo',
	      fieldLabel: Wizards.t('administration.permissions.new.field.processdef'),
	      store: processDefinitionsStore,
	      valueField: 'processDefId',
	      displayField: 'processDefName',
	      minChars: 0,
	      pageSize: 20,
	      emptyText: '*',
	      forceSelection: true,
	    },
	  ],
	
	  bbar: [
	    {
	      xtype: 'button',
	      itemId: 'newPermissionBtn',
	      text: Wizards.t('administration.permissions.new.button.add'),
	      iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
	      iconAlign: 'left',
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.administration.util.RadioField', {
	  extend: 'Ext.form.field.Radio',
	  xtype: 'attach-documents-radio',
	
	  iconSpanStyle: 'width:16px;height:16px;display:inline-block;margin-right:5px',
	
	  constructor: function (config) {
	    var iconCls = config.iconCls;
	
	    if (!Ext.isEmpty(iconCls)) {
	      this.beforeBoxLabelTextTpl = '<span style="' + this.iconSpanStyle + '" class="' + iconCls + '"></span>';
	    }
	    this.callParent(arguments);
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  pageSize: 20,
	  fields: [
	    'objectId',
	    'userName',
	    'fullName',
	    {
	      name: 'viewName',
	      convert: function (value, record) {
	        var userName = record.get('userName');
	        var fullName = record.get('fullName');
	
	        return Ext.isEmpty(fullName) ? userName : fullName + ' (' + userName + ')';
	      },
	    },
	  ],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('attach-documents').contextPath + '/api/users/query',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  pageSize: 20,
	  fields: ['name', 'objectId'],
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('attach-documents').contextPath + '/api/groups/query',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.create('Ext.data.Store', {
	  fields: ['processDefId', 'processDefName'],
	  pageSize: 20,
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('attach-documents').pluginContextPath + '/administration/processdefinitions',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {var store = __webpack_require__(12),
	  Renderers = __webpack_require__(14);
	
	module.exports = Ext.define('Wizards.attachdocuments.administration.permission.PermissionGrid', {
	  extend: 'Ext.grid.Panel',
	  xtype: 'attach-documents-admin-permission-grid',
	
	  title: Wizards.t('administration.permissions.grid.title'),
	
	  store: store,
	  columns: [
	    {
	      text: Wizards.t('administration.permissions.grid.column.resourcename'),
	      dataIndex: 'resourceName',
	      flex: 1,
	    },
	    {
	      text: Wizards.t('administration.permissions.grid.column.processdefname'),
	      dataIndex: 'processDefName',
	      flex: 1,
	    },
	    {
	      dataIndex: 'resourceType',
	      width: 50,
	      renderer: function (value) {
	        var type = value.toLowerCase(),
	          cls = type === 'user' ? 'dvnt-icon-user' : 'dvnt-icon-users',
	          qtip =
	            type === 'user'
	              ? Wizards.t('administration.permissions.grid.column.resourcetype.user')
	              : Wizards.t('administration.permissions.grid.column.resourcetype.group');
	        return Renderers.icon(cls, qtip);
	      },
	    },
	    {
	      xtype: 'actioncolumn',
	      width: 50,
	      items: [
	        {
	          iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
	          tooltip: Wizards.t('administration.permissions.grid.action.tooltip'),
	          scope: this,
	          handler: function (view, rowIndex, colIndex, item, e, record) {
	            Ext.Msg.confirm(
	              Wizards.t('administration.permissions.grid.action.message.title'),
	              Wizards.t('administration.permissions.grid.action.message.text', record.get('resourceName')),
	              function (buttonId) {
	                if (buttonId === 'yes') {
	                  view.fireEvent('deleteClick', record);
	                }
	              }
	            );
	          },
	        },
	      ],
	    },
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {__webpack_require__(13);
	
	module.exports = Ext.create('Ext.data.Store', {
	  model: 'Wizards.attachdocuments.administration.permissions.Permission',
	  autoLoad: true,
	  proxy: {
	    type: 'ajax',
	    url: Suncode.context('attach-documents').pluginContextPath + '/permissions',
	    reader: {
	      type: 'json',
	      root: 'data',
	    },
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.administration.permissions.Permission', {
	  extend: 'Ext.data.Model',
	
	  fields: [
	    {
	      name: 'id',
	      type: 'int',
	    },
	    'resourceType',
	    'resourceName',
	    'processDefName',
	  ],
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {Ext.define('Wizards.attachdocuments.administration.util.Renderers', {
	  singleton: true,
	
	  icon: function (iconCls, tooltip) {
	    return (
	      '<span ' +
	      'data-qtip="' +
	      tooltip +
	      '" ' +
	      'style="display: inline-block;width: 16px; height: 16px; padding:2px" ' +
	      'class ="' +
	      iconCls +
	      '"></span>'
	    );
	  },
	});
	
	module.exports = Wizards.attachdocuments.administration.util.Renderers;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Ext) {module.exports = Ext.define('Wizards.attachdocuments.administration.permissions.PermissionsController', {
	  extend: 'Ext.app.Controller',
	
	  refs: [
	    {
	      ref: 'permissionsGrid',
	      selector: 'attach-documents-admin-permission-grid',
	    },
	    {
	      ref: 'newPermissionForm',
	      selector: 'attach-documents-admin-permission-new',
	    },
	  ],
	
	  init: function () {
	    this.control({
	      'attach-documents-admin-permission-grid gridview': {
	        deleteClick: this.onDeleteClick,
	      },
	      'attach-documents-admin-permission-new #newPermissionBtn': {
	        click: this.newPermission,
	      },
	      'attach-documents-admin-permission-new #resourceTypeGroup': {
	        change: this.onResourceTypeGroupChange,
	      },
	    });
	  },
	
	  onDeleteClick: function (record) {
	    Ext.Ajax.request({
	      url: Suncode.context('attach-documents').pluginContextPath + '/permissions/' + record.get('id'),
	      scope: this,
	      method: 'DELETE',
	      success: function (response) {
	        this.manageResponse(
	          response,
	          function () {
	            this.getPermissionsGrid().getStore().load();
	          },
	          this
	        );
	      },
	      failure: function () {},
	    });
	  },
	
	  manageResponse: function (response, fn, scope) {
	    var me = this,
	      status = Ext.decode(response.responseText);
	
	    if (status.success) {
	      fn.call(scope ? scope : me);
	    } else {
	      Ext.Msg.alert(Wizards.t('basic.error'), status.message);
	    }
	  },
	
	  newPermission: function () {
	    var form = this.getNewPermissionForm().getForm();
	    this.savePermission(form, true);
	  },
	
	  savePermission: function (form, reset) {
	    if (form.isValid()) {
	      Ext.Ajax.request({
	        url: Suncode.context('attach-documents').pluginContextPath + '/permissions',
	        method: 'POST',
	        jsonData: form.getValues(),
	        scope: this,
	        success: function (response) {
	          this.manageResponse(
	            response,
	            function () {
	              this.getPermissionsGrid().getStore().load();
	              if (reset) {
	                form.reset();
	              }
	            },
	            this
	          );
	        },
	        failure: function () {
	          // TODO błąd serwera
	        },
	      });
	    }
	  },
	
	  onResourceTypeGroupChange: function (radioGroup, newValue) {
	    var form = this.getNewPermissionForm(),
	      userCombo = form.down('#userCombo'),
	      groupCombo = form.down('#groupCombo');
	
	    userCombo.setDisabled(newValue.resourceType != 'USER');
	    groupCombo.setDisabled(newValue.resourceType != 'GROUP');
	  },
	});
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(2)))

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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