/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.components.files;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.wizards.attachdocuments.DocumentToAttach;
import com.suncode.plugin.wizards.attachdocuments.components.files.FileUploadDataDto;
import com.suncode.plugin.wizards.attachdocuments.components.files.IndexDto;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/file"})
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @Transactional
    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<?> upload(@RequestParam List<MultipartFile> files, @RequestParam String fileDataArrayString) throws IOException {
        LinkedList<DocumentToAttach> documentsToAttach = new LinkedList<DocumentToAttach>();
        ObjectMapper objectMapper = new ObjectMapper();
        List filesData = (List)objectMapper.readValue(fileDataArrayString, (TypeReference)new TypeReference<List<FileUploadDataDto>>(){});
        for (int i = 0; i < files.size(); ++i) {
            FileUploadDataDto fileData = (FileUploadDataDto)filesData.get(i);
            try (InputStream fileInputStream = files.get(i).getInputStream();){
                DocumentDefinition documentDefinition = new DocumentDefinition(fileData.isSaveAsNewVersion());
                documentDefinition.setAttachToClosedActivities(true);
                documentDefinition.setDocumentClassId(Long.valueOf(fileData.getDocumentClassId()));
                documentDefinition.setUserName(UserContext.current().getUser().getUserName());
                documentDefinition.setInputStream(fileInputStream);
                documentDefinition.setFileName(files.get(i).getOriginalFilename());
                documentDefinition.setDescription(fileData.getDescription());
                HashMap<Long, Object> indexes = new HashMap<Long, Object>();
                for (IndexDto index : fileData.getIndexes()) {
                    indexes.put(index.getId(), index.getValue());
                }
                documentDefinition.setIndexes(indexes);
                AddDocumentResultMeta result = this.documentService.addDocumentWithMetaResult(documentDefinition);
                this.documentClassActionService.executeArchiveActions(result.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                if (result.getSavedAsNewVersion().booleanValue()) {
                    long parentId = result.getDocument().getVersion().getParentFile().getId();
                    documentsToAttach.removeIf(documentToAttach -> documentToAttach.getFileId() == parentId);
                }
                DocumentToAttach documentToAttach2 = new DocumentToAttach();
                documentToAttach2.setFileId(result.getDocument().getFile().getId());
                documentToAttach2.setDocumentClassId(fileData.getDocumentClassId());
                documentToAttach2.setCopyForEach(fileData.isCopyForEach());
                documentsToAttach.add(documentToAttach2);
                continue;
            }
        }
        return new ResponseEntity(documentsToAttach, (HttpStatusCode)HttpStatus.OK);
    }
}

