/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.administration;

import com.suncode.plugin.wizards.attachdocuments.administration.AuthorizationService;
import com.suncode.plugin.wizards.attachdocuments.administration.ProcessDefinitionDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"administration"})
public class AdministrationController {
    @Autowired
    private ProcessService processService;
    @Autowired
    private AuthorizationService authorizationService;

    @RequestMapping(value={""})
    public String administration() {
        this.authorizationService.assertFullAdministrationRights();
        return "administration";
    }

    @RequestMapping(value={"/processdefinitions"})
    @ResponseBody
    public CountedResult<ProcessDefinitionDto> getProcessDefinitions(@RequestParam String query, @RequestParam long start, @RequestParam long limit) {
        List allProcessTypes = this.processService.getAllProcessTypes(true);
        int count = allProcessTypes.size();
        List processDefinitionDtoList = allProcessTypes.stream().map(this::toProcessDefinitionDto).filter(processDefinitionDto -> StringUtils.startsWithIgnoreCase((CharSequence)processDefinitionDto.getProcessDefName(), (CharSequence)query)).sorted(Comparator.comparing(ProcessDefinitionDto::getProcessDefName)).skip(start).limit(limit).collect(Collectors.toList());
        return new CountedResult((long)count, processDefinitionDtoList);
    }

    private ProcessDefinitionDto toProcessDefinitionDto(ProcessType processType) {
        ProcessDefinitionDto processDefinitionDto = new ProcessDefinitionDto();
        processDefinitionDto.setProcessDefId(processType.getProcessDefId());
        processDefinitionDto.setProcessDefName(processType.getName());
        return processDefinitionDto;
    }
}

