/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.LocalizedMessage;
import com.suncode.plugin.framework.web.support.SectionCondition;
import com.suncode.plugin.wizards.Wizard;
import com.suncode.plugin.wizards.WizardImplementation;
import com.suncode.plugin.wizards.attachdocuments.AttachDocumentConfig;
import com.suncode.plugin.wizards.attachdocuments.AttachDocumentsTask;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.PermissionService;
import com.suncode.plugin.wizards.execution.config.WizardMenu;
import com.suncode.plugin.wizards.execution.config.process.ProcessUnit;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.workflow.search.SearchResultActionSection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachDocumentsWizard
implements WizardImplementation<AttachDocumentConfig, AttachDocumentsTask> {
    private static final Condition resultsCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.count() > 0;
        }
    };
    private static final Condition searchTypeCondition = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            return section.getSearchType() == SearchResultActionSection.SearchType.PROCESS || section.getSearchType() == SearchResultActionSection.SearchType.ACTIVITY;
        }
    };
    @Autowired
    private Plugin plugin;
    @Autowired
    private PermissionService permissionService;
    private final Condition hasRights = new SectionCondition<SearchResultActionSection>(){

        public boolean isFulfilled(SearchResultActionSection section) {
            String userName = UserContext.current().getUser().getUserName();
            return AttachDocumentsWizard.this.permissionService.hasUserPermission(userName, section);
        }
    };

    public Class<AttachDocumentConfig> configClass() {
        return AttachDocumentConfig.class;
    }

    public List<AttachDocumentsTask> createTasks(AttachDocumentConfig config) {
        List processUnits = config.getUnits();
        LinkedList<AttachDocumentsTask> tasks = new LinkedList<AttachDocumentsTask>();
        for (int i = 0; i < processUnits.size(); ++i) {
            tasks.add(new AttachDocumentsTask(config.getSearchType(), config.getDocumentsToAttach(), i == 0, (ProcessUnit)processUnits.get(i), config.getComment()));
        }
        return tasks;
    }

    public void createMenus(Wizard<AttachDocumentConfig, AttachDocumentsTask> wizard, WizardMenu builder) {
        builder.section("system.search.result.menu").add("attach-documents", new LocalizedMessage(this.plugin, "attachdocuments.menu.search.name", new Object[0]), new Condition[]{searchTypeCondition, resultsCondition, this.hasRights}).build();
    }
}

