/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.components.configuration;

import com.suncode.plugin.wizards.attachdocuments.components.configuration.DocumentClassDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/documentClass"})
public class DocumentClassController {
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessFinder processFinder;

    @ResponseBody
    @RequestMapping(value={"/processes"}, method={RequestMethod.POST})
    public List<DocumentClassDto> getAvailableDocumentClassesForProcesses(@RequestParam List<String> processesIds) {
        List processDefinitionIds = processesIds.stream().map(x$0 -> this.processService.getProcess(x$0, new String[0])).map(process -> process.getProcessDefinition().getProcessDefinitionId()).collect(Collectors.toCollection(LinkedList::new));
        return this.getAvailableDocumentClassesDto(processDefinitionIds);
    }

    @ResponseBody
    @RequestMapping(value={"/activities"}, method={RequestMethod.POST})
    public List<DocumentClassDto> getAvailableDocumentClassesForActivities(@RequestParam List<String> activitiesIds) {
        List processDefinitionIds = activitiesIds.stream().map(arg_0 -> ((ProcessFinder)this.processFinder).findProcessIdByActivityId(arg_0)).map(x$0 -> this.processService.getProcess(x$0, new String[0])).map(process -> process.getProcessDefinition().getProcessDefinitionId()).collect(Collectors.toCollection(LinkedList::new));
        return this.getAvailableDocumentClassesDto(processDefinitionIds);
    }

    private List<DocumentClassDto> getAvailableDocumentClassesDto(List<String> processesDefinitionIds) {
        List<DocumentClass> documentClasses = this.getDocumentClassesFromProcessesDefinitionId(processesDefinitionIds);
        return documentClasses.stream().map(DocumentClassDto::new).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<DocumentClass> getDocumentClassesFromProcessesDefinitionId(List<String> processesDefinitionIds) {
        String userName = SessionUtils.getLoggedUserName();
        List documentClassesList = processesDefinitionIds.stream().map(id -> this.documentClassService.getDocumentClassesForUserAndProcess(userName, id, true)).collect(Collectors.toCollection(LinkedList::new));
        List<DocumentClass> documentClasses = this.getIntersection(documentClassesList);
        documentClasses = this.addIndexesToDocumentClasses(documentClasses);
        return documentClasses;
    }

    private List<DocumentClass> getIntersection(List<List<DocumentClass>> documentClassesList) {
        List<DocumentClass> documentClasses = documentClassesList.get(0);
        List<Long> documentClassesIds = this.getDocumentClassesIds(documentClassesList.get(0));
        for (int i = 1; i < documentClassesList.size(); ++i) {
            documentClassesIds.retainAll(this.getDocumentClassesIds(documentClassesList.get(i)));
        }
        return documentClasses.stream().filter(documentClass -> documentClassesIds.contains(documentClass.getId())).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<Long> getDocumentClassesIds(List<DocumentClass> documentClasses) {
        return documentClasses.stream().map(DocumentClass::getId).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<DocumentClass> addIndexesToDocumentClasses(List<DocumentClass> documentClasses) {
        return documentClasses.stream().map(documentClass -> this.documentClassService.getDocumentClass(documentClass.getName(), new String[]{"indexes"})).collect(Collectors.toCollection(LinkedList::new));
    }
}

