/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.wizards.attachdocuments.administration.permission;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.wizards.attachdocuments.administration.AuthorizationService;
import com.suncode.plugin.wizards.attachdocuments.administration.Permission;
import com.suncode.plugin.wizards.attachdocuments.administration.Response;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.NewPermissionDto;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.PermissionDto;
import com.suncode.plugin.wizards.attachdocuments.administration.permission.PermissionService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"permissions"})
public class PermissionsController {
    private static final Logger log = LoggerFactory.getLogger(PermissionsController.class);
    @Autowired
    private Plugin plugin;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private AuthorizationService authorizationService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public CountedResult<PermissionDto> getAll() {
        this.authorizationService.assertFullAdministrationRights();
        List<PermissionDto> permissionDtoList = PermissionDto.from(this.permissionService.getAll(), this.permissionService);
        return new CountedResult((long)permissionDtoList.size(), permissionDtoList);
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public Response deletePermission(@PathVariable Long id) {
        this.authorizationService.assertFullAdministrationRights();
        try {
            Permission permission = this.permissionService.get(id);
            this.permissionService.delete(permission);
            return new Response(true);
        }
        catch (Exception e) {
            Translator t = Translators.get((String)this.plugin.getKey());
            log.error("Error writing deliting.", (Throwable)e);
            return new Response(false, t.getMessage("changeuser.permission.delete.error"));
        }
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public Response save(@RequestBody NewPermissionDto permissionDto) {
        this.authorizationService.assertFullAdministrationRights();
        try {
            this.permissionService.changePermissions(permissionDto);
            return new Response(true);
        }
        catch (Exception e) {
            Translator t = Translators.get((String)this.plugin.getKey());
            log.error("Error writing permission.", (Throwable)e);
            return new Response(false, t.getMessage("changeuser.permission.save.error"));
        }
    }
}

