<script type="text/javascript" src="${pluginContext.contextPath}/resources/lib/jquery.min.js"></script>

<link href="${pluginContext.contextPath}/resources/css/${skinPath}" rel="stylesheet" type="text/css"/>

<style>
    body {
        overflow: hidden;
        margin: 0;
    }

    html, body {
        height: 100%;
    }

    .welcome-gadget {
        height: 100%;
        border-radius: 16px;
        position: relative;
        text-align: center;
        word-wrap: break-word;
    }

    .orange-gradient {
        background: linear-gradient(92.12deg, #FF9900 0%, #EF7102 100%);
    }

    .orange-pale-gradient {
        background: linear-gradient(92.12deg, #FFae50 0%, #bd5e13 100%);
    }

    .blue-gradient {
        background: linear-gradient(92.12deg, #0b5eda 0%, #0048bb 100%);
    }

    .blue-active-gradient {
        background: linear-gradient(92.12deg, #004cbe 0%, #043a95 100%);
    }

    .gray-pale-gradient {
        background: linear-gradient(92.12deg, #cacccf 0%, #868689 100%);
    }

    .white-gradient {
        background: linear-gradient(92.12deg, #ffffff 0%, #e0dfdf 100%);
    }

    .red-gradient {
        background: linear-gradient(92.12deg, #f1472f 0%, #9c2b18 100%);
    }

    .green-gradient {
        background: linear-gradient(92.12deg, #01c768 0%, #008040 100%);
    }

    .green-pastel-gradient {
        background: linear-gradient(92.12deg, #78dc77 0%, #559e55 100%);
    }

    .blue-pale-gradient {
        background: linear-gradient(92.12deg, #703ffa 0%, #5230ba 100%);
    }

    .table-black-gradient {
        background: linear-gradient(92.12deg, #323c47 0%, #232c32 100%);
    }

    .table-black-active-gradient {
        background: linear-gradient(92.12deg, #232222 0%, #000000 100%);
    }

    .table-gray-gradient {
        background: linear-gradient(92.12deg, #ababab 0%, #8e8e8e 100%);
    }

    .dark-blue-gradient {
        background: linear-gradient(92.12deg, #334d6e 0%, #273d55 100%);
    }

    .gray-gradient {
        background: linear-gradient(92.12deg, #90a0b7 0%, #788599 100%);
    }

    .icon-gray-gradient {
        background: linear-gradient(92.12deg, #c2cfe0 0%, #a1acba 100%);
    }

    .table-text-gray-gradient {
        background: linear-gradient(92.12deg, #6b6b6b 0%, #494949 100%);
    }

    .orange-dim-gradient {
        background: linear-gradient(92.12deg, #ffc575 0%, #bd8a48 100%);
    }

    .purple-pale-gradient {
        background: linear-gradient(92.12deg, #906efa 0%, #6046b4 100%);
    }

    .purple-dim-gradient {
        background: linear-gradient(92.12deg, #ae95fc 0%, #6851a8 100%);
    }

    .blue-pastel-gradient {
        background: linear-gradient(92.12deg, #4a83e1 0%, #3463ab 100%);
    }

    .blue-dim-gradient {
        background: linear-gradient(92.12deg, #7aa4e9 0%, #5475a8 100%);
    }

    .yellow-gradient {
        background: linear-gradient(92.12deg, #f0da69 0%, #ab9a4a 100%);
    }

    .yellow-pale-gradient {
        background: linear-gradient(92.12deg, #f5e694 0%, #ab9f67 100%);
    }

    .yellow-dim-gradient {
        background: linear-gradient(92.12deg, #f3ecb1 0%, #a4a078 100%);
    }

    .green-pale-gradient {
        background: linear-gradient(92.12deg, #44d38a 0%, #329161 100%);
    }

    .green-dim-gradient {
        background: linear-gradient(92.12deg, #75dfaa 0%, #4a8669 100%);
    }

    .pink-gradient {
        background: linear-gradient(92.12deg, #f47362 0%, #ad5448 100%);
    }

    .pink-pale-gradient {
        background: linear-gradient(92.12deg, #f7998c 0%, #b67267 100%);
    }

    .pink-dim-gradient {
        background: linear-gradient(92.12deg, #fac1b9 0%, #bd938c 100%);
    }

    .blue-grey-gradient {
        background: linear-gradient(92.12deg, #2d4463 0%, #1d2c41 100%);
    }

    .blue-grey-pale-gradient {
        background: linear-gradient(92.12deg, #65778e 0%, #404a59 100%);
    }

    .welcome-gadget:hover {
        opacity: 0.6;
    }

    .welcome-gadget-inner {
        height: 100%;
        display: flex;
        justify-content: space-between;
        gap: 10px;
        align-items: center;
        padding-left: 38px;
        padding-right: 45px;
    }

    .welcome-gadget-left {
        text-align: left;
        font-weight: 400;
        font-size: 16px;
    }

    .welcome-gadget-avatar-wrapper {
        width: 110px;
        height: 110px;
        border-radius: 50%;
        filter: drop-shadow(0px 6px 5px rgba(0, 0, 0, 0.2));
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        top: -10px;
    }

    .welcome-gadget-avatar {
        width: 105px;
        height: 105px;
        border-radius: 50%;
    }

    .welcome-gadget-avatar-svg {
        position: absolute;
        background-repeat: no-repeat;
        background-size: contain;
    }

    .waves-svg {
        width: 40px;
        height: 40px;
        right: -10px;
        bottom: 6px;
        background-image: url(${pluginContext.pluginResourcesPath}/welcome-gadget/waves.svg)
    }

    .bulb-svg {
        width: 26px;
        height: 26px;
        right: -36px;
        bottom: 49px;
        background-image: url(${pluginContext.pluginResourcesPath}/welcome-gadget/light_bulb.svg)
    }

    .money-svg {
        width: 22px;
        height: 22px;
        right: -27px;
        bottom: -16px;
        background-image: url(${pluginContext.pluginResourcesPath}/welcome-gadget/money.svg)
    }

    .question-svg {
        width: 21px;
        height: 21px;
        right: -53px;
        bottom: 11px;
        background-image: url(${pluginContext.pluginResourcesPath}/welcome-gadget/question.svg)
    }

    .check-svg {
        width: 30px;
        height: 30px;
        right: -3px;
        bottom: 121px;
        background-image: url(${pluginContext.pluginResourcesPath}/welcome-gadget/check.svg)
    }
</style>

<a href="${pluginContext.contextPath}/ShowWorkListAction.do?activityState=New" target="_parent" style="text-decoration: none">
    <div class="welcome-gadget ${backgroundColor}-gradient">
        <div class="welcome-gadget-inner">
            <div class="welcome-gadget-left dvnt-font dvnt-white">
                <div>
                    <span>${pluginContext.getMessage("gadget.welcome-gadget.hello", [firstName])}</span>
                </div>
                <div>
                    <span class="welcome-gadget-new-activities-count"></span>
                </div>
            </div>
            <div class="welcome-gadget-right">
                <div class="welcome-gadget-avatar-wrapper dvnt-white-background">
                    <img class="welcome-gadget-avatar"
                         src="${pluginContext.contextPath}/api/users/avatar?userName=${username}&miniAvatar=false&cache=none">
                    <div class="welcome-gadget-avatar-svg waves-svg"></div>
                    <div class="welcome-gadget-avatar-svg bulb-svg"></div>
                    <div class="welcome-gadget-avatar-svg money-svg"></div>
                    <div class="welcome-gadget-avatar-svg question-svg"></div>
                    <div class="welcome-gadget-avatar-svg check-svg"></div>
                </div>
            </div>
        </div>
    </div>
</a>

<script>
  fetch("${pluginContext.contextPath}/api/activities/advanced/my/open/new/count")
    .then(response => response.json())
    .then(result => {
      let count = result;
      let rawText = '${pluginContext.getMessage("gadget.welcome-gadget.youHaveXNewActivities")}';
      let rawEmptyText = '${pluginContext.getMessage("gadget.welcome-gadget.youHaveNoNewActivities")}';
      let resultText = count === 0 ? rawEmptyText : rawText.replace('{0}', count);
      jQuery('.welcome-gadget-new-activities-count').text(resultText);
      window.top.dashboard.getGadgetCmp('${gadgetId}').onLoad();
    });

    // jeśli dashboard jest w trybie edycji to kliknięcie w gadżet nie powoduje przejścia
    jQuery('a').on('click', function () {
        return !window.top.dashboard.dashboardEditMode;
    });

</script>