/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.welcomegadget.controller;

import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.gadget.properties.TextProperty;
import com.suncode.plugin.dashboard.web.support.DynamicListResult;
import com.suncode.plugin.dashboard.web.support.GadgetControllerSupport;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.favourites.util.SessionUtils;
import com.suncode.pwfl.web.ui.DivanteColor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WelcomeGadgetController
extends GadgetControllerSupport {
    private static final List<DivanteColor> welcomeGadgetColors = Arrays.asList(DivanteColor.ORANGE, DivanteColor.ORANGE_PALE, DivanteColor.BLUE, DivanteColor.BLUE_ACTIVE, DivanteColor.GRAY_PALE, DivanteColor.RED, DivanteColor.GREEN, DivanteColor.BLUE_PALE, DivanteColor.TABLE_BLACK, DivanteColor.TABLE_BLACK_ACTIVE, DivanteColor.TABLE_GRAY, DivanteColor.DARK_BLUE, DivanteColor.GRAY, DivanteColor.ICON_GRAY, DivanteColor.TABLE_TEXT_GRAY);
    @Autowired
    private UserSettingsService userSettingsService;

    @RequestMapping(value={"gadget/welcome-gadget"}, method={RequestMethod.GET})
    public String showWelcomeGadget(Model model) {
        String firstName = this.getFirstName();
        model.addAttribute("firstName", (Object)firstName);
        model.addAttribute("username", (Object)UserContext.current().getUser().getUserName());
        Gadget gadget = this.getGadget();
        String backgroundColor = (String)((TextProperty)gadget.getProperty("backgroundColor", TextProperty.class)).getValue();
        DivanteColor divanteColor = StringUtils.isEmpty((CharSequence)backgroundColor) ? DivanteColor.ORANGE : DivanteColor.fromString((String)backgroundColor);
        model.addAttribute("backgroundColor", (Object)divanteColor.getCode());
        String username = SessionUtils.getCurrentUserName();
        model.addAttribute("skinPath", (Object)this.getSkinPath(username));
        return "welcome-gadget/view";
    }

    @ResponseBody
    @RequestMapping(value={"gadget/welcome-gadget/colors"}, method={RequestMethod.GET})
    public DynamicListResult getTileColors() {
        DynamicListResult colors = new DynamicListResult();
        List values = welcomeGadgetColors.stream().sorted(Comparator.comparing(Enum::toString)).collect(Collectors.toList());
        for (DivanteColor color : values) {
            colors.addEntry(color.getCode(), (Object)color.name());
        }
        return colors;
    }

    private String getFirstName() {
        UserInfo user = UserContext.current().getUser();
        String firstName = user.getFirstName();
        if (StringUtils.isNotBlank((CharSequence)firstName)) {
            return firstName;
        }
        return user.getUserName();
    }

    private String getSkinPath(String username) {
        return this.userSettingsService.getSkinForUser(username).getPath();
    }
}

