/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.support;

import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.favourites.util.SessionUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GadgetExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserSettingsService userSettingsService;

    @ExceptionHandler(value={Exception.class})
    public String handleException(HttpServletRequest request, Exception e) {
        this.logger.error("Request [{}] processing error - displaying error page", (Object)request.getRequestURI(), (Object)e);
        String username = SessionUtils.getCurrentUserName();
        request.setAttribute("skinPath", (Object)this.getSkinPath(username));
        return "error500";
    }

    private String getSkinPath(String username) {
        return this.userSettingsService.getSkinForUser(username).getPath();
    }
}

