/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.support;

import com.suncode.plugin.gadgets.support.PaginationInfo;
import javax.servlet.http.HttpServletRequest;
import org.displaytag.util.ParamEncoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DisplayTagPaginationParser {
    private String tableName;

    public DisplayTagPaginationParser(String tableName) {
        Assert.hasText((String)tableName, (String)"Table name must not be empty");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PaginationInfo getPagination(HttpServletRequest request) {
        ParamEncoder encoder = new ParamEncoder(this.tableName);
        String page = request.getParameter(encoder.encodeParameterName("p"));
        String sortType = request.getParameter(encoder.encodeParameterName("o"));
        String sortColumn = request.getParameter(encoder.encodeParameterName("s"));
        PaginationInfo info = new PaginationInfo();
        if (StringUtils.hasText((String)page)) {
            info.setPageNumber(Integer.parseInt(page));
        }
        if (StringUtils.hasText((String)sortType)) {
            info.setSortType(Integer.parseInt(sortType));
        }
        if (StringUtils.hasText((String)sortColumn)) {
            info.setColumnName(sortColumn);
        }
        return info;
    }
}

