/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.jasper;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportListVariableValueTable;
import com.plusmpm.database.ReportVariableTable;
import com.plusmpm.database.ReportsTable;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.gadget.properties.NumberProperty;
import com.suncode.plugin.dashboard.gadget.properties.TextProperty;
import com.suncode.plugin.dashboard.web.support.GadgetControllerSupport;
import com.suncode.plugin.gadgets.jasper.JasperReportDto;
import com.suncode.plugin.gadgets.jasper.JasperReportParameter;
import com.suncode.plugin.gadgets.util.JasperReportGadgetUtils;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.report.ReportService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.web.util.WebHtmlResourceHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/gadget/jasper-report"})
public class JasperReportGadgetController
extends GadgetControllerSupport {
    @Autowired
    private ReportService reportService;
    private static final String VIEW_REPORT = "jasper-report/report";
    private static final String VIEW_REPORT_MISSING = "jasper-report/reportmissing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String showJasperReport(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        ReportsTable report;
        Gadget gadget = this.getGadget();
        Long reportId = ((NumberProperty)gadget.getProperty("report", NumberProperty.class)).getValueAsLong();
        Long refreshInterval = ((NumberProperty)gadget.getProperty("refreshInterval", NumberProperty.class)).getValueAsLong();
        String reportParams = ((TextProperty)gadget.getProperty("params", TextProperty.class)).getRawValue();
        String user = SessionUtils.getLoggedUserName();
        DBManagement dbManagement = new DBManagement();
        ReportsTable reportsTable = report = reportId != null ? dbManagement.getReport(reportId.toString()) : null;
        if (report == null) {
            return VIEW_REPORT_MISSING;
        }
        Map<String, Object> reportParameters = JasperReportGadgetUtils.deserializeParameters(reportParams, user);
        JasperReport jasperReport = JasperCompileManager.compileReport((String)report.getReportDefinitionPath());
        Connection connection = DBUtils.connectToDB();
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportParameters, (Connection)connection);
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
        String printSessionName = "net.sf.jasperreports.j2ee.jasper_print" + gadget.getId();
        request.getSession().setAttribute(printSessionName, (Object)jasperPrint);
        String imageUriPattern = request.getContextPath() + "/servlets/image?jrprint=" + printSessionName + "&image={0}";
        HtmlExporter exporter = new HtmlExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleHtmlExporterOutput exporterOutput = new SimpleHtmlExporterOutput((Writer)response.getWriter());
        exporterOutput.setImageHandler((HtmlResourceHandler)new WebHtmlResourceHandler(imageUriPattern));
        exporter.setExporterOutput((ExporterOutput)exporterOutput);
        SimpleHtmlExporterConfiguration exporterConfiguration = new SimpleHtmlExporterConfiguration();
        exporterConfiguration.setHtmlHeader("<div id=\"config\"></div>");
        exporterConfiguration.setHtmlFooter(" ");
        exporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
        SimpleHtmlReportConfiguration reportConfiguration = new SimpleHtmlReportConfiguration();
        reportConfiguration.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        reportConfiguration.setWhitePageBackground(Boolean.valueOf(false));
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        exporter.exportReport();
        String translatedReportName = this.reportService.getReportTranslation(report.getId(), TranslatedFieldType.NAME);
        model.addAttribute("reportName", (Object)translatedReportName);
        model.addAttribute("refreshTime", (Object)refreshInterval);
        return VIEW_REPORT;
    }

    @RequestMapping(value={"/reports"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public CountedResult<JasperReportDto> getReports() throws Exception {
        List jasperReports = new DBManagement().getUserJasperReports(SessionUtils.getLoggedUserName());
        ArrayList<JasperReportDto> result = new ArrayList<JasperReportDto>();
        for (ReportsTable report : jasperReports) {
            JasperReportDto reportDto = new JasperReportDto(report.getId(), report.getReportName());
            reportDto.setParameters(this.getReportParams(report.getId()));
            result.add(reportDto);
        }
        return new CountedResult((long)result.size(), result);
    }

    @ResponseBody
    @RequestMapping(value={"/reports/{reportId}/parameters"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<JasperReportParameter> getReportParameters(@PathVariable Long reportId) {
        return this.getReportParams(reportId);
    }

    private List<JasperReportParameter> getReportParams(Long reportId) {
        DBManagement dbManagement = new DBManagement();
        ArrayList<JasperReportParameter> parameters = new ArrayList<JasperReportParameter>();
        List variables = dbManagement.GetAllVariableInReport(reportId.toString());
        for (ReportVariableTable variable : variables) {
            JasperReportParameter param = JasperReportParameter.create(variable);
            if (param.getType() == JasperReportParameter.ParameterType.LIST) {
                this.fillValues(param, dbManagement.GetAllListVariableValues(variable.getId()));
            }
            parameters.add(param);
        }
        return parameters;
    }

    private void fillValues(JasperReportParameter parameter, List<ReportListVariableValueTable> values) {
        for (ReportListVariableValueTable value : values) {
            parameter.getValues().put(value.getListValueId(), value.getListValueDisplay());
        }
    }
}

