/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.fastview;

import com.suncode.plugin.gadgets.fastview.ViewResultColumnWrapper;
import com.suncode.pwfl.workflow.view.ViewResultAction;
import com.suncode.pwfl.workflow.view.ViewResultColumn;
import com.suncode.pwfl.workflow.view.ViewResultColumnValue;
import com.suncode.pwfl.workflow.view.ViewResultRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ViewResultRowWrapper {
    private static final String JQUERY_TEMPLATE = "jQuery.ajax({{BODY_TEMPLATE}})";
    private static final String JQUERY_BODY_TEMPLATE = "url:\"{url}\",beforeSend:mask,complete:refresh";
    private ViewResultRow row;
    private List<ViewResultColumn> columnsDefinition;

    public ViewResultRowWrapper(ViewResultRow row, List<ViewResultColumn> columnsDefinition) {
        this.row = row;
        this.columnsDefinition = columnsDefinition;
    }

    public List<ViewResultColumnWrapper> getColumns() {
        ArrayList<ViewResultColumnWrapper> columns = new ArrayList<ViewResultColumnWrapper>();
        this.columnsDefinition.forEach(columnDefinition -> columns.add(ViewResultColumnWrapper.builder().columnDefinition((ViewResultColumn)columnDefinition).columnValue(this.getValues().get(columnDefinition.getId())).build()));
        return columns;
    }

    public String getActionsLink() {
        ArrayList links = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)this.row.getActions())) {
            this.row.getActions().forEach(action -> {
                if (action.getType() == ViewResultAction.ViewResultActionType.AbortActivity) {
                    links.add(this.buildAbortActivityLink((ViewResultAction)action));
                } else {
                    if (action.getType() == ViewResultAction.ViewResultActionType.OpenActivity) {
                        action.setParameter("redirect", "plugin/com.suncode.plugin-dashboard/");
                    }
                    if (action.getConfirmation().isPresent()) {
                        links.add(this.buildConfirmationLink((ViewResultAction)action));
                    } else {
                        links.add(this.buildLink((ViewResultAction)action));
                    }
                }
            });
        }
        return String.join((CharSequence)" | ", links);
    }

    private String buildAbortActivityLink(ViewResultAction action) {
        StringBuilder linkBuilder = new StringBuilder();
        linkBuilder.append("<a href=\"javascript://nop/\" onclick='javascript:abortActivity(\"").append(this.getProcessId()).append("\",\"").append(action.getLink()).append("\")'>").append(action.getName()).append("</a>");
        return linkBuilder.toString();
    }

    private String buildLink(ViewResultAction action) {
        StringBuilder linkBuilder = new StringBuilder();
        linkBuilder.append("<a href=\"").append(action.getLink()).append("\">").append(action.getName()).append("</a>");
        return linkBuilder.toString();
    }

    private String buildConfirmationLink(ViewResultAction action) {
        StringBuilder linkBuilder = new StringBuilder();
        linkBuilder.append("<a href=\"javascript://nop/\" onclick='javascript:return (confirm(\"").append((String)action.getConfirmation().get()).append("\"))?").append("(").append(this.buildAjaxRequest(action.getLink())).append(")").append(":(false)'>").append(action.getName()).append("</a>");
        return linkBuilder.toString();
    }

    private String buildAjaxRequest(String url) {
        return JQUERY_TEMPLATE.replace("{BODY_TEMPLATE}", JQUERY_BODY_TEMPLATE.replace("{url}", url));
    }

    public String getProcessId() {
        return this.row.getProcessId();
    }

    public String getProcessDefId() {
        return this.row.getProcessDefId();
    }

    public String getActivityId() {
        return this.row.getActivityId();
    }

    public String getActivityDefId() {
        return this.row.getActivityDefId();
    }

    public Map<String, ViewResultColumnValue> getValues() {
        return this.row.getValues();
    }

    public List<ViewResultAction> getActions() {
        return this.row.getActions();
    }

    public void setProcessId(String processId) {
        this.row.setProcessId(processId);
    }

    public void setProcessDefId(String processDefId) {
        this.row.setProcessDefId(processDefId);
    }

    public void setActivityId(String activityId) {
        this.row.setActivityId(activityId);
    }

    public void setActivityDefId(String activityDefId) {
        this.row.setActivityDefId(activityDefId);
    }

    public void setValues(Map<String, ViewResultColumnValue> values) {
        this.row.setValues(values);
    }

    public void setActions(List<ViewResultAction> actions) {
        this.row.setActions(actions);
    }
}

