/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.configurationTransfer;

import com.plusmpm.database.UserSearchViewTable;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.configuration.plugins.mapper.PluginConfigurationPropertiesMap;
import com.suncode.pwfl.configuration.plugins.mapper.PluginConfigurationPropertiesMapping;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationPropertiesMapper {
    @Autowired
    private Plugin plugin;

    public List<PluginConfigurationPropertiesMapping> getPropertiesMapping() {
        LinkedList<PluginConfigurationPropertiesMapping> propertiesMapping = new LinkedList<PluginConfigurationPropertiesMapping>();
        propertiesMapping.add(this.getViewsMapping());
        return propertiesMapping;
    }

    private PluginConfigurationPropertiesMapping getViewsMapping() {
        LinkedList<PluginConfigurationPropertiesMap> mapping = new LinkedList<PluginConfigurationPropertiesMap>();
        List<UserSearchViewTable> views = this.getAllViews();
        for (UserSearchViewTable view : views) {
            String uniqueName = view.getViewName() + PluginConfigurationPropertiesMap.PROPERTY_VALUE_SEPARATOR + view.getUserName();
            mapping.add(new PluginConfigurationPropertiesMap(view.getId().toString(), uniqueName));
        }
        String propertyName = this.plugin.getModule("fast-view").getKey().toString() + "-view";
        return new PluginConfigurationPropertiesMapping(propertyName, mapping);
    }

    public List<UserSearchViewTable> getAllViews() {
        return (List)TransactionWrapper.get().doInHibernateTransaction(session -> {
            DetachedCriteria dc = DetachedCriteria.forClass(UserSearchViewTable.class);
            return dc.getExecutableCriteria(session).list();
        });
    }
}

