/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.gadgets.fastview;

import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.gadget.properties.BooleanProperty;
import com.suncode.plugin.dashboard.gadget.properties.NumberProperty;
import com.suncode.plugin.dashboard.web.support.DynamicListResult;
import com.suncode.plugin.dashboard.web.support.GadgetControllerSupport;
import com.suncode.plugin.gadgets.fastview.ViewResultRowWrapper;
import com.suncode.plugin.gadgets.support.DisplayTagPaginationParser;
import com.suncode.plugin.gadgets.support.PaginationInfo;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.view.ViewFetchType;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.web.ui.DivanteColor;
import com.suncode.pwfl.web.ui.skin.Skin;
import com.suncode.pwfl.workflow.view.ViewEvaluator;
import com.suncode.pwfl.workflow.view.ViewResult;
import com.suncode.pwfl.workflow.view.ViewResultRow;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/gadget/fast-view"})
public class FastViewGadgetController
extends GadgetControllerSupport {
    private static final Logger log = LoggerFactory.getLogger(FastViewGadgetController.class);
    private static final String VIEW_RESULTS = "fast-view/view";
    private static final String VIEWS_TABLE_ID = "task";
    @Autowired
    private ViewEvaluator viewEvaluator;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private ViewService viewService;

    @RequestMapping
    public String displayView(@RequestParam(value="gadget") Long gadgetId, Model model, HttpServletRequest request, HttpSession session) {
        try {
            Gadget gadget = this.dashboardService.getGadget(gadgetId);
            Long viewId = ((NumberProperty)gadget.getProperty("view", NumberProperty.class)).getValueAsLong();
            Integer pageSize = ((NumberProperty)gadget.getProperty("pagesize", NumberProperty.class)).getValueAsInteger();
            pageSize = pageSize < 0 ? 25 : pageSize;
            Integer refreshInterval = ((NumberProperty)gadget.getProperty("refreshInterval", NumberProperty.class)).getValueAsInteger();
            Boolean titleCount = (Boolean)((BooleanProperty)gadget.getProperty("titleResultCount", BooleanProperty.class)).getValue();
            PaginationInfo pagination = new DisplayTagPaginationParser(VIEWS_TABLE_ID).getPagination(request);
            Integer offset = (pagination.getPageNumber() - 1) * pageSize;
            ViewDto view = this.viewService.getUserSearchView(viewId.toString());
            ViewResult results = this.viewEvaluator.evaluate(viewId, offset.intValue(), pageSize.intValue(), this.getSorter(pagination));
            if (results.isFailure()) {
                model.addAttribute("message", (Object)results.getFailureMessage().get());
                return "fast-view/nopermission";
            }
            model.addAttribute("gadgetId", (Object)gadget.getId().toString());
            model.addAttribute("gadget", (Object)gadget);
            model.addAttribute("views", this.wrapResult(results));
            model.addAttribute("size", (Object)((int)results.getTotal()));
            model.addAttribute("pageSize", (Object)pageSize);
            model.addAttribute("offset", (Object)offset);
            String translatedName = StringUtils.isNotBlank((CharSequence)view.getTranslatedName()) ? view.getTranslatedName() : view.getName();
            String viewTitle = StringEscapeUtils.escapeJavaScript((String)translatedName);
            model.addAttribute("title", (Object)(viewTitle + (String)(Boolean.TRUE.equals(titleCount) ? " <span class=\"dvnt-" + DivanteColor.BLUE.getCode() + "\">(" + results.getTotal() + ")</span>" : "")));
            model.addAttribute("refreshInterval", (Object)refreshInterval);
            model.addAttribute("skinPath", (Object)this.getSkinPath());
            model.addAttribute("viewId", (Object)viewId);
            model.addAttribute("message", (Object)this.defaultIfNull(session.getAttribute("message"), ""));
            model.addAttribute("messageType", (Object)this.defaultIfNull(session.getAttribute("processaction"), ""));
            session.removeAttribute("message");
            session.removeAttribute("processaction");
            return VIEW_RESULTS;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "fast-view/notfound";
        }
    }

    private List<ViewResultRowWrapper> wrapResult(ViewResult result) {
        return result.getData().stream().map(row -> new ViewResultRowWrapper((ViewResultRow)row, result.getColumns())).collect(Collectors.toList());
    }

    private String getSkinPath() {
        Skin skin;
        String userName = this.getCurrentUserName();
        if (userName != null && (skin = this.userSettingsService.getSkinForUser(userName)) != null) {
            return skin.getPath();
        }
        return this.userSettingsService.getDefaultSkin().getPath();
    }

    private Sorter getSorter(PaginationInfo pagination) {
        String columnName = pagination.getColumnName();
        if (StringUtils.isBlank((CharSequence)columnName)) {
            return null;
        }
        return new Sorter(columnName, pagination.getSortType() == 1 ? SortDirection.DESC : SortDirection.ASC);
    }

    @ResponseBody
    @RequestMapping(value={"/views"}, method={RequestMethod.GET})
    public DynamicListResult getUserViews() {
        DynamicListResult views = new DynamicListResult();
        String user = this.getCurrentUserName();
        if (user == null) {
            return views;
        }
        List userViews = this.viewService.getViews(ViewFetchType.PRIVATE);
        userViews.addAll(this.viewService.getViews(ViewFetchType.PUBLIC));
        for (ViewDto view : userViews) {
            String translatedName = StringUtils.isNotBlank((CharSequence)view.getTranslatedName()) ? view.getTranslatedName() : view.getName();
            views.addEntry(translatedName, (Object)view.getId());
        }
        return views;
    }

    private String getCurrentUserName() {
        if (UserContext.isActive()) {
            return UserContext.current().getUser().getUserName();
        }
        return null;
    }

    private <T> T defaultIfNull(T obj, T defaultObj) {
        return obj != null ? obj : defaultObj;
    }
}

