/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.upgrader_tasks;

import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.upgrader.change.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSystemProperties
implements Task {
    private static final Logger log = LoggerFactory.getLogger(AddSystemProperties.class);
    public static final String API_URL = "ApiUrl";
    public static final String LOGIN = "Login";
    public static final String PASSWORD = "Password";
    public static final String COMPANY_ID = "CompanyId";
    private final String[] parameters = new String[]{"ApiUrl", "Login", "Password", "CompanyId"};

    public void run() {
        try {
            Category category = new Category("PlusOCR");
            SystemParameterService service = ServiceFactory.getSystemParameterService();
            for (String param : this.parameters) {
                SystemParameter parameter = new SystemParameter(category, param.equals(PASSWORD) ? ParameterType.PASSWORD : ParameterType.TEXT, param);
                service.create(parameter);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void rollback() {
        SystemParameterService service = ServiceFactory.getSystemParameterService();
        for (String s : this.parameters) {
            SystemParameter parameter = service.getParameter(s);
            try {
                service.delete(parameter.getKey());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

