/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import com.suncode.plusocr.Categories;
import com.suncode.plusocr.alphamoon.domain.AlphamoonItemsTable;
import com.suncode.plusocr.alphamoon.domain.AlphamoonOcrData;
import com.suncode.plusocr.alphamoon.services.AlphamoonItemsTableService;
import com.suncode.plusocr.alphamoon.services.AlphamoonOcrDataService;
import com.suncode.plusocr.domain.OcrData;
import com.suncode.plusocr.domain.PositionRow;
import com.suncode.plusocr.services.OcrDataService;
import com.suncode.plusocr.services.PositionRowService;
import com.suncode.plusocr.tools.params.AlphamoonProcessMappingParams;
import com.suncode.plusocr.tools.params.ProcessMappingParams;
import com.suncode.plusocr.utils.CustomDateParser;
import com.suncode.plusocr.utils.OcrProvider;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Application
@ComponentsFormScript(value="scripts/dynamic-pwe/autotasks/process-mapping.js")
public class ProcessMapping {
    private static final Logger log = LoggerFactory.getLogger(ProcessMapping.class);
    private static final List<Character> ALLOWED_DECIMAL_SEPARATORS = Arrays.asList(Character.valueOf(','), Character.valueOf('.'));
    private final ObjectMapper objectMapper;
    private final String[] alphamoonParams = new String[]{"accountNumber", "bankName", "billingAddress", "billingEmail", "billingName", "billingVatNumber", "buyerEmail", "buyerId", "buyerName", "buyerAddress", "buyerPhone", "buyerVatNumber", "companyNumber", "currency", "deliveryDate", "iban", "invoiceDate", "invoiceNumber", "orderDate", "paymentDueDate", "paymentMethod", "paymentTerm", "purchaseOrderNumber", "receiverAddress", "receiverName", "receiverNip", "receiverPhone", "sellDate", "sellerAddress", "sellerEmail", "sellerName", "sellerPhone", "sellerVatNumber", "sellerWebsite", "sortCode", "swift", "totalAmount", "totalAmountDue", "totalNetAmount", "totalTaxAmount", "tableItemsUnit", "tableItemsAmount", "tableItemsPosition", "tableItemsQuantity", "tableItemsTaxRate", "tableItemsNetAmount", "tableItemsTaxAmount", "tableItemsUnitPrice", "tableItemsDescription", "tableItemsProductCode", "tableItemsNetUnitPrice", "tableItemsPurchaseOrderNumber"};
    @Autowired
    private OcrDataService ocrDataService;
    @Autowired
    private PositionRowService positionRowService;
    @Autowired
    private AlphamoonOcrDataService alphamoonOcrDataService;
    @Autowired
    private AlphamoonItemsTableService alphamoonItemsTableService;

    public ProcessMapping() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static double parseDouble(String value) {
        String formattedDouble = value.replaceAll("[^-0-9,.]", "");
        Character decimalSeparator = ProcessMapping.getDecimalSeparator(formattedDouble);
        if (decimalSeparator != null) {
            formattedDouble = formattedDouble.replaceAll("[^-0-9" + decimalSeparator + "]", "");
            formattedDouble = formattedDouble.replace(decimalSeparator.charValue(), '.');
        }
        return Double.parseDouble(formattedDouble);
    }

    public static LocalDate parseDate(String value) {
        return CustomDateParser.parseDate(value);
    }

    public static Integer parseInt(String value) {
        return (int)ProcessMapping.parseDouble(value);
    }

    private static Character getDecimalSeparator(String formattedDouble) {
        for (int i = formattedDouble.length() - 1; i >= 0; --i) {
            char character = formattedDouble.charAt(i);
            if (!ALLOWED_DECIMAL_SEPARATORS.contains(Character.valueOf(character))) continue;
            return Character.valueOf(character);
        }
        return null;
    }

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("skanujto-mapping")).name("application.skanujto.mapping")).description("application.skanujto.mapping.desc")).icon((Icon)SilkIconPack.APPLICATION_FORM)).category(new Category[]{Categories.SCANNING})).parameter().id("provider").name("application.parameter.provider.name").description("application.parameter.provider.desc").type((Type)Types.STRING).defaultValue((Object)OcrProvider.SKANUJ_TO.name()).create()).parameter().id("interrupt").name("application.parameter.interrupt.name").description("application.parameter.interrupt.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("nr_faktury").name("application.parameter.invoiceno.name").description("application.parameter.invoiceno.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("sprzedawca_nazwa").name("application.parameter.supplier.name.name").description("application.parameter.supplier.name.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("sprzedawca_nip").name("application.parameter.supplier.vatid.name").description("application.parameter.supplier.vatid.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("sprzedawca_adres").name("application.parameter.supplier.address.name").description("application.parameter.supplier.address.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("sprzedawca_kod").name("application.parameter.supplier.zipcode.name").description("application.parameter.supplier.zipcode.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("sprzedawca_miejscowosc").name("application.parameter.supplier.city.name").description("application.parameter.supplier.city.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("nabywca_nazwa").name("application.parameter.purchaser.name.name").description("application.parameter.purchaser.name.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("nabywca_nip").name("application.parameter.purchaser.vatid.name").description("application.parameter.purchaser.vatid.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("nabywca_adres").name("application.parameter.purchaser.address.name").description("application.parameter.purchaser.address.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("nabywca_kod").name("application.parameter.purchaser.zipcode.name").description("application.parameter.purchaser.zipcode.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("nabywca_miejscowosc").name("application.parameter.purchaser.city.name").description("application.parameter.purchaser.city.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("data_sprzedazy").name("application.parameter.salesdate.name").description("application.parameter.salesdate.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("data_wystawienia").name("application.parameter.invoicedate.name").description("application.parameter.invoicedate.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("termin_platnosci").name("application.parameter.paymentdate.name").description("application.parameter.paymentdate.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("sposob_platnosci").name("application.parameter.paymentmethod.name").description("application.parameter.paymentmethod.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("waluta").name("application.parameter.currency.name").description("application.parameter.currency.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("razem_netto").name("application.parameter.netvalue.name").description("application.parameter.netvalue.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("razem_vat").name("application.parameter.taxvalue.name").description("application.parameter.taxvalue.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("razem_brutto").name("application.parameter.grossvalue.name").description("application.parameter.grossvalue.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("miesiac_ksiegowy").name("application.parameter.accounting_month.name").description("application.parameter.accounting_month.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("konto_bankowe").name("application.parameter.bankaccountno.name").description("application.parameter.bankaccountno.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("zaplacono").name("application.parameter.paid.name").description("application.parameter.paid.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("data_wplywu").name("application.parameter.receiptdate.name").description("application.parameter.receiptdate.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("czy_niekompletna_pozycja").name("application.parameter.iscomplete.name").description("application.parameter.iscomplete.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("netto_waluta_podstawowa").name("application.parameter.netvaluecurrency.name").description("application.parameter.netvaluecurrency.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("brutto_waluta_podstawowa").name("application.parameter.grossvaluecurrency.name").description("application.parameter.grossvaluecurrency.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("vat_waluta_podstawowa").name("application.parameter.taxvaluecurrency.name").description("application.parameter.taxvaluecurrency.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("nr_zamowienia").name("application.parameter.orderno.name").description("application.parameter.orderno.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("kategoria").name("application.parameter.categoryname.name").description("application.parameter.categoryname.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("category_id").name("application.parameter.categoryid.name").description("application.parameter.categoryid.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("category_desc").name("application.parameter.categorydesc.name").description("application.parameter.categorydesc.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("kurs_waluty").name("application.parameter.currency_rate.name").description("application.parameter.currency_rate.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("korygujaca").name("application.parameter.is_correcting.name").description("application.parameter.is_correcting.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("faktura_korygowana").name("application.parameter.corrected_invoice.name").description("application.parameter.corrected_invoice.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("przyczyna_korekty").name("application.parameter.correction_reason.name").description("application.parameter.correction_reason.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("description").name("application.parameter.description.name").description("application.parameter.description.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("podzielona_platnosc").name("application.parameter.podzielona_platnosc.name").description("application.parameter.podzielona_platnosc.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_nazwa").name("application.parameter.name_pos.name").description("application.parameter.name_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_ilosc").name("application.parameter.qantity_pos.name").description("application.parameter.qantity_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_jednostka").name("application.parameter.unit_pos.name").description("application.parameter.unit_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_cena").name("application.parameter.price_pos.name").description("application.parameter.price_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_netto").name("application.parameter.netvalue_pos.name").description("application.parameter.netvalue_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_brutto").name("application.parameter.grossvalue_pos.name").description("application.parameter.grossvalue_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_staw_vat").name("application.parameter.vat_rate_pos.name").description("application.parameter.vat_rate_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("pozycja_vat").name("application.parameter.vat_pos.name").description("application.parameter.vat_pos.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("alphamoon.customFieldIds").name("application.parameter.alphamoon.customFieldIds.name").description("application.parameter.alphamoon.customFieldIds.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("alphamoon.customFieldVariables").name("application.parameter.alphamoon.customFieldVariables.name").description("application.parameter.alphamoon.customFieldVariables.desc").type((Type)Types.VARIABLE_ARRAY).optional().create();
        Arrays.stream(this.alphamoonParams).forEach(key -> {
            ApplicationDefinitionBuilder cfr_ignored_0 = (ApplicationDefinitionBuilder)builder.parameter().id("alphamoon." + key).name("application.parameter.alphamoon." + key + ".name").description("application.parameter.alphamoon." + key + ".desc").type((Type)Types.VARIABLE).optional().create();
        });
    }

    public void execute(ApplicationContext applicationContext, Parameters parameters) throws AcceptanceException {
        String provider = (String)parameters.get("provider", String.class);
        if (!EnumUtils.isValidEnum(OcrProvider.class, (String)provider)) {
            throw new AcceptanceException("Invalid OCR provider selected!");
        }
        OcrProvider ocrProvider = OcrProvider.valueOf(provider);
        switch (ocrProvider) {
            case SKANUJ_TO: {
                this.skanujToMapping(applicationContext, parameters);
                break;
            }
            case ALPHAMOON_AI: {
                this.alphamoonMapping(applicationContext, parameters);
            }
        }
    }

    private void skanujToMapping(ApplicationContext applicationContext, Parameters parameters) {
        try {
            ProcessMappingParams processMappingParams = new ProcessMappingParams(parameters);
            OcrData ocrData = this.ocrDataService.get(applicationContext.getProcessId());
            LinkedHashMap<Variable, String> mapOfVariablesAndValues = new LinkedHashMap<Variable, String>();
            mapOfVariablesAndValues.put(processMappingParams.getNr_faktury(), ocrData.getNrFaktury());
            mapOfVariablesAndValues.put(processMappingParams.getSprzedawca_nazwa(), ocrData.getSprzedawcaNazwa());
            mapOfVariablesAndValues.put(processMappingParams.getSprzedawca_nip(), ocrData.getSprzedawcaNip());
            mapOfVariablesAndValues.put(processMappingParams.getSprzedawca_adres(), ocrData.getSprzedawcaAdres());
            mapOfVariablesAndValues.put(processMappingParams.getSprzedawca_kod(), ocrData.getSprzedawcaKod());
            mapOfVariablesAndValues.put(processMappingParams.getSprzedawca_miejscowosc(), ocrData.getSprzedawcaMiejscowosc());
            mapOfVariablesAndValues.put(processMappingParams.getNabywca_nazwa(), ocrData.getNabywcaNazwa());
            mapOfVariablesAndValues.put(processMappingParams.getNabywca_nip(), ocrData.getNabywcaNip());
            mapOfVariablesAndValues.put(processMappingParams.getNabywca_adres(), ocrData.getNabywcaAdres());
            mapOfVariablesAndValues.put(processMappingParams.getNabywca_kod(), ocrData.getNabywcaKod());
            mapOfVariablesAndValues.put(processMappingParams.getNabywca_miejscowosc(), ocrData.getNabywcaMiejscowosc());
            mapOfVariablesAndValues.put(processMappingParams.getSposob_platnosci(), ocrData.getSposobPlatnosci());
            mapOfVariablesAndValues.put(processMappingParams.getWaluta(), ocrData.getWaluta());
            mapOfVariablesAndValues.put(processMappingParams.getMiesiac_ksiegowy(), ocrData.getMiesiacKsiegowy());
            mapOfVariablesAndValues.put(processMappingParams.getKonto_bankowe(), ocrData.getKontoBankowe());
            mapOfVariablesAndValues.put(processMappingParams.getZaplacono(), ocrData.getZaplacono());
            mapOfVariablesAndValues.put(processMappingParams.getCzy_niekompletna_pozycja(), ocrData.getCzyNiekompletnaPozycja());
            mapOfVariablesAndValues.put(processMappingParams.getNr_zamowienia(), ocrData.getNrZamowienia());
            mapOfVariablesAndValues.put(processMappingParams.getKategoria(), ocrData.getKategoria());
            mapOfVariablesAndValues.put(processMappingParams.getCategory_id(), ocrData.getKategoriaId());
            mapOfVariablesAndValues.put(processMappingParams.getCategory_desc(), ocrData.getCategoryDesc());
            mapOfVariablesAndValues.put(processMappingParams.getKorygujaca(), ocrData.getKorygujaca());
            mapOfVariablesAndValues.put(processMappingParams.getFaktura_korygowana(), ocrData.getFakturaKorygowana());
            mapOfVariablesAndValues.put(processMappingParams.getPrzyczyna_korekty(), ocrData.getPrzyczynaKorekty());
            mapOfVariablesAndValues.put(processMappingParams.getDescription(), ocrData.getDescription());
            mapOfVariablesAndValues.put(processMappingParams.getData_sprzedazy(), ocrData.getDataSprzedazy());
            mapOfVariablesAndValues.put(processMappingParams.getData_wystawienia(), ocrData.getDataWystawienia());
            mapOfVariablesAndValues.put(processMappingParams.getTermin_platnosci(), ocrData.getTerminPlatnosci());
            mapOfVariablesAndValues.put(processMappingParams.getData_wplywu(), ocrData.getDataWplywu());
            mapOfVariablesAndValues.put(processMappingParams.getRazem_netto(), ocrData.getRazemNetto());
            mapOfVariablesAndValues.put(processMappingParams.getRazem_vat(), ocrData.getRazemVat());
            mapOfVariablesAndValues.put(processMappingParams.getRazem_brutto(), ocrData.getRazemBrutto());
            mapOfVariablesAndValues.put(processMappingParams.getNetto_waluta_podstawowa(), ocrData.getNettoWalutaPodstawowa());
            mapOfVariablesAndValues.put(processMappingParams.getBrutto_waluta_podstawowa(), ocrData.getBruttoWalutaPodstawowa());
            mapOfVariablesAndValues.put(processMappingParams.getVat_waluta_podstawowa(), ocrData.getVatWalutaPodstawowa());
            mapOfVariablesAndValues.put(processMappingParams.getKurs_waluty(), ocrData.getKursWaluty());
            mapOfVariablesAndValues.put(processMappingParams.getPodzielona_platnosc(), String.valueOf(ocrData.getPodzielonaPlatnosc().equals("1")));
            mapOfVariablesAndValues.keySet().removeIf(Objects::isNull);
            mapOfVariablesAndValues.forEach((variable, value) -> {
                try {
                    this.assignValueToVariable((Variable)variable, (String)value);
                }
                catch (Exception ex) {
                    if (Boolean.TRUE.equals(processMappingParams.getInterrupt())) {
                        throw ex;
                    }
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            });
            ArrayList<Object> pozycjaNazwaList = new ArrayList<Object>();
            ArrayList<Object> pozycjaIloscList = new ArrayList<Object>();
            ArrayList<Object> pozycjaJednostkaList = new ArrayList<Object>();
            ArrayList<Object> pozycjaCenaList = new ArrayList<Object>();
            ArrayList<Object> pozycjaNettoList = new ArrayList<Object>();
            ArrayList<Object> pozycjaBruttoList = new ArrayList<Object>();
            ArrayList<Object> pozycjaStawkaVATList = new ArrayList<Object>();
            ArrayList<Object> pozycjaVATList = new ArrayList<Object>();
            List<PositionRow> positions = this.positionRowService.getByDataId(ocrData.getId());
            for (PositionRow position : positions) {
                this.addValueToList(pozycjaNazwaList, processMappingParams.getPozycja_nazwa(), position.getpNazwa());
                this.addValueToList(pozycjaIloscList, processMappingParams.getPozycja_ilosc(), position.getpIlosc());
                this.addValueToList(pozycjaJednostkaList, processMappingParams.getPozycja_jednostka(), position.getpJednostka());
                this.addValueToList(pozycjaCenaList, processMappingParams.getPozycja_cena(), position.getpCena());
                this.addValueToList(pozycjaNettoList, processMappingParams.getPozycja_netto(), position.getpNetto());
                this.addValueToList(pozycjaBruttoList, processMappingParams.getPozycja_brutto(), position.getpBrutto());
                this.addValueToList(pozycjaStawkaVATList, processMappingParams.getPozycja_staw_vat(), position.getpStawkaVAT());
                this.addValueToList(pozycjaVATList, processMappingParams.getPozycja_vat(), position.getpVAT());
            }
            LinkedHashMap<Variable, List> mapOfArrayVariablesAndValue = new LinkedHashMap<Variable, List>();
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_nazwa(), pozycjaNazwaList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_ilosc(), pozycjaIloscList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_jednostka(), pozycjaJednostkaList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_cena(), pozycjaCenaList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_netto(), pozycjaNettoList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_brutto(), pozycjaBruttoList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_staw_vat(), pozycjaStawkaVATList);
            mapOfArrayVariablesAndValue.put(processMappingParams.getPozycja_vat(), pozycjaVATList);
            mapOfArrayVariablesAndValue.keySet().removeIf(Objects::isNull);
            mapOfArrayVariablesAndValue.forEach(this::assignListToVariable);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void alphamoonMapping(ApplicationContext applicationContext, Parameters parameters) throws AcceptanceException {
        try {
            AlphamoonProcessMappingParams processMappingParams = new AlphamoonProcessMappingParams(parameters);
            AlphamoonOcrData ocrData = (AlphamoonOcrData)this.alphamoonOcrDataService.get(applicationContext.getProcessId());
            Map<Variable, String> mapOfVariablesAndValues = this.createMapOfVariablesAndValuesToSetForAlphamoon(processMappingParams, ocrData);
            mapOfVariablesAndValues.forEach((variable, value) -> {
                try {
                    this.assignValueToVariable((Variable)variable, (String)value);
                }
                catch (Exception ex) {
                    if (Boolean.TRUE.equals(processMappingParams.getInterrupt())) {
                        throw ex;
                    }
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            });
            ArrayList<Object> unitList = new ArrayList<Object>();
            ArrayList<Object> amountList = new ArrayList<Object>();
            ArrayList<Object> positionList = new ArrayList<Object>();
            ArrayList<Object> quantityList = new ArrayList<Object>();
            ArrayList<Object> taxRateList = new ArrayList<Object>();
            ArrayList<Object> netAmountList = new ArrayList<Object>();
            ArrayList<Object> taxAmountList = new ArrayList<Object>();
            ArrayList<Object> unitPriceList = new ArrayList<Object>();
            ArrayList<Object> descriptionList = new ArrayList<Object>();
            ArrayList<Object> productCodeList = new ArrayList<Object>();
            ArrayList<Object> netUnitPriceList = new ArrayList<Object>();
            HashMap<String, List> customTabularFields = new HashMap<String, List>();
            processMappingParams.getCustomFieldParams().entrySet().stream().filter(customFieldParam -> ((Variable)customFieldParam.getValue()).isArray()).forEach(customFieldParam -> {
                List cfr_ignored_0 = customTabularFields.put((String)customFieldParam.getKey(), new ArrayList());
            });
            List<AlphamoonItemsTable> positions = this.alphamoonItemsTableService.getByDataId(ocrData.getId());
            for (AlphamoonItemsTable position : positions) {
                this.addValueToList(unitList, processMappingParams.getTableItemsUnit(), Strings.nullToEmpty((String)position.getUnit()));
                this.addValueToList(amountList, processMappingParams.getTableItemsAmount(), Strings.nullToEmpty((String)position.getAmount()));
                this.addValueToList(positionList, processMappingParams.getTableItemsPosition(), Strings.nullToEmpty((String)position.getPosition()));
                this.addValueToList(quantityList, processMappingParams.getTableItemsQuantity(), Strings.nullToEmpty((String)position.getQuantity()));
                this.addValueToList(taxRateList, processMappingParams.getTableItemsTaxRate(), Strings.nullToEmpty((String)position.getTaxRate()));
                this.addValueToList(netAmountList, processMappingParams.getTableItemsNetAmount(), Strings.nullToEmpty((String)position.getNetAmount()));
                this.addValueToList(taxAmountList, processMappingParams.getTableItemsTaxAmount(), Strings.nullToEmpty((String)position.getTaxAmount()));
                this.addValueToList(unitPriceList, processMappingParams.getTableItemsUnitPrice(), Strings.nullToEmpty((String)position.getUnitPrice()));
                this.addValueToList(descriptionList, processMappingParams.getTableItemsDescription(), Strings.nullToEmpty((String)position.getDescription()));
                this.addValueToList(productCodeList, processMappingParams.getTableItemsProductCode(), Strings.nullToEmpty((String)position.getProductCode()));
                this.addValueToList(netUnitPriceList, processMappingParams.getTableItemsNetUnitPrice(), Strings.nullToEmpty((String)position.getNetUnitPrice()));
                Map<String, String> extraData = this.convertJsonToMap(position.getExtraData());
                customTabularFields.forEach((id, values) -> this.addValueToList((List<Object>)values, processMappingParams.getCustomFieldParams().get(id), (String)extraData.get(id)));
            }
            LinkedHashMap<Variable, List> mapOfArrayVariablesAndValues = new LinkedHashMap<Variable, List>();
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsUnit(), unitList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsAmount(), amountList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsPosition(), positionList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsQuantity(), quantityList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsTaxRate(), taxRateList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsNetAmount(), netAmountList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsTaxAmount(), taxAmountList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsUnitPrice(), unitPriceList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsDescription(), descriptionList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsProductCode(), productCodeList);
            mapOfArrayVariablesAndValues.put(processMappingParams.getTableItemsNetUnitPrice(), netUnitPriceList);
            customTabularFields.forEach((id, values) -> mapOfArrayVariablesAndValues.put(processMappingParams.getCustomFieldParams().get(id), (List)values));
            mapOfArrayVariablesAndValues.keySet().removeIf(Objects::isNull);
            mapOfArrayVariablesAndValues.forEach(this::assignListToVariable);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new AcceptanceException((Throwable)ex);
        }
    }

    private Map<Variable, String> createMapOfVariablesAndValuesToSetForAlphamoon(AlphamoonProcessMappingParams processMappingParams, AlphamoonOcrData ocrData) {
        LinkedHashMap<Variable, String> mapOfVariablesAndValues = new LinkedHashMap<Variable, String>();
        mapOfVariablesAndValues.put(processMappingParams.getAccountNumber(), ocrData.getAccountNumber());
        mapOfVariablesAndValues.put(processMappingParams.getBankName(), ocrData.getBankName());
        mapOfVariablesAndValues.put(processMappingParams.getBillingAddress(), ocrData.getBillingAddress());
        mapOfVariablesAndValues.put(processMappingParams.getBillingEmail(), ocrData.getBillingEmail());
        mapOfVariablesAndValues.put(processMappingParams.getBillingName(), ocrData.getBillingName());
        mapOfVariablesAndValues.put(processMappingParams.getBillingVatNumber(), ocrData.getBillingVatNumber());
        mapOfVariablesAndValues.put(processMappingParams.getBuyerEmail(), ocrData.getBuyerEmail());
        mapOfVariablesAndValues.put(processMappingParams.getBuyerId(), ocrData.getBuyerId());
        mapOfVariablesAndValues.put(processMappingParams.getBuyerName(), ocrData.getBuyerName());
        mapOfVariablesAndValues.put(processMappingParams.getBuyerAddress(), ocrData.getBuyerAddress());
        mapOfVariablesAndValues.put(processMappingParams.getBuyerPhone(), ocrData.getBuyerPhone());
        mapOfVariablesAndValues.put(processMappingParams.getBuyerVatNumber(), ocrData.getBuyerVatNumber());
        mapOfVariablesAndValues.put(processMappingParams.getCompanyNumber(), ocrData.getCompanyNumber());
        mapOfVariablesAndValues.put(processMappingParams.getCurrency(), ocrData.getCurrency());
        mapOfVariablesAndValues.put(processMappingParams.getDeliveryDate(), ocrData.getDeliveryDate());
        mapOfVariablesAndValues.put(processMappingParams.getIban(), ocrData.getIban());
        mapOfVariablesAndValues.put(processMappingParams.getInvoiceDate(), ocrData.getInvoiceDate());
        mapOfVariablesAndValues.put(processMappingParams.getInvoiceNumber(), ocrData.getInvoiceNumber());
        mapOfVariablesAndValues.put(processMappingParams.getOrderDate(), ocrData.getOrderDate());
        mapOfVariablesAndValues.put(processMappingParams.getPaymentDueDate(), ocrData.getPaymentDueDate());
        mapOfVariablesAndValues.put(processMappingParams.getPaymentMethod(), ocrData.getPaymentMethod());
        mapOfVariablesAndValues.put(processMappingParams.getPaymentTerm(), ocrData.getPaymentTerm());
        mapOfVariablesAndValues.put(processMappingParams.getPurchaseOrderNumber(), ocrData.getPurchaseOrderNumber());
        mapOfVariablesAndValues.put(processMappingParams.getReceiverAddress(), ocrData.getReceiverAddress());
        mapOfVariablesAndValues.put(processMappingParams.getReceiverName(), ocrData.getReceiverName());
        mapOfVariablesAndValues.put(processMappingParams.getReceiverNip(), ocrData.getReceiverNip());
        mapOfVariablesAndValues.put(processMappingParams.getReceiverPhone(), ocrData.getReceiverPhone());
        mapOfVariablesAndValues.put(processMappingParams.getSellDate(), ocrData.getSellDate());
        mapOfVariablesAndValues.put(processMappingParams.getSellerAddress(), ocrData.getSellerAddress());
        mapOfVariablesAndValues.put(processMappingParams.getSellerEmail(), ocrData.getSellerEmail());
        mapOfVariablesAndValues.put(processMappingParams.getSellerName(), ocrData.getSellerName());
        mapOfVariablesAndValues.put(processMappingParams.getSellerPhone(), ocrData.getSellerPhone());
        mapOfVariablesAndValues.put(processMappingParams.getSellerVatNumber(), ocrData.getSellerVatNumber());
        mapOfVariablesAndValues.put(processMappingParams.getSellerWebsite(), ocrData.getSellerWebsite());
        mapOfVariablesAndValues.put(processMappingParams.getSortCode(), ocrData.getSortCode());
        mapOfVariablesAndValues.put(processMappingParams.getSwift(), ocrData.getSwift());
        mapOfVariablesAndValues.put(processMappingParams.getTotalAmount(), ocrData.getTotalAmount());
        mapOfVariablesAndValues.put(processMappingParams.getTotalAmountDue(), ocrData.getTotalAmountDue());
        mapOfVariablesAndValues.put(processMappingParams.getTotalNetAmount(), ocrData.getTotalNetAmount());
        mapOfVariablesAndValues.put(processMappingParams.getTotalTaxAmount(), ocrData.getTotalTaxAmount());
        try {
            Map<String, String> extraData = this.convertJsonToMap(ocrData.getExtraData());
            processMappingParams.getCustomFieldParams().entrySet().stream().filter(entry -> !((Variable)entry.getValue()).isArray()).forEach(entry -> {
                String cfr_ignored_0 = (String)mapOfVariablesAndValues.put((Variable)entry.getValue(), (String)extraData.get(entry.getKey()));
            });
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
        }
        mapOfVariablesAndValues.keySet().removeIf(Objects::isNull);
        return mapOfVariablesAndValues;
    }

    private Map<String, String> convertJsonToMap(String json) throws JsonProcessingException {
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        return (Map)this.objectMapper.readValue(json, (TypeReference)typeRef);
    }

    private Object convertTypes(String value, Type<?> type) {
        if (type == Types.STRING || type == Types.STRING_ARRAY) {
            return value.trim();
        }
        if (type == Types.DATE || type == Types.DATETIME) {
            return ProcessMapping.parseDate(value);
        }
        if (type == Types.FLOAT || type == Types.FLOAT_ARRAY) {
            return ProcessMapping.parseDouble(value);
        }
        if (type == Types.BOOLEAN) {
            return Boolean.valueOf(value);
        }
        if (type == Types.INTEGER || type == Types.INTEGER_ARRAY) {
            return ProcessMapping.parseInt(value);
        }
        return value;
    }

    private void addValueToList(List<Object> list, Variable variable, String value) {
        try {
            if (variable != null) {
                list.add(this.convertTypes(value, variable.getType()));
            }
        }
        catch (Exception ex) {
            log.info("Could not add value '" + value + "' to list for variable '" + variable.getName() + "'");
        }
    }

    private void assignValueToVariable(Variable variable, String value) {
        try {
            if (value != null) {
                variable.setValue(this.convertTypes(value, variable.getType()));
            }
        }
        catch (Exception ex) {
            log.error("Cannot assign value '" + value + "' to variable '" + variable.getName() + "' because of type mismatch. Assigning default value instead");
            Type type = variable.getType();
            variable.setValue(type.defaultValue());
            log.error(ex.getMessage());
        }
    }

    private void assignListToVariable(Variable variable, List<Object> list) {
        try {
            Type type = variable.getType();
            if (type == Types.STRING_ARRAY) {
                variable.setValue((Object)list.toArray(new String[0]));
            } else if (type == Types.FLOAT_ARRAY) {
                variable.setValue((Object)list.toArray(new Double[0]));
            } else if (type == Types.INTEGER_ARRAY) {
                variable.setValue((Object)list.toArray(new Integer[0]));
            }
        }
        catch (Exception ex) {
            log.error("Cannot set variable '" + variable.getName() + "' because of type mismatch");
            log.error(ex.getMessage());
        }
    }
}

