/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plusocr.suncodeocr.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.suncode.plusocr.pluginconfigurationmanager.dto.SuncodeOcrConfigurationDto;
import com.suncode.plusocr.pluginconfigurationmanager.services.OcrConfigurationService;
import com.suncode.plusocr.suncodeocr.db.SuncodeOcrData;
import com.suncode.plusocr.suncodeocr.db.service.SuncodeOcrDataService;
import com.suncode.plusocr.suncodeocr.domain.OcrKey;
import com.suncode.plusocr.suncodeocr.domain.OpenAIOcrKey;
import com.suncode.plusocr.suncodeocr.domain.SuncodeOcrKey;
import com.suncode.plusocr.suncodeocr.dto.OpenAIOcrKeyDto;
import com.suncode.plusocr.suncodeocr.dto.StructuredJsonData;
import com.suncode.plusocr.suncodeocr.service.SuncodeOcrService;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.component.ContextVariable;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenAIDataProcessingService {
    private static final Logger log = LoggerFactory.getLogger(OpenAIDataProcessingService.class);
    private static final int OPEN_AI_CACHE_LIFETIME = 86400000;
    @Autowired
    private SuncodeOcrDataService dataService;
    @Autowired
    private SuncodeOcrService suncodeOcrService;
    @Autowired
    private OcrConfigurationService ocrConfigurationService;

    public Map<String, Object> processOpenAiData(DocumentContext documentContext, List<String> basicKeys, String[] extraFieldsKey, Variable[] extraFieldVariable, String[] extraFieldEnums, FunctionCall[] extraFieldPattern, Map<String, Object> extractedOcrData, SuncodeOcrData suncodeOcrData, Map<Variable, FunctionCall> functionParams, boolean forceOpenAiInvoiceLineReading, int openAiLineThreshold) {
        try {
            boolean readInvoiceLinesWithOpenAi = this.shouldReadInvoiceLinesWithOpenAI(basicKeys, extractedOcrData, forceOpenAiInvoiceLineReading, openAiLineThreshold);
            List<OpenAIOcrKeyDto> openAiFields = this.extractOpenAiFields(basicKeys, extraFieldsKey, extraFieldVariable, extraFieldEnums, extraFieldPattern, extractedOcrData, functionParams, readInvoiceLinesWithOpenAi);
            return this.getOpenAiData(documentContext, extractedOcrData, openAiFields, suncodeOcrData);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private boolean shouldReadInvoiceLinesWithOpenAI(List<String> basicKeys, Map<String, Object> extractedOcrData, boolean forceOpenAiInvoiceLineReading, int openAiLineThreshold) {
        List<OpenAIOcrKeyDto> basicFieldsUsedInConfiguration = OpenAIOcrKey.findKeysByNames(basicKeys);
        boolean isInvoiceTableFieldInBasicFields = basicFieldsUsedInConfiguration.stream().anyMatch(field -> StringUtils.equals((CharSequence)field.getTableName(), (CharSequence)"INVOICE_Items"));
        int numberOfItemsInInvoiceTable = ((Double[])extractedOcrData.get(SuncodeOcrKey.INVOICE_ITEM_AMOUNT_AMOUNT.getKey())).length;
        return isInvoiceTableFieldInBasicFields || forceOpenAiInvoiceLineReading && numberOfItemsInInvoiceTable <= openAiLineThreshold;
    }

    private List<OpenAIOcrKeyDto> extractOpenAiFields(List<String> basicKeysNames, String[] extraFieldsKey, Variable[] extraFieldVariable, String[] extraFieldEnums, FunctionCall[] extraFieldPattern, Map<String, Object> extractedOcrData, Map<Variable, FunctionCall> functionParams, boolean readInvoiceLinesWithOpenAi) {
        LinkedList<OpenAIOcrKeyDto> result = new LinkedList<OpenAIOcrKeyDto>();
        result.addAll(this.extractOpenAIOcrKeysFromBasicFields(basicKeysNames, extractedOcrData));
        result.addAll(this.getMisreadFieldsByDI(basicKeysNames, new ArrayList<FunctionCall>(functionParams.values()), extractedOcrData));
        result.addAll(this.validateInvoiceAmounts(extractedOcrData));
        result.addAll(this.getOpenAiFieldsFromFunctions(new ArrayList<FunctionCall>(functionParams.values())));
        result.addAll(this.buildExtraFields(extraFieldsKey, extraFieldVariable, extraFieldEnums, extraFieldPattern));
        if (readInvoiceLinesWithOpenAi) {
            result.addAll(this.getInvoiceTableFields(basicKeysNames, new ArrayList<FunctionCall>(functionParams.values())));
        }
        return OpenAIDataProcessingService.removeDuplicatesById(result);
    }

    private List<OpenAIOcrKeyDto> extractOpenAIOcrKeysFromBasicFields(List<String> basicKeysNames, Map<String, Object> extractedOcrData) {
        List<OpenAIOcrKeyDto> basicFieldsUsedInConfiguration = OpenAIOcrKey.findKeysByNames(basicKeysNames);
        String invoiceId = (String)extractedOcrData.get(SuncodeOcrKey.INVOICE_INVOICE_ID.getKey());
        OpenAIOcrKey.injectInvoiceId(basicFieldsUsedInConfiguration, invoiceId);
        return basicFieldsUsedInConfiguration;
    }

    private List<OpenAIOcrKeyDto> getMisreadFieldsByDI(List<String> basicKeysNames, List<FunctionCall> functionCalls, Map<String, Object> extractedOcrData) {
        List contextVariables = functionCalls.stream().flatMap(functionCall -> functionCall.getContextVariables().stream()).map(ContextVariable::getName).collect(Collectors.toList());
        return Stream.concat(basicKeysNames.stream(), contextVariables.stream()).map(SuncodeOcrKey::getByKey).filter(Objects::nonNull).filter(suncodeOcrKey -> !suncodeOcrKey.isValid(extractedOcrData.get(suncodeOcrKey.getKey())) || extractedOcrData.get(suncodeOcrKey.getKey()) == null).map(suncodeOcrKey -> {
            String tableId = Types.isArray(suncodeOcrKey.getType()) ? suncodeOcrKey.getKey().substring(0, suncodeOcrKey.getKey().indexOf(".")) : "";
            return this.suncodeOcrKeyToOpenAIOcrKeyDto((SuncodeOcrKey)suncodeOcrKey, tableId);
        }).collect(Collectors.toList());
    }

    private OpenAIOcrKeyDto suncodeOcrKeyToOpenAIOcrKeyDto(SuncodeOcrKey key, String tableId) {
        String id = StringUtils.isBlank((CharSequence)tableId) ? key.getKey() : key.getKey().replace(tableId + ".", "");
        return OpenAIOcrKey.createOpenAiKey(id, key.getKey(), key.getType(), Collections.emptyList(), "", tableId, false);
    }

    private List<OpenAIOcrKeyDto> validateInvoiceAmounts(Map<String, Object> extractedOcrData) {
        LinkedList<OpenAIOcrKeyDto> result = new LinkedList<OpenAIOcrKeyDto>();
        Double netAmount = (Double)extractedOcrData.get(SuncodeOcrKey.INVOICE_SUB_TOTAL_AMOUNT.getKey());
        Double taxAmount = (Double)extractedOcrData.get(SuncodeOcrKey.INVOICE_TOTAL_TAX_AMOUNT.getKey());
        Double grossAmount = (Double)extractedOcrData.get(SuncodeOcrKey.INVOICE_INVOICE_TOTAL_AMOUNT.getKey());
        if (netAmount == null || taxAmount == null || grossAmount == null || !grossAmount.equals(netAmount + taxAmount)) {
            result.add(this.suncodeOcrKeyToOpenAIOcrKeyDto(SuncodeOcrKey.INVOICE_SUB_TOTAL_AMOUNT, ""));
            result.add(this.suncodeOcrKeyToOpenAIOcrKeyDto(SuncodeOcrKey.INVOICE_TOTAL_TAX_AMOUNT, ""));
            result.add(this.suncodeOcrKeyToOpenAIOcrKeyDto(SuncodeOcrKey.INVOICE_INVOICE_TOTAL_AMOUNT, ""));
        }
        return result;
    }

    private List<OpenAIOcrKeyDto> buildExtraFields(String[] extraFieldsKey, Variable[] extraFieldVariable, String[] extraFieldEnums, FunctionCall[] extraFieldPattern) {
        return IntStream.range(0, extraFieldEnums.length).mapToObj(i -> {
            List<String> enums = extraFieldEnums[i] == null ? Collections.emptyList() : Arrays.asList(extraFieldEnums[i].split("\\|"));
            return OpenAIOcrKey.createOpenAiKey(extraFieldsKey[i], extraFieldsKey[i], extraFieldVariable[i].getType(), enums, extraFieldPattern[i] == null ? "" : (String)extraFieldPattern[i].call(), null, true);
        }).collect(Collectors.toList());
    }

    private List<OpenAIOcrKeyDto> getOpenAiFieldsFromFunctions(List<FunctionCall> functionCalls) {
        List contextVariables = functionCalls.stream().map(FunctionCall::getContextVariables).flatMap(Collection::stream).collect(Collectors.toList());
        return contextVariables.stream().map(variable -> OpenAIOcrKey.findKeysById(variable.getId().replace("context:", ""))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<OpenAIOcrKeyDto> getInvoiceTableFields(List<String> basicKeysNames, List<FunctionCall> functionCalls) {
        List allInvoiceTableFields = OcrKey.streamInvoiceTable(SuncodeOcrKey.class).map(suncodeOcrKey -> this.suncodeOcrKeyToOpenAIOcrKeyDto((SuncodeOcrKey)suncodeOcrKey, "INVOICE_Items")).collect(Collectors.toList());
        List contextVariablesNames = functionCalls.stream().map(FunctionCall::getContextVariables).flatMap(Collection::stream).map(key -> key.getId().replace("context:", "")).collect(Collectors.toList());
        return allInvoiceTableFields.stream().filter(field -> basicKeysNames.contains(field.getName()) || contextVariablesNames.contains(field.getName())).collect(Collectors.toList());
    }

    public static List<OpenAIOcrKeyDto> removeDuplicatesById(List<OpenAIOcrKeyDto> list) {
        HashSet seenIds = new HashSet();
        return list.stream().filter(item -> item.getId() != null && seenIds.add(item.getId())).collect(Collectors.toList());
    }

    public Map<String, Object> getOpenAiData(DocumentContext documentContext, Map<String, Object> extractedOcrData, List<OpenAIOcrKeyDto> openAiFields, SuncodeOcrData suncodeOcrData) {
        try {
            if (openAiFields.isEmpty()) {
                return Collections.emptyMap();
            }
            StructuredJsonData extraInvoiceFields = this.readOpenAiCacheData(suncodeOcrData);
            if (!this.containsAllKeys(extraInvoiceFields, openAiFields)) {
                extraInvoiceFields = this.readInvoiceUsingOpenAI(documentContext, extractedOcrData, openAiFields, suncodeOcrData.getPcmConfigId());
                this.saveOpenAiCacheData(suncodeOcrData, extraInvoiceFields.getJsonRaw());
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Map<String, Map<String, String>> mergedAllTablesFromOpenAiResponse = this.mergeAllTables(extraInvoiceFields.getTables());
            for (OpenAIOcrKeyDto openAiField : openAiFields) {
                Object value;
                String key = openAiField.getName();
                if (StringUtils.isBlank((CharSequence)openAiField.getTableName())) {
                    String ravValue = extraInvoiceFields.getHeaderFields().get(openAiField.getId());
                    value = openAiField.getTargetType().convert(ravValue);
                } else {
                    String tableValue = mergedAllTablesFromOpenAiResponse.get(openAiField.getTableName()).get(openAiField.getId());
                    value = openAiField.getTargetType().convert(tableValue);
                }
                result.put(key, value);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public boolean containsAllKeys(StructuredJsonData extraInvoiceFields, List<OpenAIOcrKeyDto> openAiFields) {
        List requiredKeys = openAiFields.stream().map(OpenAIOcrKeyDto::getId).collect(Collectors.toList());
        HashSet<String> availableKeys = new HashSet<String>();
        if (extraInvoiceFields.getHeaderFields() != null) {
            availableKeys.addAll(extraInvoiceFields.getHeaderFields().keySet());
        }
        if (extraInvoiceFields.getTables() != null) {
            for (List<Map<String, Object>> table : extraInvoiceFields.getTables().values()) {
                for (Map<String, Object> row : table) {
                    availableKeys.addAll(row.keySet());
                }
            }
        }
        return availableKeys.containsAll(requiredKeys);
    }

    private StructuredJsonData readOpenAiCacheData(SuncodeOcrData suncodeOcrData) {
        Date openAiSetData = suncodeOcrData.getOpenAiLastUpdateDate();
        if (openAiSetData != null && openAiSetData.after(new Date(System.currentTimeMillis() - 86400000L))) {
            try {
                return this.suncodeOcrService.convertJSONToStructuredJsonData(suncodeOcrData.getOpenAiContent());
            }
            catch (JsonProcessingException e) {
                log.warn("JSON OpenAi cache data reading error", (Throwable)e);
            }
        }
        return StructuredJsonData.builder().build();
    }

    private void saveOpenAiCacheData(SuncodeOcrData suncodeOcrData, String jsonToSave) {
        suncodeOcrData.setOpenAiLastUpdateDate(new Date());
        suncodeOcrData.setOpenAiContent(jsonToSave);
        this.dataService.update(suncodeOcrData);
    }

    private StructuredJsonData readInvoiceUsingOpenAI(DocumentContext documentContext, Map<String, Object> extractedOcrData, List<OpenAIOcrKeyDto> openAiFields, String pcmConfig) {
        try {
            Map<String, Object> invoiceHeaderData = extractedOcrData.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("INVOICE")).filter(entry -> entry.getValue() != null && (!(entry.getValue() instanceof String) || !((String)entry.getValue()).isEmpty())).filter(entry -> !entry.getValue().getClass().isArray()).collect(Collectors.toMap(entry -> ((String)entry.getKey()).replace("INVOICE_", ""), entry -> entry.getValue() instanceof String ? entry.getValue() : entry.getValue().toString()));
            String invoiceContent = (String)documentContext.read("$.analyzeResult.content", new Predicate[0]);
            SuncodeOcrConfigurationDto configurationDto = StringUtils.isBlank((CharSequence)pcmConfig) ? this.ocrConfigurationService.readConfigurationFile().getSuncodeOcr() : this.ocrConfigurationService.readConfigurationFile(pcmConfig).getSuncodeOcr();
            return this.suncodeOcrService.readExtraInvoiceFields(configurationDto, invoiceContent, invoiceHeaderData, openAiFields);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return StructuredJsonData.builder().build();
        }
    }

    private Map<String, Map<String, String>> mergeAllTables(Map<String, List<Map<String, Object>>> tables) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<Map<String, Object>>> entry : tables.entrySet()) {
            result.put(entry.getKey(), this.mergeMaps(entry.getValue()));
        }
        return result;
    }

    private Map<String, String> mergeMaps(List<Map<String, Object>> listOfMaps) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map<String, Object> map : listOfMaps) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String cleanValue = entry.getValue() == null ? "" : entry.getValue().toString().replace(";", ",");
                result.merge(entry.getKey(), cleanValue, (oldVal, newVal) -> oldVal + ";" + newVal);
            }
        }
        return result;
    }
}

